package com.elitesland.yst.production.sale.core.convert;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * BigDecimal转换器.
 * <p>
 * 如果autoApply = true，则会全局统一处理，有些过于霸道，所以设置成false，需要的地方，在对应的DO的字段上加上注解即可，如
 *
 *     @Comment("商品售价")
 *     @Column(name = "price", columnDefinition = "decimal(20,4) default 0")
 *     @Convert(converter = BigDecimalConvert.class)
 *     private BigDecimal price;
 *
 * @author Kaiser（wang shao）
 * @date 2021-03-10
 */
@Converter(autoApply = false)
public class BigDecimalConvert implements AttributeConverter<BigDecimal, BigDecimal> {

    @Override
    public BigDecimal convertToDatabaseColumn(BigDecimal attribute) {
        if (attribute == null) {
            return BigDecimal.ZERO;
        }
        return attribute.setScale(2, RoundingMode.DOWN);
    }

    @Override
    public BigDecimal convertToEntityAttribute(BigDecimal dbData) {
        if (dbData == null) {
            return BigDecimal.ZERO;
        }
        return dbData.setScale(2, RoundingMode.DOWN);
    }
}
