package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "bip_send_order_err_log")
@org.hibernate.annotations.Table(appliesTo = "bip_send_order_err_log", comment = "退款失败调用订单异常处理")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipSendOrderErrLogDO extends BaseModel implements Serializable {

    @Column(name = "param", columnDefinition = "varchar(512)   comment '参数'")
    private String param;

    @Column(name = "count", columnDefinition = "int(10) default 0 comment '发送次数'")
    private Integer count;

    @Column(name = "type", columnDefinition = "varchar(32) comment '分类'")
    private String type;

}
