package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 8:07 下午
 */
@Entity
@Table(name = "sal_proj")
@org.hibernate.annotations.Table(appliesTo = "sal_proj", comment = "销售项目")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalProjDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 3157453116257302549L;

    @ApiModelProperty(value = "公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20) default null  comment '公司ID'")
    private Long ouId;

    @ApiModelProperty(value = "BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20) default null comment 'BUID'")
    private Long buId;

    @ApiModelProperty(value = "区域")
    @Column(name = "region", columnDefinition = "varchar(40) comment '区域 [UDC]SAL:SAL_REGION'")
    private String region;

    @ApiModelProperty("项目编号")
    @Column(name = "proj_no", columnDefinition = "varchar(40) comment '项目编号'")
    private String projNo;

    @ApiModelProperty("CRM项目编号")
    @Column(name = "proj_no2", columnDefinition = "varchar(40) comment 'CRM项目编号'")
    private String projNo2;

    @ApiModelProperty("项目类型")
    @Column(name = "proj_type", columnDefinition = "varchar(40) comment '项目类型 [UDC]SAL:PROJ_TYPE'")
    private String projType;

    @ApiModelProperty("项目状态")
    @Column(name = "proj_status", columnDefinition = "varchar(40) comment '项目状态'")
    private String projStatus;

    @ApiModelProperty("项目名称")
    @Column(name = "proj_name", columnDefinition = "varchar(200) comment '项目名称'")
    private String projName;

    @ApiModelProperty("项目地址")
    @Column(name = "proj_address", columnDefinition = "varchar(200) comment '项目名称'")
    private String projAddress;

    @ApiModelProperty("业务类型")
    @Column(name = "busi_type", columnDefinition = "varchar(40) comment '业务类型 [UDC]SAL:BUSINESS_TYPE'")
    private String busiType;

    @ApiModelProperty("渠道来源")
    @Column(name = "channel_type", columnDefinition = "varchar(40) comment '渠道来源 [UDC]SAL:CHANNEL'")
    private String channelType;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @ApiModelProperty("客户编号")
    @Column(name = "cust_code", columnDefinition = "varchar(40) comment '客户编号'")
    private String custCode;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(200) comment '客户名称'")
    private String custName;

    @ApiModelProperty("客户类型")
    @Column(name = "cust_type", columnDefinition = "varchar(40) comment '客户类型 [UDC]SAL:PROJ_CUST_TYPE'")
    private String custType;

    @ApiModelProperty("客户类型(正式/潜在)")
    @Column(name = "cust_type2", columnDefinition = "varchar(40) comment '客户类型(正式/潜在) [UDC]SAL:QT_TYPE'")
    private String custType2;

    @ApiModelProperty("客户来源")
    @Column(name = "cust_source", columnDefinition = "varchar(40) comment '客户来源 [UDC]CRM:CUST_SOURCE'")
    private String custSource;

    @ApiModelProperty("客户性质")
    @Column(name = "cust_prop", columnDefinition = "varchar(40) comment '客户性质 [UDC]CRM:CUST_PROP'")
    private String custProp;

    @ApiModelProperty("客户等级")
    @Column(name = "cust_level", columnDefinition = "varchar(40) comment '客户等级 [UDC]CRM:CUST_GROUP'")
    private String custLevel;

    @ApiModelProperty("客户负责人")
    @Column(name = "cust_pic", columnDefinition = "varchar(40) comment '客户负责人'")
    private String custPic;

    @ApiModelProperty("客户负责人电话")
    @Column(name = "cust_pic_tel", columnDefinition = "varchar(20) comment '客户负责人电话'")
    private String custPicTel;

    @ApiModelProperty("客户地址")
    @Column(name = "cust_address", columnDefinition = "varchar(200) comment '客户地址'")
    private String custAddress;

    @ApiModelProperty("合同ID")
    @Column(name = "contract_id", columnDefinition = "bigint(20) comment '合同ID'")
    private Long contractId;

    @ApiModelProperty("合同编号")
    @Column(name = "contract_code", columnDefinition = "varchar(40) comment '合同编号'")
    private String contractCode;

    @ApiModelProperty("合同名称")
    @Column(name = "contract_name", columnDefinition = "varchar(200) comment '合同名称'")
    private String contractName;

    @ApiModelProperty(value = "意向时间")
    @Column(name = "intent_time", columnDefinition = "datetime  comment '意向时间'")
    private LocalDate intentTime;

    @ApiModelProperty("意向等级")
    @Column(name = "intent_level", columnDefinition = "varchar(40) comment '意向等级'")
    private String intentLevel;

    @ApiModelProperty("财务属性")
    @Column(name = "fin_prop", columnDefinition = "varchar(40) comment '财务属性 [UDC]CRM:FINANCIAL_ATTRIBUTE'")
    private String finProp;

    @ApiModelProperty("证件类型")
    @Column(name = "id_type", columnDefinition = "varchar(40) comment '证件类型'")
    private String idType;

    @ApiModelProperty("证件号码")
    @Column(name = "id_no", columnDefinition = "varchar(40) comment '证件号码'")
    private String idNo;

    @ApiModelProperty(value = "证件失效日期")
    @Column(name = "id_expire_date", columnDefinition = "datetime  comment '证件失效日期'")
    private LocalDate idExpireDate;

    @ApiModelProperty(value = "报装户数")
    @Column(name = "install_num", columnDefinition = "bigint(18) default null comment '报装户数'")
    private Long installNum;

    @ApiModelProperty(value = "报装日期")
    @Column(name = "install_date", columnDefinition = "datetime comment '报装日期'")
    private LocalDate installDate;

    @ApiModelProperty(value = "施工时间")
    @Column(name = "construct_time", columnDefinition = "datetime comment '施工时间'")
    private LocalDate constructTime;

    @ApiModelProperty("施工资质要求")
    @Column(name = "construct_require", columnDefinition = "varchar(40) comment '施工资质要求'")
    private String constructRequire;

    @ApiModelProperty(value = "施工验收时间")
    @Column(name = "construct_confirm_time", columnDefinition = "datetime comment '施工验收时间'")
    private LocalDate constructConfirmTime;

    @ApiModelProperty("施工验收标准")
    @Column(name = "construct_confirm_standard", columnDefinition = "varchar(40) comment '施工验收标准'")
    private String constructConfirmStandard;

    @ApiModelProperty(value = "项目招标时间")
    @Column(name = "proj_bids_time", columnDefinition = "datetime comment '施工验收时间'")
    private LocalDate projBidsTime;

    @ApiModelProperty(value = "项目安装时间")
    @Column(name = "proj_install_time", columnDefinition = "datetime comment '项目安装时间'")
    private LocalDate projInstallTime;

    @ApiModelProperty(value = "项目开盘时间")
    @Column(name = "proj_open_time", columnDefinition = "datetime comment '项目开盘时间'")
    private LocalDate projOpenTime;

    @ApiModelProperty("项目付款方式")
    @Column(name = "proj_pay_method", columnDefinition = "varchar(40) comment '项目付款方式 [UDC]SAL:PROJ_PAYMENT_TYPE'")
    private String projPayMethod;

    @ApiModelProperty(value = "通气时间")
    @Column(name = "same_time", columnDefinition = "datetime comment '同通气时间'")
    private LocalDate sameTime;

}
