package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfDPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHomeMenuPageVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipMessageQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QBipMessageDO;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.ArrayList;

@Component
@RequiredArgsConstructor
public class BusFirstMenuConfDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;


    public PagingVO<BusFirstMenuConfDVO> findPagingResult(BusFirstMenuConfDPagingParam param){
        JPAQuery<BusFirstMenuConfDVO> query = selectFromWhere(BusFirstMenuConfDVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qBusFirstMenuConfDDO);
        return PagingVO.<BusFirstMenuConfDVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, BusFirstMenuConfDPagingParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qBusFirstMenuConfDDO.id,
                qBusFirstMenuConfDDO.menuId,
                qBusFirstMenuConfDDO.ouId,
                qBusFirstMenuConfDDO.itemId,
                qBusFirstMenuConfDDO.itemName,
                qBusFirstMenuConfDDO.itemCode,
                qBusFirstMenuConfDDO.itemAttr,
                qBusFirstMenuConfDDO.barcode,
                qBusFirstMenuConfDDO.itemBrand)).from(qBusFirstMenuConfDDO).where(where(param));
    }

    public Predicate where(BusFirstMenuConfDPagingParam param){
        List<Predicate> predicate = new ArrayList<>();
        predicate.add(qBusFirstMenuConfDDO.ouId.eq(param.getOuId()));
        predicate.add(qBusFirstMenuConfDDO.menuId.eq(param.getMenuId()));
        predicate.add(qBusFirstMenuConfDDO.deleteFlag.isNull().or(qBusFirstMenuConfDDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }


    public List<BipHomeDetailVO> findHomeMenuDetail(Long ouId,Long menuId){
        BusFirstMenuConfDPagingParam param = new BusFirstMenuConfDPagingParam();
        param.setMenuId(menuId);
        param.setOuId(ouId);
        return selectFromWhere(BipHomeDetailVO.class, param).fetch();
    }

    public Predicate whereForHome(BipHomeMenuPageVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);;

        predicate = ExpressionUtils.and(predicate, qBusFirstMenuConfDDO.menuId.eq(param.getMenuId()));
        predicate = ExpressionUtils.and(predicate, qBusFirstMenuConfDDO.state.eq(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode()));
        predicate = ExpressionUtils.and(predicate, qBusFirstMenuConfDDO.deleteFlag.isNull().or(qBusFirstMenuConfDDO.deleteFlag.eq(0)));

        return predicate;
    }

}
