package com.elitesland.yst.production.sale.repo;


import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.vo.param.crm.*;
import com.elitesland.yst.production.sale.api.vo.resp.crm.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.CrmCustSimpleDTO;
import com.elitesland.yst.production.sale.dto.CustBaseInfoDTO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@Repository
public class CrmCustRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;

    @Autowired
    private CrmCustRepo crmCustRepo;




    public PagingVO<CrmCustPageLmVO> findPageCust(CrmCustQueryLmParam searchParam) {
        JPAQuery<CrmCustPageLmVO> query = selectFromWhere(CrmCustPageLmVO.class,searchParam);
        searchParam.setPaging(query);
        searchParam.fillOrders(query,qCrmCustDO);
        return PagingVO.<CrmCustPageLmVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public PagingVO<CustSalePredictionVO> queryCustSalePrediction(CustPredictionParamVO param) {
        JPAQuery<CustSalePredictionVO> query = selectSalePrediction(CustSalePredictionVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qCrmCustDO);
        return PagingVO.<CustSalePredictionVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public PagingVO<CrmCustBasePageVO> getCustBasePage(CrmCustBaseParamVO param) {
        JPAQuery<CrmCustBasePageVO> query = selectBaseFromWhere(CrmCustBasePageVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qCrmCustDO);
        return PagingVO.<CrmCustBasePageVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<CrmCustPageLmVO> searchExoprt(CrmCustQueryParam crmCustQueryParam) {
        JPAQuery<CrmCustPageLmVO> query = selectExport(CrmCustPageLmVO.class,crmCustQueryParam);
        return query.fetch();
    }


    private <T> JPAQuery<T> selectSalePrediction(Class<T> cls, CustPredictionParamVO param){
        return jpaQueryFactory.select(Projections.bean(cls,
                        qCrmCustDO.id,
                        qCrmCustDO.custCode,
                        qCrmCustDO.pid,
                        qCrmCustDO.custGroup,
                        qCrmCustDO.custName,
                        qCrmCustDO.outerCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.custType2,
                        qCrmCustDO.custType,
                        qCrmCustDO.region,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.custLevel,
                        qCrmCustDO.certNo,
                        qCrmCustDO.custCurr,
                        qCrmCustDO.country,
                        qCrmCustDO.taxpayerType,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.custStatus,
                        qCrmCustDO.isCreateOu,
                        qCrmCustDO.es1,
                        qCrmCustDO.corOu
                )).from(qCrmCustDO)
                .where(whereSalePrediction(param));
    }
    public Predicate whereSalePrediction(CustPredictionParamVO param){
        List<Predicate> list = new ArrayList<>();
        list.add(qCrmCustDO.deleteFlag.eq(0));
        if(CollectionUtil.isNotEmpty(param.getCustCodes())){
            list.add(qCrmCustDO.custCode.in(param.getCustCodes()));
        }
        if(CollectionUtil.isNotEmpty(param.getNotInCustCode())){
            list.add(qCrmCustDO.custCode.notIn(param.getNotInCustCode()));
        }
        if(CollectionUtil.isNotEmpty(param.getCustTypes())){
            list.add(qCrmCustDO.custType.in(param.getCustTypes()));
        }
        if(StringUtil.isNotBlank(param.getCustCode())){
            list.add(qCrmCustDO.custCode.contains(param.getCustCode()));
        }
        if(StringUtil.isNotBlank(param.getCustName())){
            list.add(qCrmCustDO.custName.contains(param.getCustName()));
        }
        if(StringUtil.isNotBlank(param.getCustStatus())){
            list.add(qCrmCustDO.custStatus.eq(param.getCustStatus()));
        }
        if(CollectionUtil.isNotEmpty(param.getIds())){
            list.add(qCrmCustDO.id.in(param.getIds()));
        }
        return ExpressionUtils.allOf(list);
    }


    private <T> JPAQuery<T> selectExport(Class<T> cls, CrmCustQueryParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                        qCrmCustDO.id,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custName,
                        qCrmCustDO.outerCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.custType2,
                        qCrmCustDO.custType,
                        qCrmCustDO.region,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.custLevel,
                        qCrmCustDO.certNo,
                        qCrmCustDO.custCurr,
                        qCrmCustDO.country,
                        qCrmCustDO.taxpayerType,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.custStatus
                )).from(qCrmCustDO)
                .where(whereExport(param));
    }

    public Predicate whereExport(CrmCustQueryParam param){
        List<Predicate> predicate = new ArrayList<>();
//        if(null != param.getI()){
//            predicate.add(qCrmCustDO.ouId.eq(param.getOuId()));
//        }else {
//            predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate(qCrmCustDO.getMetadata()));
//        }
        if(StringUtil.isNotBlank(param.getCustName())){
            predicate.add(qCrmCustDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCustName())){
            predicate.add(qCrmCustDO.custName.like("%" + param.getCustName() + "%"));
        }
        if(StringUtil.isNotBlank(param.getOuterCode())){
            predicate.add(qCrmCustDO.outerCode.like("%" + param.getOuterCode() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCustAbbr())){
            predicate.add(qCrmCustDO.custAbbr.like("%" + param.getCustAbbr() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCustCode2())){
            predicate.add(qCrmCustDO.custCode2.eq(param.getCustCode2()));
        }
        if(StringUtil.isNotBlank(param.getCustType2())){
            predicate.add(qCrmCustDO.custType2.eq(param.getCustType2()));
        }
        if(StringUtil.isNotBlank(param.getCustType())){
            predicate.add(qCrmCustDO.custType.eq(param.getCustType()));
        }
        if(StringUtil.isNotBlank(param.getCustStatus())){
            predicate.add(qCrmCustDO.custStatus.eq(param.getCustStatus()));
        }
        if(StringUtil.isNotBlank(param.getRegion())){
            predicate.add(qCrmCustDO.region.like("%" + param.getRegion() + "%"));
        }
        if(!ObjectUtils.isEmpty(param.getAgentEmpId())){
            predicate.add(qCrmCustDO.agentEmpId.eq(param.getAgentEmpId()));
        }
        if(StringUtil.isNotBlank(param.getContactName())){
            predicate.add(qCrmCustDO.contactName.like("%" + param.getContactName() + "%"));
        }
        if(StringUtil.isNotBlank(param.getContactPhone())){
            predicate.add(qCrmCustDO.contactPhone.like("%" + param.getContactPhone() + "%"));
        }
        if(StringUtil.isNotBlank(param.getPid())){
            predicate.add(qCrmCustDO.pid.like("%" + param.getPid() + "%"));
        }
        predicate.add(qCrmCustDO.deleteFlag.isNull().or(qCrmCustDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }


    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, CrmCustQueryLmParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qCrmCustDO.id,
                qCrmCustDO.custCode,
                qCrmCustDO.pid,
                qCrmCustDO.custGroup,
                qCrmCustDO.custName,
                qCrmCustDO.outerCode,
                qCrmCustDO.custCode2,
                qCrmCustDO.custAbbr,
                qCrmCustDO.custType2,
                qCrmCustDO.custType,
                qCrmCustDO.region,
                qCrmCustDO.agentEmpId,
                qCrmCustDO.custLevel,
                qCrmCustDO.certNo,
                qCrmCustDO.custCurr,
                qCrmCustDO.country,
                qCrmCustDO.taxpayerType,
                qCrmCustDO.contactName,
                qCrmCustDO.contactPhone,
                qCrmCustDO.custStatus,
                qCrmCustDO.isCreateOu,
                qCrmCustDO.es1,
                qCrmCustDO.corOu
                )).from(qCrmCustDO)
                .where(where(param));
    }



    private <T> JPAQuery<T> selectBaseFromWhere(Class<T> cls, CrmCustBaseParamVO param){
        return jpaQueryFactory.select(Projections.bean(cls,
                        qCrmCustDO.id,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.custType2,
                        qCrmCustDO.custType,
                        qCrmCustDO.region,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.country,
                        qCrmCustDO.custStatus,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.cancelCustFlag
                )).from(qCrmCustDO)
                .where(whereBase(param));
    }

    public Predicate whereBase(CrmCustBaseParamVO param){
        List<Predicate> predicate = new ArrayList<>();
        predicate.add(qCrmCustDO.deleteFlag.eq(0));
        if(StringUtil.isNotBlank(param.getRegion())){
            predicate.add(qCrmCustDO.region.eq(param.getRegion()));
        }
        if(!ObjectUtils.isEmpty(param.getAgentEmpId())){
            predicate.add(qCrmCustDO.agentEmpId.eq(param.getAgentEmpId()));
        }
        if(!ObjectUtils.isEmpty(param.getCustType()) && !CollectionUtils.isEmpty(param.getCustType())){
            predicate.add(qCrmCustDO.custType.in(param.getCustType()));
        }
        if(!StringUtil.isBlank(param.getCustStatus())){
            predicate.add(qCrmCustDO.custStatus.eq(param.getCustStatus()));
        }
        if(StringUtil.isNotBlank(param.getCust())){
            predicate.add(qCrmCustDO.custCode.contains(param.getCust()).or(qCrmCustDO.custName.contains(param.getCust())));
        }
        if(!ObjectUtils.isEmpty(param.getCancelCustFlag())){
            predicate.add(qCrmCustDO.cancelCustFlag.eq(param.getCancelCustFlag()));
        }
        if(StringUtil.isNotBlank(param.getCustType1())){
            predicate.add(qCrmCustDO.custType.contains(param.getCustType1()));
        }
        return ExpressionUtils.allOf(predicate);
    }

    public Predicate where(CrmCustQueryLmParam param){
        List<Predicate> predicate = new ArrayList<>();
//        if(null != param.getI()){
//            predicate.add(qCrmCustDO.ouId.eq(param.getOuId()));
//        }else {
//            predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate(qCrmCustDO.getMetadata()));
//        }
        if(StringUtil.isNotBlank(param.getCust())){
            predicate.add(qCrmCustDO.custCode.contains(param.getCust()).or(qCrmCustDO.custCode2.contains(param.getCust())).or(qCrmCustDO.custName.contains(param.getCust())));
        }

        if(!CollectionUtils.isEmpty(param.getCustTypes())){
            predicate.add(qCrmCustDO.custType.in(param.getCustTypes()));
        }

        if(!ObjectUtils.isEmpty(param.getIsSearchPid()) && Boolean.TRUE.equals(param.getIsSearchPid()) && StringUtil.isNotBlank(param.getCustCode())){
            //查询自己带下级
//            predicate.add(qCrmCustDO.pid.eq(param.getCustCode()).or(qCrmCustDO.custCode.like("%" + param.getCustCode() + "%")));
            //只查询下级
            predicate.add(qCrmCustDO.pid.eq(param.getCustCode()));
        }else {
            if(StringUtil.isNotBlank(param.getCustCode())){
                predicate.add(qCrmCustDO.custCode.like("%" + param.getCustCode() + "%"));
            }
        }
        if(StringUtil.isNotBlank(param.getCustName())){
            predicate.add(qCrmCustDO.custName.like("%" + param.getCustName() + "%"));
        }
        if(StringUtil.isNotBlank(param.getOuterCode())){
            predicate.add(qCrmCustDO.outerCode.like("%" + param.getOuterCode() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCustAbbr())){
            predicate.add(qCrmCustDO.custAbbr.like("%" + param.getCustAbbr() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCustCode2())){
            predicate.add(qCrmCustDO.custCode2.like("%" + param.getCustCode2() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCustType2())){
            predicate.add(qCrmCustDO.custType2.eq(param.getCustType2()));
        }
        if(StringUtil.isNotBlank(param.getCustType())){
            predicate.add(qCrmCustDO.custType.eq(param.getCustType()));
        }
        if(StringUtil.isNotBlank(param.getCustStatus())){
            predicate.add(qCrmCustDO.custStatus.eq(param.getCustStatus()));
        }
        if(StringUtil.isNotBlank(param.getRegion())){
            predicate.add(qCrmCustDO.region.like("%" + param.getRegion() + "%"));
        }
        if(!ObjectUtils.isEmpty(param.getAgentEmpId())){
            predicate.add(qCrmCustDO.agentEmpId.eq(param.getAgentEmpId()));
        }
        if(!ObjectUtils.isEmpty(param.getCustGroup())){
            predicate.add(qCrmCustDO.custGroup.eq(param.getCustGroup()));
        }
        if(StringUtil.isNotBlank(param.getContactName())){
            predicate.add(qCrmCustDO.contactName.like("%" + param.getContactName() + "%"));
        }
        if(StringUtil.isNotBlank(param.getContactPhone())){
            predicate.add(qCrmCustDO.contactPhone.like("%" + param.getContactPhone() + "%"));
        }
        if(StringUtil.isNotBlank(param.getPid())){
            predicate.add(qCrmCustDO.pid.like("%" + param.getPid() + "%"));
        }


        predicate.add(qCrmCustDO.deleteFlag.isNull().or(qCrmCustDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }

    public List<LmSaveCustRespVO> findInvCustCodes(List<String> custCodes) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.custType
                ))
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.in(custCodes).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByRegion(List<String> region) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region
                ))
                .from(qCrmCustDO)
                .where(qCrmCustDO.region.in(region).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch();
    }


    /**
     * 获取客户名称
     *
     * @param id 客户ID
     * @return 客户名称
     */
    public String getCustName(Long id) {
        return jpaQueryFactory.select(qCrmCustDO.custName)
                .from(qCrmCustDO)
                .where(qCrmCustDO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取客户名称
     *
     * @param custCode 客户编码
     * @return 客户名称
     */
    public Long getAgentEmpId(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.agentEmpId)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.eq(0)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取客户区域
     *
     * @param custCode 客户编码
     * @return 客户名称
     */
    public String getCustRegion(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.region)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.eq(0)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取客户状态
     *
     * @param custCode 客户编码
     * @return 客户名称
     */
    public String getCustStatusByCode(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.custStatus)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.eq(0)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取客户的名称
     *
     * @param custCode 客户编号
     * @return 地址号
     */
    public String getCustName(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.custName)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.eq(0)))
                .limit(1)
                .fetchOne();
    }

    public List<CustBaseInfoDTO> getCustBaseInfo(CustCode2BaseParam param){
        return jpaQueryFactory.select(Projections.bean(CustBaseInfoDTO.class,
                    qCrmCustDO.custCode,
                    qCrmCustDO.id,
                    qCrmCustDO.custName,
                    qCrmCustDO.custCode2,
                    qCrmCustDO.custType,
                    qCrmCustDO.custType2,
                    qCrmCustDO.custAbbr,
                    qCrmCustDO.outerCode,
                    qCrmCustDO.autoCreditFlag
                )).from(qCrmCustDO)
                .where(whereCustCode2OrCustCode(param))
                .fetch();
    }
    public Predicate whereCustCode2OrCustCode(CustCode2BaseParam param){
        List<Predicate> predicate = new ArrayList<>();
        if(StringUtil.isNotBlank(param.getCustAbbr())){
            predicate.add(qCrmCustDO.custAbbr.contains(param.getCustAbbr()));
        }
        if(StringUtil.isNotBlank(param.getCustName())){
            predicate.add(qCrmCustDO.custName.contains(param.getCustName()));
        }
        if(!CollectionUtils.isEmpty(param.getCustCode())){
            predicate.add(qCrmCustDO.custCode.in(param.getCustCode()));
        }
        if(!CollectionUtils.isEmpty(param.getCustCode2())){
            predicate.add(qCrmCustDO.custCode2.in(param.getCustCode2()));
        }
        if(StringUtil.isNotBlank(param.getCustType())){
            predicate.add(qCrmCustDO.custType.eq(param.getCustType()));
        }
        if(StringUtil.isNotBlank(param.getCustType2())){
            predicate.add(qCrmCustDO.custType2.eq(param.getCustType2()));
        }
        predicate.add(qCrmCustDO.deleteFlag.isNull().or(qCrmCustDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }



    public List<CustCode2BaseDTO> getByCust2Base(CustCode2BaseParam param){
        return jpaQueryFactory.select(Projections.bean(CustCode2BaseDTO.class,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.id,
                        qCrmCustDO.custType,
                        qCrmCustDO.custName,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.legalRepre,
                        qCrmCustDO.provinceCode,
                        qCrmCustDO.region
                )).from(qCrmCustDO)
                .where(whereCustCode2(param))
                .fetch();
    }

    public Predicate whereCustCode2(CustCode2BaseParam param){
        List<Predicate> predicate = new ArrayList<>();
        if(!CollectionUtils.isEmpty(param.getCustCode())){
            predicate.add(qCrmCustDO.custCode.in(param.getCustCode()));
        }
        if(!CollectionUtils.isEmpty(param.getCustCode2())){
            predicate.add(qCrmCustDO.custCode2.in(param.getCustCode2()));
        }
        if(StringUtil.isNotBlank(param.getStatus())){
            predicate.add(qCrmCustDO.custStatus.in(param.getStatus()));
        }
        if(StringUtil.isNotBlank(param.getProvinceCode())){
            predicate.add(qCrmCustDO.provinceCode.eq(param.getProvinceCode()));
        }
        if(StringUtil.isNotBlank(param.getRegion())){
            predicate.add(qCrmCustDO.region.eq(param.getRegion()));
        }
        predicate.add(qCrmCustDO.deleteFlag.isNull().or(qCrmCustDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }



    public CustPrentInfoDTO getPrentCust(String custCode){
        return jpaQueryFactory.select(Projections.bean(CustPrentInfoDTO.class,
                        qCrmCustDO.custCode,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.region
                )).from(qCrmCustDO)
                .where(qCrmCustDO.deleteFlag.eq(0).and(qCrmCustDO.pid.eq(custCode)))
                .fetchOne();
    }


    /**
     * 获取客户的地址号
     *
     * @param id 客户ID
     * @return 地址号
     */
    public Long getAddrNo(Long id) {
        return jpaQueryFactory.select(qCrmCustDO.addrNo)
                .from(qCrmCustDO)
                .where(qCrmCustDO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    public Long getAddrNo(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.addrNo)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.eq(0)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取客户的主要信息
     *
     * @param id 客户ID
     * @return 客户信息
     */
    public CustDTO getCustSimpleInfo(Long id) {
        return jpaQueryFactory.select(Projections.bean(CustDTO.class,
                qCrmCustDO.id,
                qCrmCustDO.ouId,
                qCrmCustDO.buId,
                qCrmCustDO.custCode,
                qCrmCustDO.custName,
                qCrmCustDO.custLevel
        )).from(qCrmCustDO)
                .where(qCrmCustDO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据业务员查询关联业务员的客户
     *
     * @param agentEmpId 客户ID
     * @return 客户信息
     */
    public List<CrmCustBaseRespVO> getCustByEmpId(Long agentEmpId) {
        return jpaQueryFactory.select(Projections.bean(CrmCustBaseRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custName,
                        qCrmCustDO.country,
                        qCrmCustDO.region,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.addrNo
                )).from(qCrmCustDO)
                .where(qCrmCustDO.agentEmpId.eq(agentEmpId))
                .fetch();
    }

    public List<CrmCustBaseRespVO> getCustByEmpIds(List<Long> agentEmpIds) {
        return jpaQueryFactory.select(Projections.bean(CrmCustBaseRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custName,
                        qCrmCustDO.country,
                        qCrmCustDO.region,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.custAbbr
                )).from(qCrmCustDO)
                .where(qCrmCustDO.agentEmpId.in(agentEmpIds))
                .fetch();
    }

    /**
     * 搜索客户信息
     *
     * @param keyword 搜索关键字
     * @return 客户信息
     */
    public List<CrmCustSimpleDTO> query(String keyword) {
        keyword = "%" + keyword + "%";
        Predicate predicate = qCrmCustDO.custCode.like(keyword)
                .or(qCrmCustDO.custName.like(keyword));
        predicate = appendCommon(predicate);

        return jpaQueryFactory.select(qCrmCustDO.id, qCrmCustDO.custCode, qCrmCustDO.custName, qCrmCustDO.custAbbr)
                .from(qCrmCustDO)
                .where(predicate)
                .fetch()
                .stream()
                .map(tuple -> {
                    CrmCustSimpleDTO dto = new CrmCustSimpleDTO();
                    dto.setId(tuple.get(qCrmCustDO.id));
                    dto.setCustCode(tuple.get(qCrmCustDO.custCode));
                    dto.setCustName(tuple.get(qCrmCustDO.custName));
                    dto.setCustAbbr(tuple.get(qCrmCustDO.custAbbr));

                    return dto;
                }).collect(Collectors.toList());
    }

    /**
     * 根据税务登记号获取公司信息
     *
     * @param taxRegNo 税务登记号
     * @return 公司信息
     */
    public CrmCustDO getByTaxRegNo(String taxRegNo) {
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(qCrmCustDO.taxRegNo.eq(taxRegNo))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据客户编号查询客户信息
     * @param custCode
     * @return
     */
    public CrmCustDO getCustInfoByCode(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.eq(0)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 添加通用的条件
     *
     *
     * @param predicate 条件
     * @return 条件
     */
    private Predicate appendCommon(Predicate predicate) {
        return ExpressionUtils.and(predicate, qCrmCustDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO));
    }

    /**
     * 判断客户名称是否已存在
     *
     * @param id 客户ID
     * @return 客户名称
     */
    public Boolean exists(String custName, Long id) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custName) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.custName.eq(custName));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.id.ne(id));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }


    public Boolean existsMobile(String mobile, Long id) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(mobile) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.contactPhone.eq(mobile));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.id.ne(id));
        predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType.in("ONE","TWO"));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }



    public Boolean existsMobileAndBusinessType(String mobile, Long id,String businessType) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(mobile) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.contactPhone.eq(mobile));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.id.ne(id));
        predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType.in("ONE","TWO"));
        predicate = ExpressionUtils.and(predicate,qCrmCustDO.businessTypeCust.eq(businessType));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }


    public Boolean existsCustCode2(String custCode2, Long id) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custCode2) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.custCode2.eq(custCode2));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.id.ne(id));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    /**
     * 判断客户名称是否已存在
     *
     * @param id       客户ID
     * @param taxRegNo 税务登记号
     */
    public Boolean existsTaxRegNo(String taxRegNo, Long id,String businessTypeCust) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(taxRegNo) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.taxRegNo.eq(taxRegNo));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.id.ne(id));
        predicate = StringUtils.isEmpty(businessTypeCust) ? predicate : ExpressionUtils.and(predicate,qCrmCustDO.businessTypeCust.eq(businessTypeCust));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }


    public CrmCustDO getDoByCustCode(String custCode){
        BooleanExpression e = qCrmCustDO.deleteFlag.eq(0).and(qCrmCustDO.custCode.eq(custCode));
        Optional<CrmCustDO> optional = crmCustRepo.findOne(e);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }

    /**
     * 判断客户编码和所属公司是否已存在
     *
     * @param ouId     公司id
     * @param custCode 客户编码
     * @return 客户名称
     */
    public Boolean existsCodeAndOuId(String custCode, Long ouId) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custCode) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.custCode.eq(custCode));
        predicate = StringUtils.isEmpty(ouId) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(ouId));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    /**
     * 判断客户名称是否已存在
     *
     * @param id 客户ID
     * @return 客户名称
     */
    public Boolean existsCode(String custCode, Long id) {
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custCode) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.custCode.eq(custCode));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.id.ne(id));
        return jpaQueryFactory.select(qCrmCustDO)
                .from(qCrmCustDO)
                .where(predicate)
                .fetchCount() > 0;
    }
    /**
     * 判断客户名称是否已存在
     *
     * @param id 客户ID
     * @return 客户名称
     */
    public void updateAddrNo(Long id,Long addrNo) {
        jpaQueryFactory.update(qCrmCustDO).set(qCrmCustDO.addrNo, addrNo).where(qCrmCustDO.id.eq(id)).execute();
    }

    public List<CrmCustRespDTO> queryAllByAgentEmpId(Long agentEmpId) {
        return jpaQueryFactory.select(
                qCrmCustDO.taxRateNo,
                qCrmCustDO.taxRate, qCrmCustDO.region,
                qCrmCustDO.custCurr, qCrmCustDO.agentEmpId
                )
                .from(qCrmCustDO)
                .where(qCrmCustDO.agentEmpId.eq(agentEmpId).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch()
                .parallelStream()
                .map(tuple -> {
                    CrmCustRespDTO crmCustRespDTO = new CrmCustRespDTO();

                    crmCustRespDTO.setTaxRateNo(tuple.get(qCrmCustDO.taxRateNo));
                    crmCustRespDTO.setTaxRate(tuple.get(qCrmCustDO.taxRate));
                    crmCustRespDTO.setRegion(tuple.get(qCrmCustDO.region));
                    crmCustRespDTO.setCustCurr(tuple.get(qCrmCustDO.custCurr));
                    crmCustRespDTO.setAgentEmpId(tuple.get(qCrmCustDO.agentEmpId));
                    return crmCustRespDTO;
                })
                .collect(Collectors.toList());
    }

    public BigDecimal getCreditLimitById(Long id) {
//        return jpaQueryFactory.select(qCrmCustDO.creditLimit)
//                .from(qCrmCustDO)
//                .where(qCrmCustDO.id.eq(id).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
//                .fetchOne();
        return null;
    }

    public String getStatusById(Long id) {
        return jpaQueryFactory.select(qCrmCustDO.custStatus)
                .from(qCrmCustDO)
                .where(qCrmCustDO.id.eq(id).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }

    public Long getaddrNoByCode(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.addrNo)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }

    public String getCustNameByPidCode(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.custName)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }

    public List<CrmCustSimpleVO> getCustByName(String custName) {
        return jpaQueryFactory.select(qCrmCustDO.custCode,
                qCrmCustDO.id, qCrmCustDO.custName, qCrmCustDO.custAbbr)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custName.eq(custName).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch()
                .parallelStream()
                .map(tuple -> {
                    CrmCustSimpleVO crmCustSimpleVO = new CrmCustSimpleVO();
                    crmCustSimpleVO.setId(tuple.get(qCrmCustDO.id));
                    crmCustSimpleVO.setCustName(tuple.get(qCrmCustDO.custName));
                    crmCustSimpleVO.setCustCode(tuple.get(qCrmCustDO.custCode));
                    crmCustSimpleVO.setCustAbbr(tuple.get(qCrmCustDO.custAbbr));
                    return crmCustSimpleVO;
                }).collect(Collectors.toList());
    }

    public List<CrmCustSimpleVO> getCustByCodes(List<String> custCodes) {
        return jpaQueryFactory.select(qCrmCustDO.custCode,
                qCrmCustDO.id, qCrmCustDO.custName, qCrmCustDO.custAbbr)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.in(custCodes).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch()
                .parallelStream()
                .map(tuple -> {
                    CrmCustSimpleVO crmCustSimpleVO = new CrmCustSimpleVO();
                    crmCustSimpleVO.setId(tuple.get(qCrmCustDO.id));
                    crmCustSimpleVO.setCustName(tuple.get(qCrmCustDO.custName));
                    crmCustSimpleVO.setCustCode(tuple.get(qCrmCustDO.custCode));
                    crmCustSimpleVO.setCustAbbr(tuple.get(qCrmCustDO.custAbbr));
                    return crmCustSimpleVO;
                }).collect(Collectors.toList());
    }

    public List<CrmCustSimpleDTO> getCustByCode(String custCode) {
        return jpaQueryFactory.select(qCrmCustDO.custCode,
                qCrmCustDO.id, qCrmCustDO.custName, qCrmCustDO.custAbbr,
                qCrmCustDO.contactPhone,qCrmCustDO.contactName)
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch()
                .parallelStream()
                .map(tuple -> {
                    CrmCustSimpleDTO dto = new CrmCustSimpleDTO();
                    dto.setId(tuple.get(qCrmCustDO.id));
                    dto.setCustCode(tuple.get(qCrmCustDO.custCode));
                    dto.setCustName(tuple.get(qCrmCustDO.custName));
                    dto.setCustAbbr(tuple.get(qCrmCustDO.custAbbr));
                    dto.setContactName(tuple.get(qCrmCustDO.contactName));
                    dto.setContactPhone(tuple.get(qCrmCustDO.contactPhone));
                    return dto;
                }).collect(Collectors.toList());
    }

    public List<CrmCustSimpleVO> findIdByNameAndTaxRegNo(String custName, String taxRegNo){
        Predicate predicate = qCrmCustDO.deleteFlag.eq(0).or(qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custName) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.custName.eq(custName));
        predicate = StringUtils.isEmpty(taxRegNo) ? predicate : ExpressionUtils.and(predicate, qCrmCustDO.taxRegNo.eq(taxRegNo));
        return jpaQueryFactory.select(qCrmCustDO.id,qCrmCustDO.custCode,qCrmCustDO.addrNo)
                .from(qCrmCustDO)
                .where(predicate)
                .fetch()
                .stream()
                .map(tuple -> {
                    CrmCustSimpleVO dto = new CrmCustSimpleVO();
                    dto.setId(tuple.get(qCrmCustDO.id));
                    dto.setCustCode(tuple.get(qCrmCustDO.custCode));
                    dto.setAddrNo(tuple.get(qCrmCustDO.addrNo));
                    return dto;
                }).collect(Collectors.toList());
    }


    public LmSaveCustRespVO getCustInfoByCustCode(String custCode) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invBankName,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.custCurr,
                        qCrmCustDO.taxerNo,
                        qCrmCustDO.pid,
                        qCrmCustDO.invType,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.custType,
                        qCrmCustDO.corOu,
                        qCrmCustDO.storeOrderFlag,
                        qCrmCustDO.legalRepre
                ))
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }

    public List<LmSaveCustRespVO> getCustInfoByParam(CustAddrFindParam param) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.storeOrderFlag,
                        qCrmCustDO.custType
                ))
                .from(qCrmCustDO)
                .where(custInfoByParamWhere(param))
                .fetch();
    }

    private Predicate custInfoByParamWhere(CustAddrFindParam param){
        List<Predicate> list = new ArrayList<>();
        list.add(qCrmCustDO.deleteFlag.eq(0));
        if(!CollectionUtils.isEmpty(param.getCustCodes())){
            list.add(qCrmCustDO.custCode.in(param.getCustCodes()));
        }
        if(!StringUtil.isBlank(param.getCustCode2())){
            list.add(qCrmCustDO.custCode2.contains(param.getCustCode2()));
        }
        if(!StringUtil.isBlank(param.getCustName())){
            list.add(qCrmCustDO.custName.contains(param.getCustName()));
        }
        if(!StringUtil.isBlank(param.getCustCode())){
            list.add(qCrmCustDO.custCode.contains(param.getCustCode()));
        }
        return ExpressionUtils.allOf(list);
    }


    public List<LmSaveCustRespVO> getCustInfoByPid(String custCode) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.custCurr,
                        qCrmCustDO.taxerNo,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.custType
                ))
                .from(qCrmCustDO)
                .where(qCrmCustDO.pid.eq(custCode).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCodes(CrmCustSimpleParam param) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invBankName,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.custCurr,
                        qCrmCustDO.taxerNo,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.storeOrderFlag,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.custType,
                        qCrmCustDO.invType
                ))
                .from(qCrmCustDO)
                .where(simpleWhere(param))
                .fetch();
    }

    public Predicate simpleWhere(CrmCustSimpleParam param){
        List<Predicate> list = new ArrayList<>();
        list.add(qCrmCustDO.deleteFlag.eq(0));
        if(StringUtil.isNotBlank(param.getCorOu())){
            list.add(qCrmCustDO.corOu.eq(param.getCorOu()));
        }
        if(StringUtil.isNotBlank(param.getCustCode())){
            list.add(qCrmCustDO.custCode.eq(param.getCustCode()));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<LmSaveCustRespVO> findBaseCustInfo(CustCode2BaseParam param) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.taxerNo,
                        qCrmCustDO.invType,
                        qCrmCustDO.custType
                ))
                .from(qCrmCustDO)
                .where(whereCustCode2(param))
                .fetch();
    }


    public List<LmSaveCustRespVO> getCustInfoByCustCodes(List<String> custCode) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                        qCrmCustDO.id,
                        qCrmCustDO.custName,
                        qCrmCustDO.custCode,
                        qCrmCustDO.custCode2,
                        qCrmCustDO.addrNo,
                        qCrmCustDO.invAddress,
                        qCrmCustDO.invBankAcc,
                        qCrmCustDO.invBankName,
                        qCrmCustDO.invBankBranch,
                        qCrmCustDO.invTel,
                        qCrmCustDO.invPicName,
                        qCrmCustDO.invPicPhone,
                        qCrmCustDO.invTitle,
                        qCrmCustDO.custCurr,
                        qCrmCustDO.taxerNo,
                        qCrmCustDO.pid,
                        qCrmCustDO.custAbbr,
                        qCrmCustDO.contactName,
                        qCrmCustDO.contactPhone,
                        qCrmCustDO.agentEmpId,
                        qCrmCustDO.createTime,
                        qCrmCustDO.region,
                        qCrmCustDO.custType,
                        qCrmCustDO.invType,
                        qCrmCustDO.legalRepre,
                        qCrmCustDO.storeOrderFlag,
                        qCrmCustDO.custStatus
                ))
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode.in(custCode).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCode2s(List<String> custCode2s) {
        return jpaQueryFactory.select(Projections.bean(LmSaveCustRespVO.class,
                qCrmCustDO.id,
                qCrmCustDO.custName,
                qCrmCustDO.custCode,
                qCrmCustDO.custCode2,
                qCrmCustDO.addrNo,
                qCrmCustDO.invAddress,
                qCrmCustDO.invBankAcc,
                qCrmCustDO.invBankName,
                qCrmCustDO.invBankBranch,
                qCrmCustDO.invTel,
                qCrmCustDO.invPicName,
                qCrmCustDO.invPicPhone,
                qCrmCustDO.invTitle,
                qCrmCustDO.custCurr,
                qCrmCustDO.taxerNo,
                qCrmCustDO.pid,
                qCrmCustDO.custAbbr,
                qCrmCustDO.contactName,
                qCrmCustDO.contactPhone,
                qCrmCustDO.agentEmpId,
                qCrmCustDO.createTime,
                qCrmCustDO.region,
                qCrmCustDO.custType,
                qCrmCustDO.storeOrderFlag,
                qCrmCustDO.invType,
                qCrmCustDO.legalRepre,
                qCrmCustDO.custStatus
        ))
                .from(qCrmCustDO)
                .where(qCrmCustDO.custCode2.in(custCode2s).and(qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch();
    }

    public CustCorOuResVO getCustCorOu(String custCode){
        return jpaQueryFactory.select(Projections.bean(CustCorOuResVO.class,
                qCrmCustDO.id,
                qCrmCustDO.custCode,
                qCrmCustDO.pid,
                qCrmCustDO.custGroup,
                qCrmCustDO.custName,
                qCrmCustDO.outerCode,
                qCrmCustDO.custCode2,
                qCrmCustDO.custAbbr,
                qCrmCustDO.custType2,
                qCrmCustDO.custType,
                qCrmCustDO.region,
                qCrmCustDO.agentEmpId,
                qCrmCustDO.custLevel,
                qCrmCustDO.certNo,
                qCrmCustDO.custCurr,
                qCrmCustDO.country,
                qCrmCustDO.taxpayerType,
                qCrmCustDO.contactName,
                qCrmCustDO.contactPhone,
                qCrmCustDO.custStatus,
                qCrmCustDO.isCreateOu,
                qCrmCustDO.corOu
        )).from(qCrmCustDO).where(qCrmCustDO.deleteFlag.eq(0).and(qCrmCustDO.custCode.eq(custCode).and(qCrmCustDO.isCreateOu.eq(1))))
                .fetchOne();
    }


}
