package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordTempDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempDtlRespVO;
import com.elitesland.yst.production.sale.entity.QExectRecordTempDtlDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录模板明细表RepoProc
 */
@Component
public class ExectRecordTempDtlRepoProc {

    private final QExectRecordTempDtlDO qExectRecordTempDtlDO = QExectRecordTempDtlDO.exectRecordTempDtlDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<ExectRecordTempDtlRespVO> page(ExectRecordTempDtlQueryVO exectRecordTempDtlPageParam) {
        JPAQuery<ExectRecordTempDtlRespVO> query = select(ExectRecordTempDtlRespVO.class)
                .where(bulidPredicate(exectRecordTempDtlPageParam));
        exectRecordTempDtlPageParam.setPaging(query);
        exectRecordTempDtlPageParam.fillOrders(query, qExectRecordTempDtlDO);
        return PagingVO.<ExectRecordTempDtlRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qExectRecordTempDtlDO)
                .set(qExectRecordTempDtlDO.deleteFlag, 1)
                .where(qExectRecordTempDtlDO.id.in(ids))
                .execute();
        return res;
    }


    public List<ExectRecordTempDtlRespVO> get(Long id) {
        List<ExectRecordTempDtlRespVO> fetch = select(ExectRecordTempDtlRespVO.class)
                .where(qExectRecordTempDtlDO.masId.eq(id))
                .orderBy(qExectRecordTempDtlDO.sort.asc())
                .fetch();
        return fetch;
    }


    public List<ExectRecordTempDtlRespVO> getList(ExectRecordTempDtlQueryVO exectRecordTempDtlPageParam) {
        List<ExectRecordTempDtlRespVO> res = select(ExectRecordTempDtlRespVO.class)
                .where(bulidPredicate(exectRecordTempDtlPageParam))
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExectRecordTempDtlDO.masId,
                qExectRecordTempDtlDO.name,
                qExectRecordTempDtlDO.type,
                qExectRecordTempDtlDO.content,
                qExectRecordTempDtlDO.requiredFlag,
                qExectRecordTempDtlDO.sort,
                qExectRecordTempDtlDO.id,
                qExectRecordTempDtlDO.createTime,
                qExectRecordTempDtlDO.remark,
                qExectRecordTempDtlDO.creator,
                qExectRecordTempDtlDO.updater,
                qExectRecordTempDtlDO.modifyTime
        )).from(qExectRecordTempDtlDO);
    }


    private Predicate bulidPredicate(ExectRecordTempDtlQueryVO exectRecordTempDtlPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(null != exectRecordTempDtlPageParam.getMasId(), qExectRecordTempDtlDO.masId, exectRecordTempDtlPageParam.getMasId())
                .andEq(StringUtils.isNotBlank(exectRecordTempDtlPageParam.getName()), qExectRecordTempDtlDO.name, exectRecordTempDtlPageParam.getName())
                .andEq(StringUtils.isNotBlank(exectRecordTempDtlPageParam.getType()), qExectRecordTempDtlDO.type, exectRecordTempDtlPageParam.getType())
                .andEq(StringUtils.isNotBlank(exectRecordTempDtlPageParam.getContent()), qExectRecordTempDtlDO.content, exectRecordTempDtlPageParam.getContent())
                .andEq(null != exectRecordTempDtlPageParam.getRequiredFlag(), qExectRecordTempDtlDO.requiredFlag, exectRecordTempDtlPageParam.getRequiredFlag())
                .andEq(null != exectRecordTempDtlPageParam.getSort(), qExectRecordTempDtlDO.sort, exectRecordTempDtlPageParam.getSort())
                .build();
        return predicate;
    }
}