package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalContractRecvDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 11:26 上午
 */
public interface SalContractRecvRepo extends JpaRepository<SalContractRecvDO, Long>, QuerydslPredicateExecutor<SalContractRecvDO> {

    // 根据合同主表ID，获取所有收款计划
    List<SalContractRecvDO> findAllByMasId(Long masId);

    // 根据合同主表ID，物理删除所有收款计划
    void deleteAllByMasId(Long masId);

    void deleteAllByContractNo(String contractNo);

    List<SalContractRecvDO> findAllByContractNo(String contractNo);
}
