package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractPagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractExportVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.entity.QSalContractDDO;
import com.elitesland.yst.production.sale.entity.QSalContractDO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 11:26 上午
 */
@Repository
@RequiredArgsConstructor
public class SalContractRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QSalContractDO qSalContractDO = QSalContractDO.salContractDO;
    private final QSalContractDDO qSalContractDDO = QSalContractDDO.salContractDDO;

    /**
     * 获取合同收款总金额
     *
     * @param contractNo 合同编号
     * @return 合同收款总金额
     */
    public BigDecimal getTotalAmt(String contractNo) {
        return jpaQueryFactory.select(qSalContractDO.totalAmt)
                .from(qSalContractDO)
                .where(qSalContractDO.contractNo.eq(contractNo))
                .limit(1)
                .fetchOne();
    }

    private Predicate where(SalContractPagingParam pageParam) {
        Predicate predicate = qSalContractDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (Objects.nonNull(pageParam.getIds())&&pageParam.getIds().size()>0){
                predicate = ExpressionUtils.and(predicate, qSalContractDO.id.in(pageParam.getIds()));
            }
            if (StrUtil.isNotBlank(pageParam.getContractNo())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractNo.like(pageParam.getContractNo().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractName())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractName.like("%" + pageParam.getContractName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractType())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractType.eq(pageParam.getContractType()));
            }
            if (Objects.nonNull(pageParam.getSignDate())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.signDate.eq(pageParam.getSignDate()));
            }
            if (StrUtil.isNotBlank(pageParam.getProjName())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.projName.like("%" + pageParam.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractStatus())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractStatus.eq(pageParam.getContractStatus()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custId.eq(pageParam.getCustId()));
            }
            if (CollUtil.isNotEmpty(pageParam.getCustIds())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custId.in(pageParam.getCustIds()));
            }
            if (StrUtil.isNotBlank(pageParam.getCustCode())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custCode.like(pageParam.getCustCode().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getCustName())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custName.like("%" + pageParam.getCustName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getSignOu())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.bSignOu.eq(pageParam.getSignOu()));
            }
            if (StrUtil.isNotBlank(pageParam.getSalesMan())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.bSalesman.eq(pageParam.getSalesMan()));
            }
            if (StrUtil.isNotBlank(pageParam.getRegion())){
                predicate = ExpressionUtils.and(predicate, qSalContractDO.bRegion.eq(pageParam.getRegion()));
            }
            if (StrUtil.isNotBlank(pageParam.getFindCloseOrderFlag()) && pageParam.getFindCloseOrderFlag().equals("false")) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractStatus.eq(UdcEnum.SAL_CONTRACT_STATUS_APPROVED.getValueCode()));
            }
        }
//        // 添加权限信息
//        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qSalContractDO.getMetadata()));
        return predicate;
    }

    /**
     * 导出查询
     * @param queryParam 查询参数
     * @return 结果
     */
    public JPAQuery<SalContractExportVO> selectForExport(SalContractPagingParam queryParam){
        return jpaQueryFactory.select(Projections.bean(SalContractExportVO.class,
                qSalContractDO.contractNo,
                qSalContractDO.contractType,
                qSalContractDO.contractStatus,
                qSalContractDO.contractName,
                qSalContractDO.contractVersion,
                qSalContractDO.projName,
                qSalContractDO.signDate,
                qSalContractDO.beginDate,
                qSalContractDO.endDate,
                qSalContractDO.totalAmt,
                qSalContractDO.currCode,
                qSalContractDO.custCode,
                qSalContractDO.custName,
                qSalContractDO.custPic,
                qSalContractDO.custPicTel,
                qSalContractDO.custAddress,
                qSalContractDO.endAmt,
                qSalContractDO.contractNo2,
                qSalContractDO.guaranteePeriod,
                qSalContractDO.contractCity,
                qSalContractDO.feeCarrier,
                qSalContractDO.deliverDate,
                qSalContractDO.installFlag,
                qSalContractDO.deliverAddress,
                qSalContractDO.projConfirmFlag,
                qSalContractDO.guaranteeAmt,
                qSalContractDO.deliverMethod,
                qSalContractDO.bSignOu.as("seSignOu"),
                qSalContractDO.bSignDept.as("seSignDept"),
                qSalContractDO.bSalesman.as("seSalesman"),
                qSalContractDO.bSalesmanTel.as("seSalesmanTel"),
                qSalContractDO.bRegion.as("seRegion"),
                qSalContractDO.bAddress.as("seAddress"),
                qSalContractDO.cCode.as("thCode"),
                qSalContractDO.cName.as("thName"),
                qSalContractDO.cContact.as("thContact"),
                qSalContractDO.cContactTel.as("thContactTel"),
                qSalContractDO.cAddress.as("thAddress"),

                qSalContractDDO.itemCode,
                qSalContractDDO.itemName,
                qSalContractDDO.itemSpec,
                qSalContractDDO.custItemCode,
                qSalContractDDO.itemBrand,
                qSalContractDDO.suppFlag,
                qSalContractDDO.qty,
                qSalContractDDO.uom,
                qSalContractDDO.netPrice,
                qSalContractDDO.netAmt,
                qSalContractDDO.price,
                qSalContractDDO.amt,
                qSalContractDDO.taxAmt,
                qSalContractDDO.taxRate,
                qSalContractDDO.discRatio,
                qSalContractDDO.discAmt,
                qSalContractDDO.basePrice,
                qSalContractDDO.remark
                ))
                .from(qSalContractDO).leftJoin(qSalContractDDO).on(qSalContractDDO.masId.eq(qSalContractDO.id))
                .where(where(queryParam));
    }

}
