package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalInvApplydDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.math.BigDecimal;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/3 11:25
 */
public interface SalInvApplydRepo extends JpaRepository<SalInvApplydDO, Long>, QuerydslPredicateExecutor<SalInvApplydDO> {
    void deleteAllByMasId(Long masId);

    List<SalInvApplydDO> findByMasIdIn(List<Long> masIds);

    @Query(value = "select sum(apply_amt) from sal_inv_applyd  where contract_id = ?1", nativeQuery = true)
    BigDecimal sumByContractId(Long contractId);

    int countBySoDIdIn(List<Long> sodIds);
}
