package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalReceiptDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.math.BigDecimal;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface SalReceiptdRepo extends JpaRepository<SalReceiptDDO, Long>, QuerydslPredicateExecutor<SalReceiptDDO> {
    void deleteAllByMasId(Long masId);

    List<SalReceiptDDO> findByMasIdIn(List<Long> masIds);

    @Query(value = "select sum(receipt_amt) from sal_receiptd  where contract_id = ?1", nativeQuery = true)
    BigDecimal sumByContractId(Long contractId);
}
