package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.component.SalesmanParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.component.SalesmanPageRespVO;
import com.elitesland.yst.production.sale.entity.QSalesmanInfoDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/6/25
 */
@Component
@RequiredArgsConstructor
public class SalesmanComponentRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QSalesmanInfoDO salesmanInfoDO = QSalesmanInfoDO.salesmanInfoDO;


    private final QBean<SalesmanPageRespVO> salesmanList = Projections.bean(
            SalesmanPageRespVO.class,
            salesmanInfoDO.id,
            salesmanInfoDO.salesmanNo.as("empCode"),
            salesmanInfoDO.name.as("empName"),
            salesmanInfoDO.salesmanType,
            salesmanInfoDO.ouCode,
            salesmanInfoDO.ouName
    );

    public long countSalesMan(SalesmanParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(salesmanInfoDO.count())
                .from(salesmanInfoDO);
        jpaQuery.where(this.whereSalesman(paramVO));
        return jpaQuery.fetchCount();
    }


    public List<SalesmanPageRespVO> querySalesMan(SalesmanParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(salesmanList)
                .from(salesmanInfoDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, salesmanInfoDO);
        jpaQuery.where(this.whereSalesman(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereSalesman(SalesmanParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(salesmanInfoDO.enableStatus.eq(1));
        if (StringUtils.isNotBlank(paramVO.getEmpCodeName())) {
            String likeStr = "%" + paramVO.getEmpCodeName() + "%";
            predicates.add(salesmanInfoDO.salesmanNo.like(likeStr).or(salesmanInfoDO.name.like(likeStr)));
        }
        if (StringUtils.isNotBlank(paramVO.getOuCodeName())) {
            String likeStr = "%" + paramVO.getOuCodeName() + "%";
            predicates.add(salesmanInfoDO.ouCode.like(likeStr).or(salesmanInfoDO.ouName.like(likeStr)));
        }
        return ExpressionUtils.allOf(predicates);
    }

}
