package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.TaskInfoDtlDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 功能说明:业务员任务管理-明细
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
@Repository
public interface TaskInfoDtlRepo extends JpaRepository<TaskInfoDtlDO, Long>, QuerydslPredicateExecutor<TaskInfoDtlDO> {

    /**
     * 根据任务主表ID删除任务明细
     *
     * @param masId 任务主表ID
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    void deleteByMasId(Long masId);

    @Transactional
    @Modifying
    @Query(value = "update task_info_dtl set complete_state = ?2 where mas_id = ?1", nativeQuery = true)
    void releaseDtl(Long masId, String completeState);
}
