package com.elitesland.yst.production.sale.rmi.ystsupport;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;

import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgBankAccRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.*;
import com.elitesland.yst.production.support.provider.org.service.OrgAddrRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/3 10:04
 */
@Slf4j
@Component
public class RmiOrgAddrService {

//    @DubboReference(check = false, timeout = 10000)
//    private OrgAddrRpcService orgAddrRpcService;
    @Autowired
    private OrgAddrRpcService orgAddrRpcService;



    public void orgAddrAddressDelete(Long id){
        try {
            orgAddrRpcService.orgAddrAddressDelete(id);
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿保存服务异常"+e,e);
        }
    }

    public ApiResult<Long> orgAddrAddressSaveOrUpdate(OrgAddrAddressRpcSaveParam param){
        try {
            return orgAddrRpcService.orgAddrAddressSaveOrUpdate(param);
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿保存服务异常"+e,e);
        }
    }


    public ApiResult<Long> orgAddrSaveOrUpdate(OrgAddrRpcSaveParam param) {
        try {
            return orgAddrRpcService.orgAddrSaveOrUpdateReturnAddrNo(param);
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿保存服务异常"+e,e);
        }
     //   return null;
    }

    public ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(OrgAddrRpcSaveParam param) {
        try {
            return orgAddrRpcService.orgAddrSaveOrUpdateReturnAddrNo(param);
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿保存服务异常"+e,e);
        }
    }


    public ApiResult<OrgAddrDetailsRpcDTO> findAddrByAddrNo(Long addrNo) {
        try {
        //    return orgAddrRpcService.findRpcDtoByAddrNo(addrNo);
            OrgAddrQueryRpcParam param = new OrgAddrQueryRpcParam();
            param.setAddrNo(addrNo);
            param.setDataSources(Collections.singletonList(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode()));
            return orgAddrRpcService.findRpcDtoByParam(param);
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿通过地址号查询服务异常", e);
        }
    }
    public List<OrgAddressRpcDTO> findAddrAddressListByParam(OrgAddressRpcDtoParam param){
        try {
            List<OrgAddressRpcDTO> addressRpcDtoByParam = orgAddrRpcService.findAddrAddressRpcDtoByParam(param);
            return CollUtil.isNotEmpty(addressRpcDtoByParam) ? addressRpcDtoByParam : new ArrayList<>(0);
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿查询服务异常"+e,e);
        }
    }

    @SysCodeProc
    public List<RmiOrgBankAccRpcVO> findBankAccRpcDtoByParam(OrgBankAccRpcDtoParam param){
        try {
            List<RmiOrgBankAccRpcVO> list = new ArrayList<>();
            List<OrgBankAccRpcDTO> bankRpcDtoByParam = orgAddrRpcService.findBankAccRpcDtoByParam(param);
            bankRpcDtoByParam.forEach(bank -> {
                if(param.getBankAcc()!=null){
                    if(param.getBankAcc().equals(bank.getBankAcc())){
                        RmiOrgBankAccRpcVO rmiVO = BeanUtil.copyProperties(bank, RmiOrgBankAccRpcVO.class);
                        list.add(rmiVO);
                    }
                }else {
                    RmiOrgBankAccRpcVO rmiVO = BeanUtil.copyProperties(bank, RmiOrgBankAccRpcVO.class);
                    list.add(rmiVO);
                }
            });
            return list;
        } catch (Exception e) {
            log.error("远程调用支撑域地址簿相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域地址簿查询服务异常"+e,e);
        }
    }
}
