package com.elitesland.yst.production.sale.rmi.ystsupport;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @auther JinXK
 * @date 2021/8/19 17:53
 */
@Component
@Slf4j
public class RmiSysSettingService {

//    @DubboReference(version = "${provider.service.version}", check = false, timeout = 10000)
//    @DubboReference(check = false, timeout = 10000)
//    private SysSettingService sysSettingService;

    @Autowired
    private SysSettingService sysSettingService;

    public SysSettingVO findSysSettingByNo(String no){
        log.info("查询系统设置表数据：parm="+no);
        try {
            return sysSettingService.oneByNo(no);
        }catch (Exception e){
            log.error("查询系统设置表数据:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询系统设置表数据接口异常");
        }
    }
}
