package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoExportRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/08
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class TaskInfoExportServiceImpl implements DataExport<TaskInfoExportRespVO, TaskInfoQueryVO> {

    private final TaskInfoService taskInfoService;

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    @Override
    public String getTmplCode() {
        return ConstantsSale.SALE_SALESMAN_TASK_EXPORT;
    }

    /**
     * 导出数据
     *
     * @param queryParam 查询参数
     * @return 数据
     */
    @Override
    public PagingVO<TaskInfoExportRespVO> executeExport(TaskInfoQueryVO queryParam) {
        PagingVO<TaskInfoExportRespVO> pagingVO = taskInfoService.exportPage(queryParam);
        //List<TaskInfoExportRespVO> exportRespVOList = pagingVO.getRecords();

        return PagingVO.<TaskInfoExportRespVO>builder()
                .total(pagingVO.getTotal())
                .records(pagingVO.getRecords())
                .build();
    }

}
