package com.elitesland.yst.production.sale.service.shop;


import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.*;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDFindParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCartParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustCurrentParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustItemParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFareAmtQueryParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAPPRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAppParamVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipCartCovert;
import com.elitesland.yst.production.sale.convert.shop.BipCartItemCovert;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.convert.shop.MktGiftCovert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceSimpleDTO;
import com.elitesland.yst.production.sale.dto.query.PriSaleItemReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepo;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialItemRepo;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.service.LogisticsTemplateDServiceImpl;
import com.elitesland.yst.production.sale.service.PriSalePriceRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/08/9:51
 * @Description:
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipCartServiceImpl extends BaseServiceImpl implements BipCartService {

    private final BipCartRepo bipCartRepo;

    private final RmiPriMainPriceService rmiPriMainPriceService;

    private final BipCartRepoProc bipCartRepoProc;

    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;

    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;

    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;

    private final CrmCustRepo crmCustRepo;

    private final MktDiscountGiftRepo mktDiscountGiftRepo;

    private final MktGiftRepo mktGiftRepo;

    private final MktGiftRepoProc mktGiftRepoProc;

    private final BipCouponRepo bipCouponRepo;
    private final BusFirstMenuConfRepo busFirstMenuConfRepo;

    private final FirstSpecialItemRepo firstSpecialItemRepo;

    private final MktDiscountGiftService mktDiscountGiftService;

    private final PriSalePriceRpcService priSalePriceRpcService;

    private final CrmCustOuRepo crmCustOuRepo;

    @Autowired
    private BipCouponCustService bipCouponCustService;

    @Autowired
    private BipItemMngService bipItemService;

    @Autowired
    private MktDiscountOffsetServiceImpl mktDiscountOffsetService;
//    @Autowired
//    private MktDiscountGiftServiceImpl mktDiscountGiftService;

    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;

    @Autowired
    private BipItemRepo bipItemRepo;

    @Autowired
    private BipItemRepoProc bipItemRepoProc;

    @Autowired
    private BipAddressServiceImpl bipAddressService;

    @Autowired
    private LogisticsTemplateDServiceImpl logisticsTemplateDService;
    @Autowired
    private BipOrderService bipOrderService;

    @Autowired
    private BipCompanyManageService bipCompanyManageService;

    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;
//    private final RmiItemService rmiItemService;


    /**
     * 加入购物车商品
     *
     * @param bipCartParmVO
     */
    @Override
    public void addItemToCart(BipCartParmVO bipCartParmVO) {
        log.info("购物车新增参数---" +JSON.toJSONString(bipCartParmVO));

        Assert.notBlank(bipCartParmVO.getPriceType(),"请传入价格类型！");

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }
        if(bipCustUserBindDO==null){
            throw new BusinessException("请绑定公司信息!");
        }


        if (bipItemSkuRepoProc.findFreezeStatus(bipCartParmVO.getSkuId())){
            throw new BusinessException("商品"+bipCartParmVO.getSkuCode()+"已冻结");
        }


        BipCartDO bipCart = BipCartCovert.INSTANCE.BipCartParmVo2BipCart(bipCartParmVO);

        Long itemId = bipCart.getItemId();
        bipItemRepo.findById(itemId);

//        BipItemDO bipItemDO=bipItemRepo.findById(itemId).get();
//        if(bipItemDO==null||bipItemDO.getOuId()==null){
//            throw new BusinessException("数据异常!");
//        }else{
//            Assert.notNull(bipCustUserBindDO.getOuId(),"账号为关联公司!");
//            if(!bipCustUserBindDO.getOuId().equals(bipItemDO.getOuId())){
//                throw new BusinessException("账号只能添加关联公司物品!");
//            }
//        }
        bipCart.setUserId(currentUserDTO.getUserId());
        String skuCode = bipCart.getSkuCode();
        Long skuId = bipCart.getSkuId();
        Long num = bipCart.getItemNum();
        // BipCartDO bipCartDo = bipCartRepo.findAllByUserIdAndItemIdAndSkuId(currentUserDTO.getUserId(), itemId, skuId);
        QBipCartDO qBipCartDO = QBipCartDO.bipCartDO;
        BooleanExpression e = qBipCartDO.deleteFlag.eq(0).and(qBipCartDO.userId.eq(currentUserDTO.getUserId())).and(qBipCartDO.itemId.eq(itemId)).and(qBipCartDO.skuId.eq(skuId));
        Optional<BipCartDO> optional = bipCartRepo.findOne(e);
        if(optional.isEmpty()){
            bipCart.setStockEnough(checkCartStorm(skuId,num));
            bipCartRepo.save(bipCart);
//            BipCartDO bipCartDo = optional.get();
//            if (bipCartDo == null) {
//
//                bipCart.setStockEnough(checkCartStorm(skuId,num));
//                bipCartRepo.save(bipCart);
//
//            } else {
//                Long exitNum=bipCartDo.getItemNum();
//                long checkNum=exitNum+num;
//
//                bipCart.setStockEnough(checkCartStorm(skuId,num));
//                bipCartDo.setItemNum(checkNum);
//                bipCartRepo.save(bipCartDo);
//            }
        }else {
            BipCartDO bipCartDo = optional.get();
            Long exitNum=bipCartDo.getItemNum();
            long checkNum=exitNum+num;

            bipCart.setStockEnough(checkCartStorm(skuId,num));
            bipCartDo.setItemNum(checkNum);
            bipCartRepo.save(bipCartDo);
        }
    }



    public List<Long> getCrmCustOuIds(String custCode){
        QCrmCustOuDO qCrmCustOuDO = QCrmCustOuDO.crmCustOuDO;
        BooleanExpression e = qCrmCustOuDO.custCode.eq(custCode).and(qCrmCustOuDO.deleteFlag.eq(0));
        Iterable<CrmCustOuDO> iterables = crmCustOuRepo.findAll(e);
        if(!IterUtil.isEmpty(iterables)){
            List<CrmCustOuDO> list = Lists.newArrayList(iterables);
            List<Long> ouIdList = list.stream().filter(l -> null != l.getOuId()).map(CrmCustOuDO :: getOuId).collect(Collectors.toList());
            return ouIdList;
        }
        return null;
    }

    /**
     * 立即购买结算
     * @param bipBuyNowSettleParmVO
     * @return
     */
    @Override
    public BipCartVo findBuyNowOrderPer(BipBuyNowSettleParmVO bipBuyNowSettleParmVO){
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        Long addressId=bipBuyNowSettleParmVO.getAddressId();
        if(bipBuyNowSettleParmVO.getItemId()==null||bipBuyNowSettleParmVO.getSkuId()==null||bipBuyNowSettleParmVO.getItemNum()==null){
            throw new BusinessException("立即购买参数异常!");
        }

        if (bipItemSkuRepoProc.findFreezeStatus(bipBuyNowSettleParmVO.getSkuId())){
            throw new BusinessException("销售冻结状态的商品不能购买");
        }

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }
        if(bipCustUserBindDO==null || null == bipCustUserBindDO.getCustId()){
            throw new BusinessException("请绑定公司信息!");
        }
        String custCode = bipCustUserBindDO.getCustCode();
        Long custId = bipCustUserBindDO.getCustId();
        CrmCustDO crmCustDO = crmCustRepo.findById(custId).get();

        String custLevel = crmCustDO.getCustLevel();
        Long custOuId = crmCustDO.getOuId();
        Long ouId = bipBuyNowSettleParmVO.getOuId();
        List<Long> custOuIds = new ArrayList<>();
        List<Long> crmCustOuIds = getCrmCustOuIds(custCode);
        if(null != crmCustOuIds && !crmCustOuIds.isEmpty()){
            custOuIds.addAll(crmCustOuIds);
        }
        custOuIds.add(custOuId);
        if(!custOuIds.contains(ouId)){
            throw new BusinessException("只能购买所属公司商品");
        }


        Long userId = currentUserDTO.getUserId();
        String userName = currentUserDTO.getUserName();

        BipCartItemRespVO bipCartItemRespVO=new BipCartItemRespVO();
        bipCartItemRespVO.setItemId(bipBuyNowSettleParmVO.getItemId());
        bipCartItemRespVO.setItemNum(bipBuyNowSettleParmVO.getItemNum());
        bipCartItemRespVO.setSkuId(bipBuyNowSettleParmVO.getSkuId());

        List<BipCartItemRespVO> itemVOList=new ArrayList<>();
        itemVOList.add(bipCartItemRespVO);

        List<Long> itemIds=new ArrayList<>();
        itemIds.add(bipBuyNowSettleParmVO.getItemId());
        checkItmeIdRelateOuId(itemIds,ouId);

        BipCartVo bipCartVo = new BipCartVo();
        bipCartVo.setCouponId(bipBuyNowSettleParmVO.getCouponId());

        // ouId itemId  skuId
        if(null != bipBuyNowSettleParmVO.getFirstItemFlag() && bipBuyNowSettleParmVO.getFirstItemFlag()){
            bipBuyNowSettleParmVO.setPreferentialPrice(getSpecialPrice(bipBuyNowSettleParmVO.getSkuId(),ouId));
        }

        buildOrderPerInfo(itemVOList,ouId,custLevel,userId,userName,bipCartVo,addressId,bipBuyNowSettleParmVO.getFirstItemFlag(),bipBuyNowSettleParmVO.getPreferentialPrice());

        buildMkDisscountOffsetInfo(itemVOList,ouId,custLevel);

        //拼接查询买赠信息
        List<Long> skuIds =new ArrayList<>();
        skuIds.add(bipBuyNowSettleParmVO.getSkuId());
        log.info("查询赠品信息-----------:"+JSON.toJSONString(itemVOList)+"ouId:"+ouId+"custLevel:"+custLevel+"skuIds:"+skuIds);
        getGiftList(itemVOList,ouId,custLevel,skuIds);

        log.info("立即购买结算页面商品信息"+JSON.toJSONString(itemVOList));
        BigDecimal discontFreeAmt=bipCartVo.getOrderDiscountFreeAmt();
        if(discontFreeAmt==null){
            discontFreeAmt=BigDecimal.ZERO;
        }
        //折扣累加
        for(BipCartItemRespVO bipCartItemRespVO1:itemVOList){
            if(null != bipCartItemRespVO1 && null != bipCartItemRespVO1.getMktDiscountOffsetFreeAmt() && bipCartItemRespVO1.getMktDiscountOffsetFreeAmt().compareTo(BigDecimal.ZERO) != 0){
                log.info(bipCartItemRespVO1.getItemName()+"--明细促销折扣金额--"+bipCartItemRespVO1.getMktDiscountOffsetFreeAmt());
                discontFreeAmt=discontFreeAmt.add(bipCartItemRespVO1.getMktDiscountOffsetFreeAmt());
            }
        }

        log.info("促销折扣金额--"+discontFreeAmt);
        bipCartVo.setOrderDiscountFreeAmt(discontFreeAmt);

        bipCartVo.setItemList(itemVOList);
        if(!bipBuyNowSettleParmVO.getFirstItemFlag()){
            buildItemCoupon(bipCartVo,userId,ouId);
        }

        // 补充价格
        for (BipCartItemRespVO respVO : bipCartVo.getItemList()) {
            Map<String,BigDecimal> prices = findSkuPriceReMap(respVO.getSkuCode(), userId,ouId);
            if(null != prices && null != prices.get("basePrice")){
                respVO.setBasePrice(prices.get("basePrice"));
            }
            if(null != prices && null != prices.get("custPrice")){
                respVO.setCustPrice(prices.get("custPrice"));
            }
        }
        log.info("立即购买参数：--------------------"+JSON.toJSONString(bipCartVo));
        return bipCartVo;
    }

    /**
     * 查询Sku价格
     * @param skuCode sku编号
     * @param userId 用户id
     * @return 1：客户等级价格  2：基础价格
     */
    private List<BigDecimal> findSkuPrice(String skuCode, Long userId){

//        log.info("查询Sku客户等级价入参："+ skuCode+" "+userId);
//
//        CustDTO cust = custUserBindService.getCustOfUserBind(userId).getData();
//
//        if (StringUtils.isBlank(skuCode) || userId==null || cust==null){
//            return null;
//        }
//
//        // 查询支撑域商品ID和单位
//        ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//        codeparam.setItemCodes(Collections.singletonList(skuCode));
//        List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//        if (dtos.size() == 0){
//            return null;
//        }
//
//        ItmItemRpcDTO dto = dtos.get(0);
//
//        List<BigDecimal> prices = new ArrayList<>();
//
//
//        // 客户等级价格
//        PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
//        param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
//        param.setCustLevel(cust.getCustLevel());
//        param.setCurrCode("CNY");
//        param.setOuId(cust.getOuId());
//        param.setItemId(dto.getId());
//        param.setUom(dto.getUom());
//        PriSalePriceTypeRespVO priceResult = null;
//        if (StringUtils.isNotBlank(cust.getCustLevel())){
//            log.info("等级价格入参："+skuCode+" ouid:"+cust.getOuId()+" 价格查询参数"+JSON.toJSONString(param));
//            priceResult = salePriceService.queryPrice(param);
//            log.info("等级价格："+skuCode+" ouid:"+cust.getOuId()+" 价格信息"+ JSON.toJSONString(priceResult));
//        }
//
//        BigDecimal custPrice = priceResult==null ? null : priceResult.getPrice();
//        prices.add(custPrice);
//
//        // 基础价格
//        PriSalePriceTypeQueryParam param2 = new PriSalePriceTypeQueryParam();
//        param2.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
//        param2.setCurrCode("CNY");
//        param2.setOuId(cust.getOuId());
//        param2.setItemId(dto.getId());
//        param2.setUom(dto.getUom());
//        log.info("基础价格入参："+skuCode+" ouid:"+cust.getOuId()+" 价格查询参数"+JSON.toJSONString(param2));
//        PriSalePriceTypeRespVO priceResult2 = salePriceService.queryPrice(param2);
//        log.info("基础价格："+skuCode+" ouid:"+cust.getOuId()+" 价格信息"+ JSON.toJSONString(priceResult2));
//
//        BigDecimal basePrice = priceResult2 == null ? null : priceResult2.getPrice();
//        prices.add(basePrice);
//
//        return prices;
        return null;
    }


    /**
     * 查询Sku价格
     * @param skuCode sku编号
     * @param userId 用户id
     * @return 1：客户等级价格  2：基础价格
     */
    private Map<String,BigDecimal> findSkuPriceReMap(String skuCode, Long userId,Long ouId){
//        Map<String,BigDecimal> map = new HashMap<>();
//
//        CustDTO cust = custUserBindService.getCustOfUserBind(userId).getData();
//
//        log.info("查询SKU"+skuCode+"价格时，用户ID:"+userId+"客户记录"+JSON.toJSONString(cust));
//
//        if (cust==null||cust.getOuId()==null){
//            throw new BusinessException("查价格时未查到用户:"+userId+"的客户信息");
//        }
//
//        if (StringUtils.isBlank(skuCode)){
//            throw new BusinessException("查询价格时SkuCode不能为空！");
//        }
//
//        // 查询支撑域商品ID和单位
//        ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//        codeparam.setItemCodes(Collections.singletonList(skuCode));
//        List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//        if (dtos.size() == 0){
//            throw new BusinessException("查询购物车商品价格时，未在支撑域找到该商品："+skuCode);
//        }
//
//        ItmItemRpcDTO dto = dtos.get(0);
//        if (StringUtils.isNotBlank(cust.getCustLevel())){
//            // 客户等级价格
//            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
//            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
//            param.setCustLevel(cust.getCustLevel());
//            param.setCurrCode("CNY");
//            //param.setOuId(cust.getOuId());
//            param.setOuId(ouId);
//            param.setItemId(dto.getId());
//            param.setUom(dto.getUom());
//            PriSalePriceTypeRespVO priceResult = null;
//            if (StringUtils.isNotBlank(cust.getCustLevel())){
//                log.info("等级价格入参："+skuCode+" ouid:"+cust.getOuId()+" 价格查询参数"+JSON.toJSONString(param));
//                priceResult = salePriceService.queryPrice(param);
//                log.info("等级价格："+skuCode+" ouid:"+cust.getOuId()+" 价格信息"+ JSON.toJSONString(priceResult));
//            }
//
//            BigDecimal custPrice = priceResult==null ? null : priceResult.getPrice();
//            map.put("custPrice",custPrice);
//        }
//
//        // 基础价格
//        PriSalePriceTypeQueryParam param2 = new PriSalePriceTypeQueryParam();
//        param2.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
//        param2.setCurrCode("CNY");
//        //   param2.setOuId(cust.getOuId());
//        param2.setOuId(ouId);
//        param2.setItemId(dto.getId());
//        param2.setUom(dto.getUom());
//        log.info("基础价格入参："+skuCode+" ouid:"+cust.getOuId()+" 价格查询参数"+JSON.toJSONString(param2));
//        PriSalePriceTypeRespVO priceResult2 = salePriceService.queryPrice(param2);
//        log.info("基础价格："+skuCode+" ouid:"+cust.getOuId()+" 价格信息"+ JSON.toJSONString(priceResult2));
//
//        if (priceResult2 == null||priceResult2.getPrice()==null){
//            throw new BusinessException("查询Sku价格时，商品："+skuCode+"基础价格为空");
//        }
//
//        BigDecimal basePrice = priceResult2.getPrice();
//        map.put("basePrice",basePrice);
//        return map;
        return null;
    }


    public BigDecimal getSpecialPrice(Long skuId,Long ouId){
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq(0).and(qFirstSpecialItemDO.skuId.eq(skuId)).and(qFirstSpecialItemDO.ouId.eq(ouId));
        Optional<FirstSpecialItemDO> optional = firstSpecialItemRepo.findOne(expression);
        if(optional.isPresent()){
            return optional.get().getPreferentialPrice();
        }
        return null;
    }

    /**
     * 获取买赠赠品信息
     */
    public void getGiftList(List<BipCartItemRespVO> itemVOList,Long ouId,String custLevel,List<Long> skuids){
        log.info("买赠查询入参"+JSON.toJSONString(itemVOList));
        List<BipGiftVO> giftList = mktDiscountGiftRepoProc.getGiftList(ouId,custLevel,LocalDateTime.now(),skuids).fetch();
        log.info("买赠查询结果"+JSON.toJSONString(giftList));
        itemVOList.forEach(item -> {
            List<BipGiftVO> giftVOS = new ArrayList<>();
            giftList.forEach(gift -> {
                if(item.getSkuId().equals(gift.getSkuId())){
                    Long stockNum = gift.getStockNowNum()==null?0L:gift.getStockNowNum();
                    //赠品库存剩余校验
                    if(stockNum.longValue() > 0){
                        //买赠规则校验 数量或金额达标
                        if((gift.getType().equals("0") && item.getItemNum().longValue() >= gift.getLimitNum().longValue()) ||
                                (gift.getType().equals("1") && item.getItemAmt().compareTo(gift.getLimitAmt())>=0)){
                            giftVOS.add(gift);
                        }
                    }
                }
            });
            if(giftVOS.size()>0){
                item.setGiftList(giftVOS);
            }
        });
    }


    /**
     * 校验商品所属公司和客户绑定公司信息是否一致
     * @param itemIds
     * @param ouId
     * @return
     */
//    public void checkItmeIdRelateOuIdOpt(List<Long> itemIds,Long ouId){
//        List<BipItemDO> bipItemDOS=bipItemRepo.findAllById(itemIds);
//        List<Long> ouIds=bipItemDOS.stream().map(bipItemDO -> {
//            return bipItemDO.getOuId();
//        }).distinct().collect(Collectors.toList());
//        if(ouIds==null||bipItemDOS.isEmpty()){
//            throw new BusinessException("商品未绑定公司信息!");
//        }
//
//        if(ouIds.size()>1){
//            throw new BusinessException("商品公司信息不一致!");
//        }
//
//        Long itemOuId=ouIds.get(0);
//        if(!itemOuId.equals(ouId)){
//            throw new BusinessException("只能购买所属公司商品");
//        }
//    }


    /**
     * 校验商品所属公司和客户绑定公司信息是否一致
     * @param itemIds
     * @param ouId
     * @return
     */
    public void checkItmeIdRelateOuId(List<Long> itemIds,Long ouId){
        //   List<BipItemDO> bipItemDOS=bipItemRepo.findAllById(itemIds);
        List<Long> ouIds = bipItemRepoProc.findOuIdByItemIds(itemIds);
//        List<Long> ouIds=bipItemDOS.stream().map(bipItemDO -> {
//            return bipItemDO.getOuId();
//        }).distinct().collect(Collectors.toList());
        if(ouIds==null||ouIds.isEmpty()){
            throw new BusinessException("商品未绑定公司信息!");
        }
        ouIds = ouIds.stream().distinct().collect(Collectors.toList());
        if(ouIds.size()>1){
            throw new BusinessException("商品公司信息不一致!");
        }

//        Long itemOuId=ouIds.get(0);
//        if(!itemOuId.equals(ouId)){
//            throw new BusinessException("只能购买所属公司商品");
//        }
    }

    /**
     * 查询选中的购物车商品
     * @param bipCartSettleParmVO
     * @return
     */
    @Override
    public BipCartVo findMyCartEable(BipCartSettleParmVO bipCartSettleParmVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        List<Long> cartIds=bipCartSettleParmVO.getCartIds();
        Long addressId=bipCartSettleParmVO.getAddressId();

        if(cartIds==null||cartIds.isEmpty()){
            throw new BusinessException("请求参数格式不正确!");
        }
        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }
        if(bipCustUserBindDO==null){
            throw new BusinessException("请绑定公司信息!");
        }

        Long custId = bipCustUserBindDO.getCustId();
        CrmCustDO crmCustDO = crmCustRepo.findById(custId).get();

        String custLevel = crmCustDO.getCustLevel();
        //   Long ouId = crmCustDO.getOuId();
        String custCode = bipCustUserBindDO.getCustCode();
        Long custOuId = crmCustDO.getOuId();
        Long ouId = bipCartSettleParmVO.getOuId();

        List<Long> custOuIds = new ArrayList<>();
        List<Long> crmCustOuIds = getCrmCustOuIds(custCode);
        if(null != crmCustOuIds && !crmCustOuIds.isEmpty()){
            custOuIds.addAll(crmCustOuIds);
        }
        custOuIds.add(custOuId);

        if(!custOuIds.contains(ouId)){
            throw new BusinessException("只能购买所属公司商品");
        }

        Long userId = currentUserDTO.getUserId();
        String userName = currentUserDTO.getUserName();

        // 查询并返回
        List<BipCartDO> bipCartDOList =bipCartRepo.findAllById(cartIds);

        for (BipCartDO cartDO : bipCartDOList) {
            if (bipItemSkuRepoProc.findFreezeStatus(cartDO.getSkuId())){
                throw new BusinessException("商品"+cartDO.getSkuCode()+"已冻结");
            }
        }


        List<Long> itemIds=bipCartDOList.stream().map(BipCartDO::getItemId).distinct().collect(Collectors.toList());
        checkItmeIdRelateOuId(itemIds,ouId);
        List<BipCartItemRespVO> itemVOList= BipCartCovert.INSTANCE.dos2Resps(bipCartDOList);

        BipCartVo bipCartVo = new BipCartVo();

        bipCartVo.setCouponId(bipCartSettleParmVO.getCouponId());

//        for (BipCartItemRespVO bipCartItemRespVO : itemVOList) {
//
//            buildItemInfo(bipCartItemRespVO);
//
//            buildItemFareInfo(bipCartItemRespVO);
//
//            buildMkDisscountOffsetInfo(bipCartItemRespVO, ouId, custLevel);
//
//            buildItemDisscountGiftInfo(bipCartItemRespVO, ouId, custLevel);
////            buildItemCoupon(bipCartItemRespVO,userId);
//
//            bipCartItemRespVO.setUserId(userId);
//            bipCartItemRespVO.setUserName(userName);
//
//            BigDecimal amt=bipCartItemRespVO.getBasePrice().compareTo(BigDecimal.ZERO)<=0?bipCartItemRespVO.getBasePrice():bipCartItemRespVO.getCustPrice();
//
//
//            bipCartItemRespVO.setItemAmt(amt.multiply(BigDecimal.valueOf(bipCartItemRespVO.getItemNum()==null?0L:bipCartItemRespVO.getItemNum())));
//
//            if(bipCartItemRespVO.getMktDiscountOffsetAmt()==null||bipCartItemRespVO.getMktDiscountOffsetAmt().compareTo(BigDecimal.ZERO)<=0){
//                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
//                bipCartItemRespVO.setMktDiscountOffsetAmt(amt.subtract(BigDecimal.ZERO));
//                bipCartItemRespVO.setItemAmt(amt.multiply(BigDecimal.valueOf(bipCartItemRespVO.getItemNum()==null?0L:bipCartItemRespVO.getItemNum())));
//            }
////            bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(amt));
//            bipCartVo.setOrderDiscountFreeAmt(bipCartVo.getOrderDiscountFreeAmt().add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()));
//
//            bipCartVo.setOrderTotalFareAmt(bipCartVo.getOrderTotalFareAmt().add(bipCartItemRespVO.getFareArm()==null?BigDecimal.ZERO:bipCartItemRespVO.getFareArm()));
//
//            bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(bipCartItemRespVO.getItemAmt()));
//
//
//        }
//
//        bipCartVo.setOrderFinalAmt(bipCartVo.getOrderTotalItemAmt().add(bipCartVo.getOrderTotalFareAmt().subtract(bipCartVo.getOrderDiscountFreeAmt()).subtract(bipCartVo.getOrderCpounAmt())));
//        bipCartVo.setItemList(itemVOList);

        buildOrderPerInfo(itemVOList,ouId,custLevel,userId,userName,bipCartVo,addressId,false,null);

        buildMkDisscountOffsetInfo(itemVOList,ouId,custLevel);

        //拼接查询买赠信息
        List<Long> skuIds=bipCartDOList.stream().map(bipCartDO -> {
            return bipCartDO.getSkuId();
        }).distinct().collect(Collectors.toList());
        getGiftList(itemVOList,ouId,custLevel,skuIds);

        BigDecimal discontFreeAmt=bipCartVo.getOrderDiscountFreeAmt();
        if(discontFreeAmt==null){
            discontFreeAmt=BigDecimal.ZERO;
        }
        //折扣累加
        for(BipCartItemRespVO bipCartItemRespVO:itemVOList){
            if(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()!=null){
                log.info("明细促销折扣金额--"+bipCartItemRespVO.getMktDiscountOffsetFreeAmt());
                discontFreeAmt=discontFreeAmt.add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt());
            }
        }

        log.info("促销折扣金额--"+discontFreeAmt);
        bipCartVo.setOrderDiscountFreeAmt(discontFreeAmt);
        log.info("订单折扣优惠金额------"+discontFreeAmt);
        bipCartVo.setItemList(itemVOList);
        buildItemCoupon(bipCartVo,userId,ouId);

        if (StringUtils.isBlank(custLevel)){
            return bipCartVo;
        }

        // 客户等级价
        for (BipCartItemRespVO respVO : bipCartVo.getItemList()) {
            Map<String,BigDecimal> prices = findSkuPriceReMap(respVO.getSkuCode(), userId,ouId);
            if(null != prices && null != prices.get("basePrice")){
                respVO.setBasePrice(prices.get("basePrice"));
            }
            if(null != prices && null != prices.get("custPrice")){
                respVO.setCustPrice(prices.get("custPrice"));
            }
        }

        return bipCartVo;
    }

    /**
     *构建子单信息
     * @param itemVOList
     * @param ouId
     * @param custLevel
     * @param userId
     * @param userName
     */
    public void buildOrderPerInfo(List<BipCartItemRespVO> itemVOList,Long ouId,String custLevel,Long userId,String userName,BipCartVo bipCartVo,Long addressId,Boolean firstItemFlag,BigDecimal preferentialPrice){

        for (BipCartItemRespVO bipCartItemRespVO : itemVOList) {

            buildItemInfo(bipCartItemRespVO,ouId);

            buildItemFareInfo(bipCartItemRespVO,addressId);

            //买赠下单时反查赠品信息方法注释(改为下单前查询展示到前端，下单时前端返回)
//            buildItemDisscountGiftInfo(bipCartItemRespVO, ouId, custLevel);
//            buildItemCoupon(bipCartItemRespVO,userId);

            bipCartItemRespVO.setUserId(userId);
            bipCartItemRespVO.setUserName(userName);



            Map<String,BigDecimal> prices = findSkuPriceReMap(bipCartItemRespVO.getSkuCode(), userId,ouId);
            if (null == prices||(prices.get("basePrice")==null)){
                throw new BusinessException("商品"+bipCartItemRespVO.getItemName()+"缺少基础价格");
            }

            if(null != prices && null != prices.get("basePrice")){
                bipCartItemRespVO.setCustPrice(prices.get("basePrice"));
            }
            if(null != prices && null != prices.get("custPrice")){
                bipCartItemRespVO.setCustPrice(prices.get("custPrice"));
            }

            if(null != firstItemFlag && firstItemFlag){
                bipCartItemRespVO.setCustPrice(preferentialPrice);
                bipCartItemRespVO.setBasePrice(preferentialPrice);
            }
//            if(prices.get(1) != null){
//                bipCartItemRespVO.setBasePrice(prices.get(1));
//            }
//            if(prices.get(0) != null){
//                bipCartItemRespVO.setCustPrice(prices.get("basePrice"));
//            }else{
//                bipCartItemRespVO.setCustPrice(bipCartItemRespVO.getBasePrice());
//                if(null != firstItemFlag && firstItemFlag){
//                    bipCartItemRespVO.setCustPrice(preferentialPrice);
//                }
//            }
//
//            if(null != firstItemFlag && firstItemFlag){
//                bipCartItemRespVO.setBasePrice(preferentialPrice);
//            }

            BigDecimal amt = bipCartItemRespVO.getCustPrice() != null ? bipCartItemRespVO.getCustPrice() : bipCartItemRespVO.getBasePrice();

            bipCartItemRespVO.setItemAmt(amt.multiply(BigDecimal.valueOf(bipCartItemRespVO.getItemNum()==null?0L:bipCartItemRespVO.getItemNum())));

            if(bipCartItemRespVO.getMktDiscountOffsetAmt()==null||bipCartItemRespVO.getMktDiscountOffsetAmt().compareTo(BigDecimal.ZERO)<=0){
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                bipCartItemRespVO.setMktDiscountOffsetAmt(amt.subtract(BigDecimal.ZERO));
                bipCartItemRespVO.setItemAmt(amt.multiply(BigDecimal.valueOf(bipCartItemRespVO.getItemNum()==null?0L:bipCartItemRespVO.getItemNum())));
            }

            bipCartVo.setOrderDiscountFreeAmt(bipCartVo.getOrderDiscountFreeAmt().add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()));

            bipCartVo.setOrderTotalFareAmt(bipCartVo.getOrderTotalFareAmt().add(bipCartItemRespVO.getFareArm()==null?BigDecimal.ZERO:bipCartItemRespVO.getFareArm()));

            bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(bipCartItemRespVO.getItemAmt()));
//            if(firstItemFlag){
//                bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(preferentialPrice));
//            }


        }

        bipCartVo.setOrderFinalAmt(bipCartVo.getOrderTotalItemAmt().add(bipCartVo.getOrderTotalFareAmt().subtract(bipCartVo.getOrderDiscountFreeAmt()).subtract(bipCartVo.getCouponAmt())));
    }



    /***
     * @Description: 商品信息
     * @Param: [bipCartItemRespVO]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/31
     */
    public void buildItemInfo(BipCartItemRespVO bipCartItemRespVO,Long ouId) {
        Long itemId = bipCartItemRespVO.getItemId();
        Long skuId=bipCartItemRespVO.getSkuId();
        log.info("商品信息itemId:---------"+itemId+"---skuId:---------:"+skuId);
        ApiResult<BipItemDetailRespVO> result=bipItemService.get(itemId);

        if(!result.isSuccess()){
            throw new BusinessException("查询商品信息失败");
        }
        BipItemDetailRespVO bipItemDetailRespVO = result.getData();
        bipCartItemRespVO.setRelateItemId(bipItemDetailRespVO.getItemId());
        bipCartItemRespVO.setItemCode(bipItemDetailRespVO.getItemCode());
        bipCartItemRespVO.setItemName(bipItemDetailRespVO.getItemName());


        bipCartItemRespVO.setUom(bipItemDetailRespVO.getUnit());

        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(skuId).get();
        bipCartItemRespVO.setMateriel(bipItemSkuDO.getMateriel());
        bipCartItemRespVO.setType(bipItemSkuDO.getType());

        bipCartItemRespVO.setItemSpec(bipItemSkuDO.getSpec());
        bipCartItemRespVO.setItemBrand(bipItemSkuDO.getBrand());
        bipCartItemRespVO.setItmeBrandCode(bipItemSkuDO.getBarcode());

        bipCartItemRespVO.setOuName(bipItemDetailRespVO.getOuName());
        CurrentUserDTO user = UserService.currentUser();
        if(null == user){
            throw new BusinessException("用户信息为空");
        }
        BipItemSkuRespVO bipItemSkuRespVO= BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);

        Map<String,BigDecimal> prices = findSkuPriceReMap(bipItemSkuDO.getSkuCode(), user.getUserId(),ouId);
        if(null != prices.get("basePrice")){
            bipCartItemRespVO.setBasePrice(prices.get("basePrice"));
        }
        if(null != prices.get("custPrice")){
            bipCartItemRespVO.setCustPrice(prices.get("custPrice"));
        }
        bipItemSkuRespVO.setPrice(prices.get("basePrice"));
        bipItemSkuRespVO.setAttrList(convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class));

        List<BipItemSkuAttrRespVO> attrList=convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class);

        //属性转换字符串
        List<String> list=new ArrayList<>();
        for(int i=0;i<attrList.size();i++){
            BipItemSkuAttrRespVO bipItemSkuAttrRespVO=JSON.parseObject(JSON.toJSONString(attrList.get(i)),BipItemSkuAttrRespVO.class);
            if(bipItemSkuAttrRespVO!=null){
                list.add(bipItemSkuAttrRespVO.getName()+":"+bipItemSkuAttrRespVO.getValue());
            }

        }

        String attstr=String.join(";",list);
        bipCartItemRespVO.setAttr(attstr);

        bipItemDetailRespVO.setState(bipCartItemRespVO.getState());

        bipCartItemRespVO.setRelateItemId(bipItemDetailRespVO.getItemId());
        BipCartItemCovert.INSTANCE.bipItemDetailRespVOToBipCartItemVo(bipItemDetailRespVO, bipCartItemRespVO);
        if(bipItemSkuRespVO!=null){
//            bipCartItemRespVO.setBasePrice(bipItemSkuRespVO.getPrice());
//            bipCartItemRespVO.setCustPrice(bipItemSkuRespVO.getPriceGuide());
            bipCartItemRespVO.setSkuCode(bipItemSkuRespVO.getSkuCode());

        }
        bipCartItemRespVO.setItemSkuRespVO(bipItemSkuRespVO);

        if(bipItemDetailRespVO.getPicList()!=null&&!bipItemDetailRespVO.getPicList().isEmpty()){
            BipItemPicRespVO bipItemPicRespVO=bipItemDetailRespVO.getPicList().get(0);
            bipCartItemRespVO.setMainPicFileCode(bipItemPicRespVO.getFileCode());

        }

    }


    /**
     * @Description: 查看商品库存是否足够
     * @Param: [skuId, num]
     * @return: java.lang.Boolean
     * @Author: wangyinghao
     * @Date: 2021/9/8
     */
    public Boolean checkCartStorm(Long skuId,Long num){
        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(skuId).get();
        if(bipItemSkuDO.getStock()!=null&&bipItemSkuDO.getStock()>=num.intValue()){
            return true;
        }
        return false;
    }


    /**
     * 查询商品sku 信息
     * @param skuId
     * @param itemId
     * @param skuCode
     * @return
     */
    public BipItemSkuRespVO findItemSkuInfo(Long skuId,Long itemId,String skuCode){
        BipItemDetailRespVO bipItemDetailRespVO = bipItemService.get(itemId).getData();
        BipItemSkuDO bipItemSkuDO=null;
        if(Objects.isNull(skuId)){
            bipItemSkuDO=bipItemSkuRepo.findByBipItemIdAndSkuCode(itemId,skuCode);
        }else{
            bipItemSkuDO=bipItemSkuRepo.getOne(skuId);
        }

        BipItemSkuRespVO bipItemSkuRespVO= BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);

        return bipItemSkuRespVO;
    }

    /**
     * 满减折扣信息
     * @param itemVOList
     * @param ouId
     * @param custLevel
     */
    public void buildMkDisscountOffsetInfo(List<BipCartItemRespVO> itemVOList, Long ouId, String custLevel) {

        List<Long> ids = itemVOList.stream().map(bipCartItemRespVO -> {return bipCartItemRespVO.getSkuId();}).distinct().collect(Collectors.toList());
        List<String> skuCodes = itemVOList.stream().map(bipCartItemRespVO -> {return bipCartItemRespVO.getSkuCode();}).distinct().collect(Collectors.toList());
        log.info("满减折扣请求参数，ouId--{},custLevel--{},ids--{},skuCodes--{}",ouId,custLevel,ids,skuCodes);

        //   List<MktDiscountOffsetVO>mktDiscountOffsetVOS = mktDiscountOffsetService.findMktDiscountOffsetByParam(ouId, custLevel, ids);

        List<MktDiscountOffsetVO>mktDiscountOffsetVOS = mktDiscountOffsetService.findMktDiscountOffsetByParamCode(ouId, custLevel, skuCodes);

        log.info("满减折扣返回信息---"+JSON.toJSONString(mktDiscountOffsetVOS));

        Map<String,List<MktDiscountOffsetVO>> map=mktDiscountOffsetVOS.stream().collect(Collectors.groupingBy(MktDiscountOffsetVO::getItemCode));

        for(BipCartItemRespVO bipCartItemRespVO:itemVOList){
            Long itemId=bipCartItemRespVO.getItemId();
            Long skuId=bipCartItemRespVO.getSkuId();
            String skuCode = bipCartItemRespVO.getSkuCode();

            if(map==null||map.isEmpty()){
                bipCartItemRespVO.setMktDiscountOffsetAmt(bipCartItemRespVO.getItemAmt());
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                continue;
            }

            // List<MktDiscountOffsetVO> mktDiscountOffsetVOList=map.get(skuId);
            List<MktDiscountOffsetVO> mktDiscountOffsetVOList=map.get(skuCode);
            if(mktDiscountOffsetVOList==null||mktDiscountOffsetVOList.isEmpty()){
                bipCartItemRespVO.setMktDiscountOffsetAmt(bipCartItemRespVO.getItemAmt());
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                continue;
            }
            List<MktDiscountOffsetVO> matchMktDiscountOffsetVOS=mktDiscountOffsetVOList.stream().filter(mktDiscountOffsetVO->{
                return matchDiscount(mktDiscountOffsetVO,bipCartItemRespVO);
            }).collect(Collectors.toList());

            log.info("满减折扣匹配到折扣信息---"+JSON.toJSONString(matchMktDiscountOffsetVOS));

            matchMktDiscountOffsetVOS.stream().sorted(Comparator.comparing(MktDiscountOffsetVO::getFreeAmt));

            if(matchMktDiscountOffsetVOS==null||matchMktDiscountOffsetVOS.isEmpty()){
                bipCartItemRespVO.setMktDiscountOffsetAmt(bipCartItemRespVO.getItemAmt());
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
            }else{
                //按照金额
                // itemAmt
                MktDiscountOffsetVO mktDiscountOffsetVO = new MktDiscountOffsetVO();
                if (matchMktDiscountOffsetVOS.get(0).getType().equals("1")){
                    matchMktDiscountOffsetVOS = matchMktDiscountOffsetVOS.stream().sorted(Comparator.comparing(MktDiscountOffsetVO :: getLimitAmt).reversed()).collect(Collectors.toList());
                    for(MktDiscountOffsetVO mktDiscountOffset : matchMktDiscountOffsetVOS){

                        if(bipCartItemRespVO.getItemAmt().compareTo(mktDiscountOffset.getLimitAmt()) >= 0){
                            //       if(disRule(mktDiscountOffset)){
                            mktDiscountOffsetVO = mktDiscountOffset;
                            break;
                            //          }
                        }
                    }
                }
                //按照数量
                if(matchMktDiscountOffsetVOS.get(0).getType().equals("0")){
                    matchMktDiscountOffsetVOS = matchMktDiscountOffsetVOS.stream().sorted(Comparator.comparing(MktDiscountOffsetVO :: getLimitNum).reversed()).collect(Collectors.toList());
                    for(MktDiscountOffsetVO mktDiscountOff : matchMktDiscountOffsetVOS){
                        if(bipCartItemRespVO.getItemNum() >= mktDiscountOff.getLimitNum()){
                            //        if(disRule(mktDiscountOff)){
                            mktDiscountOffsetVO = mktDiscountOff;
                            break;
                            //      }
                        }
                    }
                }
                if(null == mktDiscountOffsetVO || null == mktDiscountOffsetVO.getItemId()){
                    bipCartItemRespVO.setMktDiscountOffsetAmt(bipCartItemRespVO.getItemAmt());
                    bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                }else {
                    //      MktDiscountOffsetVO mktDiscountOffsetVO=matchMktDiscountOffsetVOS.get(0);
                    bipCartItemRespVO.setMktDiscountOffsetId(mktDiscountOffsetVO.getMktDiscountOffsetId());
                    bipCartItemRespVO.setMktDiscountOffsetDId(mktDiscountOffsetVO.getMktDiscountOffsetDId());


                    BigDecimal freeAmt=mktDiscountOffsetVO.getFreeAmt()==null?BigDecimal.ZERO:mktDiscountOffsetVO.getFreeAmt();
                    bipCartItemRespVO.setMktDiscountOffsetFreeAmt(freeAmt);
                    bipCartItemRespVO.setMktDiscountOffsetAmt(bipCartItemRespVO.getItemAmt().subtract(freeAmt));
                }
            }

        }
    }


    public Boolean disRule(MktDiscountOffsetVO mktDiscountOffsetVO){
        //折扣金额/满足条件的金额，这个比例必须小于（基础价格-最低销售价格）/基础价格
        //减免金额
        BigDecimal freeAmt = mktDiscountOffsetVO.getFreeAmt();
        //基础价
        BigDecimal basePrice = mktDiscountOffsetVO.getBasePrice();
        //按照金额
        if(mktDiscountOffsetVO.getType().equals("1")){
            //达标金额
            BigDecimal limitAmt = mktDiscountOffsetVO.getLimitAmt();
            BigDecimal disScale = freeAmt.divide(limitAmt,4, RoundingMode.HALF_UP);
            //获取底价
            BigDecimal floorPrice = getMinPrice(mktDiscountOffsetVO);
            if(floorPrice.compareTo(BigDecimal.ZERO)==0){
                return false;
            }
            BigDecimal floorScale = (basePrice.subtract(floorPrice)).divide(basePrice,4,RoundingMode.HALF_UP);
            if (disScale.compareTo(floorScale) < 0){
                return true;
            }
        }
        //按照数量
        if(mktDiscountOffsetVO.getType().equals("0")){
            BigDecimal amt = new BigDecimal(mktDiscountOffsetVO.getLimitNum()).multiply(basePrice);
            BigDecimal disScale = freeAmt.divide(amt,4, RoundingMode.HALF_UP);
            //获取底价
            BigDecimal floorPrice = getMinPrice(mktDiscountOffsetVO);
            if(floorPrice.compareTo(BigDecimal.ZERO)==0){
                return false;
            }
            BigDecimal floorScale = (basePrice.subtract(floorPrice)).divide(basePrice,4,RoundingMode.HALF_UP);
            if (disScale.compareTo(floorScale) < 0){
                return true;
            }
        }
        return false;
    }

    public BigDecimal getMinPrice(MktDiscountOffsetVO mktDiscountOffsetVO){
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if(bipCustUserBindDO==null || null == bipCustUserBindDO.getCustId()){
            return BigDecimal.ZERO;
        }
        PriSalePriceReqDTO priSalePriceReqDTO = new PriSalePriceReqDTO();
        priSalePriceReqDTO.setOuId(mktDiscountOffsetVO.getOuId());
        priSalePriceReqDTO.setCustId(bipCustUserBindDO.getCustId());
        priSalePriceReqDTO.setCustCode(bipCustUserBindDO.getCustCode());
        List<PriSaleItemReqDTO> list = new ArrayList<>();
        PriSaleItemReqDTO priSaleItemReqDTO = new PriSaleItemReqDTO();
        priSaleItemReqDTO.setItemId(mktDiscountOffsetVO.getItemId());
        priSaleItemReqDTO.setUom(mktDiscountOffsetVO.getUom());
        list.add(priSaleItemReqDTO);
        priSalePriceReqDTO.setItems(list);
        ApiResult<PriSalePriceDTO> res = priSalePriceRpcService.findSalePriceDto(priSalePriceReqDTO);
        if(res.getCode() == 200 && null != res.getData() && null != res.getData().getPriceList() && !res.getData().getPriceList().isEmpty()){
            PriSalePriceSimpleDTO priSalePriceSimpleDTO = res.getData().getPriceList().get(0);
            return priSalePriceSimpleDTO.getFloorPrice();
        }
        return BigDecimal.ZERO;
    }




    /**
     * 匹配折扣信息
     * @param mktDiscountOffsetVO
     * @param bipCartItemRespVO
     * @return
     */
    public Boolean matchDiscount(MktDiscountOffsetVO mktDiscountOffsetVO,BipCartItemRespVO  bipCartItemRespVO) {
        if (mktDiscountOffsetVO.getLimitNum() != null) {
            if (mktDiscountOffsetVO.getLimitNum() <= bipCartItemRespVO.getItemNum()) {
                return true;
            }
        }
        if (mktDiscountOffsetVO.getLimitAmt() != null) {
            if (mktDiscountOffsetVO.getLimitAmt().compareTo(bipCartItemRespVO.getItemAmt()) <= 0) {
                return true;
            }
        }
        return false;
    }


    /**
     * 购物车修改
     *
     * @param bipCartParmVO
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCart(BipCartParmVO bipCartParmVO) {
        log.info("购物车修改参数---" + JSON.toJSONString(bipCartParmVO));
        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }
        if(bipCustUserBindDO==null){
            throw new BusinessException("请绑定公司信息!");
        }
        if(bipCartParmVO.getUserId()==null){
            bipCartParmVO.setUserId(currentUserDTO.getUserId());
        }

        Long itemId=bipCartParmVO.getItemId();
        Long skuId=bipCartParmVO.getSkuId();
        if(itemId==null||skuId==null){
            throw new BusinessException("商品id和skuID不能为空!");
        }

        BipCartDO bipCartDo = bipCartRepo.findAllByUserIdAndItemIdAndSkuId(currentUserDTO.getUserId(), itemId, skuId);

        Long exitNum=0L;

        if(bipCartDo!=null&&!bipCartDo.getId().equals(bipCartParmVO.getId())){
            List<Long> list=new ArrayList();
            list.add(bipCartDo.getId());



            if(bipCartParmVO.getItemNum()==null){
                BipCartDO bipCartCurrentDo =bipCartRepo.findById(bipCartParmVO.getId()).get();
                exitNum=bipCartCurrentDo.getItemNum()==null?0L:bipCartCurrentDo.getItemNum();
                bipCartParmVO.setItemNum(exitNum);
            }

            exitNum=bipCartDo.getItemNum();
            bipCartParmVO.setItemNum(exitNum+bipCartParmVO.getItemNum());
            bipCartRepoProc.deleteCartByIds(list);
        }
        BipCartDO bipCartDOLis = BipCartCovert.INSTANCE.BipCartParmVo2BipCart(bipCartParmVO);
        bipCartRepo.save(bipCartDOLis);


    }


    /**
     * 购物车批量删除
     *
     * @param idList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteCart(List<Long> idList) {

        bipCartRepoProc.deleteCartByIds(idList);

    }

    @Override
    public List<AttrAPPRespVO> getAttrList(AttrAppParamVO attrAppParamVO) {
        if(null == attrAppParamVO.getItemId()){
            throw new BusinessException("商品不能为空");
        }
        if(null == attrAppParamVO.getAttrList() || attrAppParamVO.getAttrList().isEmpty()){
            return null;
        }
        String attrFirst = JSON.toJSONString(attrAppParamVO.getAttrList().get(0));
        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
        BooleanExpression e = qBipItemSkuDO.bipItemId.eq(attrAppParamVO.getItemId()).and(qBipItemSkuDO.deleteFlag.eq(0)).and(qBipItemSkuDO.attr.like("%" + attrFirst + "%"));
        Iterable<BipItemSkuDO> iterables = bipItemSkuRepo.findAll(e);
        if(!IterUtil.isEmpty(iterables)){
            List<AttrAPPRespVO> param = attrAppParamVO.getAttrList();
            List<BipItemSkuDO> list = Lists.newArrayList(iterables);
            List<BipItemSkuDO> attrList = new ArrayList<>();
            list.stream().forEach(l ->{
                String attr = l.getAttr();
                for(int i=0 ; i<param.size() ; i++){
                    String paramStr = JSON.toJSONString(param.get(i));
                    if(attr.contains(paramStr)){
                        attrList.add(l);
                    }
                }
            });
            attrList.stream().collect(Collectors.collectingAndThen(
                    Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(BipItemSkuDO ::getId))),ArrayList::new)
            );
            List<AttrAPPRespVO> attrStrRes = new ArrayList<>();
            if(null != attrList && !attrList.isEmpty()){
                attrList.stream().forEach(al ->{
                    String attr = al.getAttr();
                    List<AttrAPPRespVO> listVos = JSON.parseArray(attr,AttrAPPRespVO.class);
                    if(attrAppParamVO.getAttrList().size() == 1){
                        if(attr.contains(attrFirst) && attr.contains(attrFirst)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if(attrAppParamVO.getAttrList().size() == 2){
                        String second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        if(attr.contains(attrFirst) && attr.contains(second)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if(attrAppParamVO.getAttrList().size() == 3){
                        String second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        String third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        if(attr.contains(attrFirst) && attr.contains(second) && attr.contains(third)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if(attrAppParamVO.getAttrList().size() == 4){
                        String second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        String third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        String fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        if(attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if(attrAppParamVO.getAttrList().size() == 5){
                        String second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        String third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        String fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        String fifth = JSON.toJSONString(attrAppParamVO.getAttrList().get(4));
                        if(attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth) && attr.contains(fifth)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if(attrAppParamVO.getAttrList().size() == 6){
                        String second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        String third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        String fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        String fifth = JSON.toJSONString(attrAppParamVO.getAttrList().get(4));
                        String sixth = JSON.toJSONString(attrAppParamVO.getAttrList().get(5));
                        if(attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth) && attr.contains(fifth) && attr.contains(sixth)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if(attrAppParamVO.getAttrList().size() == 7){
                        String second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        String third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        String fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        String fifth = JSON.toJSONString(attrAppParamVO.getAttrList().get(4));
                        String sixth = JSON.toJSONString(attrAppParamVO.getAttrList().get(5));
                        String seveth = JSON.toJSONString(attrAppParamVO.getAttrList().get(6));
                        if(attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth) && attr.contains(fifth) && attr.contains(sixth) && attr.contains(seveth)){
                            attrStrRes.addAll(listVos);
                        }
                    }
                });
            }
            //去重
            if(null != attrStrRes && !attrStrRes.isEmpty()){
                return attrStrRes.stream().collect(Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(AttrAPPRespVO ::getValue))),ArrayList::new)
                );
            }
        }
        return null;
    }


    /**
     * 设置购物车满赠信息
     *
     * @param bipCartItemRespVO
     */
    public void buildItemDisscountGiftInfo(BipCartItemRespVO bipCartItemRespVO,Long ouId, String custLevel) {

        MktGiftRespVO mktGiftRespVO = null;
        MktDiscountGiftVO mktDiscountGiftVO = null;
        //如果页面没选择过赠品
        if (bipCartItemRespVO.getMktGiftId() == null) {

            BigDecimal priceGuide = bipCartItemRespVO.getItemSkuRespVO().getPriceGuide();
            Long num = bipCartItemRespVO.getItemNum();
            BigDecimal itemAmt = priceGuide.multiply(BigDecimal.valueOf(num));
            Long id = bipCartItemRespVO.getItemId();
            LocalDateTime now = LocalDateTime.now();
            List<Long> itemIds = new ArrayList<>();
            itemIds.add(bipCartItemRespVO.getSkuId());
            List<MktDiscountGiftVO> mkList = mktDiscountGiftService.findMktDiscountGiftByParam(ouId, custLevel, itemIds);
            AtomicBoolean flag = new AtomicBoolean(false);
            List<MktDiscountGiftVO> mktDiscountGiftVOList = new ArrayList<>();
            mkList.stream().forEach(mk ->{
                if (mk.getLimitNum() != null) {
                    if (mk.getLimitNum() <= bipCartItemRespVO.getItemNum()) {
                        mktDiscountGiftVOList.add(mk);
                        flag.set(true);
                    }
                }
                if (!flag.get() && mk.getLimitAmt() != null && bipCartItemRespVO.getItemAmt() != null) {
                    if (mk.getLimitAmt().compareTo(bipCartItemRespVO.getItemAmt()) >= 0) {
                        mktDiscountGiftVOList.add(mk);
                    }
                }
            });
            //    JPAQuery<MktDiscountGiftVO> jpaQuery = mktDiscountGiftRepoProc.findMatchMktDisCountGift(ouId, custLevel, now, id, num, itemAmt);

            //   List<MktDiscountGiftVO> mktDiscountGiftVOList = jpaQuery.fetch();
            if(mktDiscountGiftVOList!=null&&!mktDiscountGiftVOList.isEmpty()){
                mktDiscountGiftVO = mktDiscountGiftVOList.get(0);
                JPAQuery<MktGiftRespVO> giftRespVOJPAQuery = mktDiscountGiftRepoProc.selectGiftDetailsByMasCodeOrItemId(mktDiscountGiftVO.getCode(), mktDiscountGiftVO.getItemId());
                List<MktGiftRespVO> mktGiftRespVOS = giftRespVOJPAQuery.fetch();

                if(mktGiftRespVOS!=null&&!mktGiftRespVOS.isEmpty()){
                    List<MktGiftRespVO> sortMktGiftRespVOS = mktGiftRespVOS.stream().sorted(Comparator.comparing(MktGiftRespVO::getStockNum).reversed()).collect(Collectors.toList());
                    mktGiftRespVO = sortMktGiftRespVOS.get(0);
                }
            }
        } else {
            // 后台适配赠品信息
            MktGiftDO mktGiftDO = mktGiftRepo.findById(bipCartItemRespVO.getMktGiftId()).get();
            mktGiftRespVO = MktGiftCovert.INSTANCE.doToResoVo(mktGiftDO);

            MktDiscountGiftDO mktDiscountGiftDO = mktDiscountGiftRepo.getOne(bipCartItemRespVO.getMktDiscountGiftDId());

            mktDiscountGiftVO = new MktDiscountGiftVO();
            mktDiscountGiftVO.setValidEtime(mktDiscountGiftDO.getValidEtime());
            mktDiscountGiftVO.setValidStime(mktDiscountGiftDO.getValidStime());

        }


        if (checkDiscountGift(mktDiscountGiftVO) && checkGift(mktGiftRespVO)) {
            bipCartItemRespVO.setMktGiftId(mktGiftRespVO.getId());
            bipCartItemRespVO.setMktGiftItemName(mktDiscountGiftVO.getItemName());
            bipCartItemRespVO.setMktGiftRespVO(mktGiftRespVO);
        } else {
            bipCartItemRespVO.setMktGiftId(null);
            bipCartItemRespVO.setMktGiftRespVO(null);
            bipCartItemRespVO.setMktGiftItemName(null);
        }
    }


    /**
     * 验证是否赠品是否有效
     * @param mktGiftRespVO
     * @return
     */
    public Boolean checkGift(MktGiftRespVO mktGiftRespVO) {

        LocalDateTime now = LocalDateTime.now();
        //是否有效期
        if (mktGiftRespVO != null) {

            if (mktGiftRespVO.getValidStime().isBefore(now) && mktGiftRespVO.getValidEtime().isAfter(now)) {

                return true;
            }
        }
        return false;
    }


    /**
     * 验证折扣是否有效
     * @param mktDiscountGiftVO
     * @return
     */
    public Boolean checkDiscountGift(MktDiscountGiftVO mktDiscountGiftVO) {

        LocalDateTime now = LocalDateTime.now();
        //是否有效期
        if (mktDiscountGiftVO != null) {

            if (mktDiscountGiftVO.getValidStime().isBefore(now) && mktDiscountGiftVO.getValidEtime().isAfter(now)) {

                return true;
            }

        }
        return false;
    }



    /**
     * 验证优惠券是否有效
     * @param bipCouponDO
     * @return
     */
    public Boolean checkCoupon(BipCouponDO bipCouponDO) {

        LocalDateTime now = LocalDateTime.now();
        //是否有效期
        if (bipCouponDO != null) {

            if (bipCouponDO.getValidStime().isBefore(now) && bipCouponDO.getValidEtime().isAfter(now)) {

                return true;
            }

        }
        return false;
    }

    /**
     * @Description: 构造购物车商品优惠券信息
     * @Param: [bipCartItemVO]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/12
     */
    public void buildItemCoupon(BipCartVo bipCartVo,Long userId,Long ouId) {
        //@TODO 获取可用优惠券信息
        BipCouponDO bipCouponDO = null;
        List<BipCartItemRespVO> itemRespVOList=bipCartVo.getItemList();

        BipCouponCustCurrentParam bipCouponCustCurrentParam = new BipCouponCustCurrentParam();
        List<BipCouponCustItemParam> itemParams = new ArrayList<>();


        for(BipCartItemRespVO bipCartItemRespVO:itemRespVOList){
            BipCouponCustItemParam itemParam = new BipCouponCustItemParam();
            itemParam.setSkuId(bipCartItemRespVO.getSkuId());
            itemParam.setItemId(bipCartItemRespVO.getItemId());
            itemParam.setItemCode(bipCartItemRespVO.getItemCode());
            itemParam.setTotalAmount(bipCartItemRespVO.getItemAmt());
            itemParams.add(itemParam);
        }
        bipCouponCustCurrentParam.setList(itemParams);
        bipCouponCustCurrentParam.setOuId(ouId);
        bipCouponCustCurrentParam.setUserId(userId);

        log.info("优惠券查询参数：--" + JSON.toJSONString(bipCouponCustCurrentParam));

        List<BipCouponCustVO> couponCustVOS = bipCouponCustService.currentUserCouponCust(bipCouponCustCurrentParam);
        //降序排列
        if(null != couponCustVOS && !couponCustVOS.isEmpty()){
            couponCustVOS.sort(Comparator.comparing(BipCouponCustVO::getFreeAmt).reversed());
            bipCartVo.setBipCouponCustVOS(couponCustVOS);

            if (Objects.isNull(bipCartVo.getCouponId())) {

                if(couponCustVOS!=null&&!couponCustVOS.isEmpty()){
                    couponCustVOS.stream().sorted(Comparator.comparing(BipCouponCustVO::getFreeAmt));
                    BipCouponCustVO bipCouponCustVO=couponCustVOS.get(0);
                    bipCouponDO=bipCouponRepo.findById(bipCouponCustVO.getCouponId()).get();
                }

            } else {
                bipCouponDO = bipCouponRepo.findById(bipCartVo.getCouponId()).get();
            }
            log.info("优惠券信息：--" + JSON.toJSONString(bipCouponDO));


            if(bipCouponDO!=null){
                bipCartVo.setCouponAmt(bipCouponDO.getFreeAmt());
                bipCartVo.setCouponId(bipCouponDO.getId());
                bipCartVo.setCouponName(bipCouponDO.getCouponName());
                bipCartVo.setCouponAmt(bipCouponDO.getFreeAmt());
            }
        }
    }




    @Override
    public BipCartVo findMyCart(Long ouId) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if(currentUserDTO==null){
            throw new BusinessException("请先登录!");
        }
        Long userId = currentUserDTO.getUserId();
        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(userId);
        } else {
            throw new BusinessException("请先登录!");
        }
        if(bipCustUserBindDO==null){
            throw new BusinessException("请绑定公司信息!");
        }
        Long custId = bipCustUserBindDO.getCustId();
        if(custId==null){
            throw new BusinessException("请先绑定所属公司!");
        }
        CrmCustDO crmCustDO = crmCustRepo.findById(custId).get();


        String custLevel = crmCustDO.getCustLevel();
        // Long ouId = crmCustDO.getOuId();

        String userName = currentUserDTO.getUserName();
        JPAQuery<BipCartItemRespVO> jpaQuery = bipCartRepoProc.findUserCartItemInfo(userId, null);

        // 查询并返回
        List<BipCartItemRespVO> itemVOList = jpaQuery.fetch();

        if(itemVOList==null||itemVOList.isEmpty()){
            return null;
        }
        List<BipCartItemRespVO> itemVOListCopy = new ArrayList<>();
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        itemVOList.stream().forEach(item ->{
            Long itemId = item.getItemId();
            //查询商品表里面是否存在
            BooleanExpression expression = qBipItemDO.id.eq(itemId).and(qBipItemDO.ouId.eq(ouId)).and(qBipItemDO.deleteFlag.eq(0));
            BipItemDO bipItemDO = jpaQueryFactory.select(qBipItemDO).from(qBipItemDO).where(expression).limit(1).fetchOne();
            item.setState("OFF");

            if (bipItemDO!=null){
                if (bipItemDO.getOnShelf()){
                    item.setState("SHELF");
                }
                itemVOListCopy.add(item);
            }

        });
        if(itemVOListCopy.isEmpty()){
            return null;
        }else {
            itemVOList = itemVOListCopy;
        }
        List<Long> itemIds=itemVOList.stream().map(BipCartItemRespVO::getItemId).distinct().collect(Collectors.toList());

        itemIds = bipItemRepoProc.findIdByItemIds(itemIds);
        if(null == itemIds && itemIds.isEmpty()){
            return null;
        }
        checkItmeIdRelateOuId(itemIds,ouId);

        BipCartVo bipCartVo = new BipCartVo();


        //构建BipCartItemVO的促销信息
        for (BipCartItemRespVO bipCartItemRespVO : itemVOList) {

            buildItemInfo(bipCartItemRespVO,ouId);

//            buildMkDisscountOffsetInfo(bipCartItemRespVO, ouId, custLevel);

            buildItemDisscountGiftInfo(bipCartItemRespVO, ouId, custLevel);
//            buildItemCoupon(bipCartItemRespVO,userId);

            bipCartItemRespVO.setUserId(userId);
            bipCartItemRespVO.setUserName(userName);

//            List<BigDecimal> prices = findSkuPrice(bipCartItemRespVO.getSkuCode(), userId);
//            if (prices==null||(prices.get(0)==null&&prices.get(1)==null)){
//                throw new BusinessException("商品"+bipCartItemRespVO.getItemName()+"缺少基础价格和客户等级价格");
//            }
            Map<String,BigDecimal> prices = findSkuPriceReMap(bipCartItemRespVO.getSkuCode(), userId,ouId);
            if (null == prices|| null == prices.get("basePrice")){
                throw new BusinessException("商品"+bipCartItemRespVO.getItemName()+"缺少基础价格");
            }

            if(null != prices && null != prices.get("basePrice")){
                bipCartItemRespVO.setBasePrice(prices.get("basePrice"));
            }
            if(null != prices && null != prices.get("custPrice")){
                bipCartItemRespVO.setCustPrice(prices.get("custPrice"));
            }
//            bipCartItemRespVO.setCustPrice(prices.get(0));
//            bipCartItemRespVO.setBasePrice(prices.get(1));

            BigDecimal amt=bipCartItemRespVO.getCustPrice()==null?bipCartItemRespVO.getBasePrice():bipCartItemRespVO.getCustPrice();

            if(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()==null||bipCartItemRespVO.getMktDiscountOffsetFreeAmt().compareTo(BigDecimal.ZERO)<=0){
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                bipCartItemRespVO.setMktDiscountOffsetAmt(amt.subtract(BigDecimal.ZERO));
                bipCartItemRespVO.setItemAmt(amt);
            }
            bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(amt));
            bipCartVo.setOrderDiscountFreeAmt(bipCartVo.getOrderDiscountFreeAmt().add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()));

        }

        bipCartVo.setItemList(itemVOList);
        List<String> ouName=itemVOList.stream().map(BipCartItemRespVO::getOuName).distinct().collect(Collectors.toList());
//        if(ouName!=null&&ouName.size()>1){
//            throw new BusinessException("只能购买所属公司商品！");
//        }
        bipCartVo.setOuName(ouName.get(0));

        return bipCartVo;

    }

    /**
     *获取运费金额
     */
    @Override
    public HashMap<String,Object> findFeeFare(BipFareAmtQueryParmVO bipFareAmtQueryParmVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("isShowSubmit",false);
        List<Boolean> isSubmit = new ArrayList<>();
        log.info("计算运费请求参数:"+JSON.toJSONString(bipFareAmtQueryParmVO));
        //构造运费信息
        LogisticsTemplateDFindParam logisticsTemplateDFindParam = new LogisticsTemplateDFindParam();
        BipAddressVO bipAddressVO = null;
        Long addressId=bipFareAmtQueryParmVO.getAddressId();
        if(addressId==null){
            //return BigDecimal.ZERO;
            map.put("totalFareAmt",BigDecimal.ZERO) ;
            return (HashMap<String, Object>) map;
        }

        bipAddressVO = bipAddressService.findById(addressId);

        if (bipAddressVO == null) {
            // return BigDecimal.ZERO;
            map.put("totalFareAmt",BigDecimal.ZERO) ;
            return (HashMap<String, Object>) map;
        }

        BigDecimal totalFareAmt = BigDecimal.ZERO;
        map.put("totalFareAmt",totalFareAmt) ;
        List<BipFareAmtQueryParmVO.FareAmtInfo> list = bipFareAmtQueryParmVO.getFareAmtInfos();

        for (BipFareAmtQueryParmVO.FareAmtInfo bipCartItemRespVO : list) {
            String area = bipAddressVO.getArea();
            if(StringUtils.isBlank(area)){
                area=getArea(bipAddressVO);
            }
            //    logisticsTemplateDFindParam.setArea(area);
            logisticsTemplateDFindParam.setTemplateId(bipCartItemRespVO.getTemplateId());
            logisticsTemplateDFindParam.setCityCode(bipAddressVO.getCity());
            logisticsTemplateDFindParam.setProvinceCode(bipAddressVO.getProvince());
            List<LogisticsTemplateDFindParam> params = new ArrayList<>();
            params.add(logisticsTemplateDFindParam);
            log.info("请求运费信息参数:"+JSON.toJSONString(logisticsTemplateDFindParam));
            if (bipCartItemRespVO.getFareFree() != null && bipCartItemRespVO.getFareFree() == false) {
                List<LogisticsTemplateDVO> result = logisticsTemplateDService.getByArea(logisticsTemplateDFindParam);

                log.info("请求运费返回信息:"+JSON.toJSONString(result));

                if (result != null && !result.isEmpty()) {
                    map.put("isShowSubmit",true);
                    LogisticsTemplateDVO logisticsTemplateDVO = result.get(0);
                    //增加运费
                    BigDecimal incAmt = logisticsTemplateDVO.getAddFreight();
                    //默认运费
                    BigDecimal baseAmt = logisticsTemplateDVO.getDefFreight();
                    //默认件数
                    Integer baseNum = logisticsTemplateDVO.getPieceNumber();
                    // 续件数
                    Integer incNum = logisticsTemplateDVO.getContinuypieceNumber();
                    //商品件数
                    Long itemNum = bipCartItemRespVO.getItemNum();

                    Long num = itemNum - baseNum;
                    BigDecimal inc = BigDecimal.valueOf(num).divide(BigDecimal.valueOf(incNum), 0, RoundingMode.UP);

                    BigDecimal fareAmt = baseAmt.add(incAmt.multiply(inc));
                    if(fareAmt.compareTo(BigDecimal.ZERO) < 0){
                        fareAmt = BigDecimal.ZERO;
                    }

                    totalFareAmt=totalFareAmt.add(fareAmt);

                }else {
                    isSubmit.add(false);
                }
            }
            if(bipCartItemRespVO.getFareFree()){
                map.put("isShowSubmit",true);
            }
        }
        if(!isSubmit.isEmpty()){
            map.put("isShowSubmit",false);
        }
        map.put("totalFareAmt",totalFareAmt);
        return (HashMap<String, Object>) map;
    }

    /**
     * 构建订单运费信息
     * @param bipCartItemRespVO
     */
    public void buildItemFareInfo(BipCartItemRespVO bipCartItemRespVO,Long addressId){
        log.info("构建运费信息");
        //构造运费信息
        LogisticsTemplateDFindParam logisticsTemplateDFindParam=new LogisticsTemplateDFindParam();
        BipAddressVO bipAddressVO=null;
        if(addressId==null){
            List<BipAddressVO> bipAddressVOS=bipAddressService.findByAccountId();
            if(bipAddressVOS==null||bipAddressVOS.isEmpty()){
//                throw new BusinessException("收货地址不能为空!");
                return;
            }
            bipAddressVO= bipAddressVOS.get(0);
        }else {
            bipAddressVO=bipAddressService.findById(addressId);
        }
        if(bipAddressVO==null){
            throw new BusinessException("收货地址不能为空!");
        }
        bipCartItemRespVO.setBipAddressVO(bipAddressVO);

        if(bipCartItemRespVO.getItemId()==null){
            throw new BusinessException("商品ID不能为空!");
        }
        Long itemId=bipCartItemRespVO.getItemId();
        BipItemDO bipItemDO=bipItemRepo.findById(itemId).get();

        log.info("商品主信息"+JSON.toJSONString(bipItemDO));
        Boolean fareFree=bipItemDO.getFareFree();
        Long templateId=bipItemDO.getFareTmplId();

        bipCartItemRespVO.setFareFree(fareFree);
        bipCartItemRespVO.setFareTmplId(templateId);
        bipCartItemRespVO.setFareTmplCode(bipItemDO.getFareTmplCode());
        bipCartItemRespVO.setFareTmplName(bipItemDO.getFareTmplName());


        String area=bipAddressVO.getArea();

        if(StringUtils.isBlank(area)){
            area=getArea(bipAddressVO);
        }
        // logisticsTemplateDFindParam.setArea(area);
        logisticsTemplateDFindParam.setProvinceCode(bipAddressVO.getProvince());
        logisticsTemplateDFindParam.setCityCode(bipAddressVO.getCity());
        logisticsTemplateDFindParam.setTemplateId(bipCartItemRespVO.getFareTmplId());
        List<LogisticsTemplateDFindParam> params=new ArrayList<>();
        params.add(logisticsTemplateDFindParam);

        log.info("运费信息请求参数:"+JSON.toJSONString(logisticsTemplateDFindParam));
        if(bipCartItemRespVO.getFareFree()!=null &&bipCartItemRespVO.getFareFree()==false){
            List<LogisticsTemplateDVO>  result=logisticsTemplateDService.getByArea(logisticsTemplateDFindParam);

            log.info("运费返回信息:"+JSON.toJSONString(result));

            if(result!=null && !result.isEmpty()){

                log.info("物流运费信息:"+JSON.toJSONString(result));
                LogisticsTemplateDVO logisticsTemplateDVO=result.get(0);
                //增加运费
                BigDecimal incAmt=logisticsTemplateDVO.getAddFreight();
                //默认运费
                BigDecimal baseAmt=logisticsTemplateDVO.getDefFreight();
                //默认件数
                Integer baseNum=logisticsTemplateDVO.getPieceNumber();
                // 续件数
                Integer incNum=logisticsTemplateDVO.getContinuypieceNumber();
                //商品件数
                Long itemNum=bipCartItemRespVO.getItemNum();


                Long num=itemNum-baseNum;
                BigDecimal inc=BigDecimal.valueOf(num).divide(BigDecimal.valueOf(incNum),0, RoundingMode.UP);

                BigDecimal fareAmt=baseAmt.add(incAmt.multiply(inc));

                bipCartItemRespVO.setFareArm(fareAmt);
            }
        }
    }


    public String getArea(BipAddressVO bipAddressVO){
        if(bipAddressVO.getProvinceName()==null){
            throw new BusinessException("地址省份为空!");
        }
        if(bipAddressVO.getCityName()==null){
            throw new BusinessException("地址城市为空!");
        }
        String area=bipAddressVO.getProvinceName()+bipAddressVO.getCityName();
        log.info("收货地址区域--"+area);
        return area;
    }
}
