package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.sale.api.service.shop.MktGiftService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QMktGiftDO;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 满减赠折扣赠服务
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class MktGiftServiceImpl extends BaseServiceImpl implements MktGiftService {

    /**
     * proc
     */
    private final MktGiftRepoProc mktGiftRepoProc;

    @Override
    public PagingVO<MktGiftRespVO> search(MktGiftQueryVO queryParam) {
        QMktGiftDO qmktGiftDO = QMktGiftDO.mktGiftDO;
        var jpaQuery = mktGiftRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<MktGiftRespVO>builder().build();
        }
        var pageRequest = wrapperPageRequest(queryParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qmktGiftDO);
        List<MktGiftRespVO> pageResult = jpaQuery.fetch();
        return PagingVO.<MktGiftRespVO>builder().total(total).records(pageResult).build();
    }

    @Override
    public Optional<List<MktGiftRespVO>> findByDiscountGiftCode(String code) {
        QMktGiftDO qmktGiftDO = QMktGiftDO.mktGiftDO;
        List<MktGiftRespVO> source = mktGiftRepoProc.select(null).where(qmktGiftDO.itemCode.eq(code)).fetch();
        if (CollUtil.isEmpty(source)) {
            return Optional.empty();
        }
        return Optional.of(source);
    }

    @Override
    public Optional<MktGiftRespVO> findIdOne(Long id) {
        QMktGiftDO qmktGiftDO = QMktGiftDO.mktGiftDO;
        MktGiftRespVO mktGiftRespVO = mktGiftRepoProc.select(null).where(qmktGiftDO.id.eq(id)).fetchOne();
        if (mktGiftRespVO == null) {
            return Optional.empty();
        }
        return Optional.of(mktGiftRespVO);
    }
}
