/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.dto.BipCustPriceDTO;
import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriCrossPriceQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePricePagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceQueryOneParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriCrossPriceRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePricePageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.PriSalePriceConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.PriSalePriceDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceDO;
import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PriSalePriceServiceImpl
extends BaseServiceImpl
implements PriSalePriceService {
    private static final Logger log = LoggerFactory.getLogger(PriSalePriceServiceImpl.class);
    private final QPriSalePriceDO qPriSalePriceDO = QPriSalePriceDO.priSalePriceDO;
    private final CrmCustService crmCustService;
    private final RmiPriMainPriceService rmiPriMainPriceService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiCommonService rmiComService;
    private final RmiPurPriceService rmiPurPriceService;
    private final RmiSysUserService rmiSysUserService;
    public static final String TYPE_BASE = UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode();
    public static final String TYPE_CUST = UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode();
    public static final String TYPE_GROUP = UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode();
    public static final String TYPE_CROSS = UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode();

    @SysCodeProc
    public PagingVO<PriSalePricePageRespVO> query(PriSalePricePagingParam param) {
        return null;
    }

    public List<PriSalePricePageRespVO> queryExistPrice(Long ouId, List<Long> custIds, String custGroup, List<Long> itemIds, String priceType) {
        BooleanExpression predicate = this.qPriSalePriceDO.ouId.eq((Object)ouId);
        if (StrUtil.isNotBlank((CharSequence)priceType)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.priceType.eq((Object)priceType));
        }
        if (CollUtil.isNotEmpty(itemIds)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemId.in(itemIds));
        }
        if (StrUtil.equalsAny((CharSequence)priceType, (CharSequence[])new CharSequence[]{TYPE_CUST, TYPE_CROSS}) && CollUtil.isNotEmpty(custIds)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.custId.in(custIds));
        } else if (TYPE_GROUP.equals(priceType) && StrUtil.isNotBlank((CharSequence)custGroup)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.custGroup.eq((Object)custGroup));
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPriSalePriceDO).where((Predicate)predicate);
        PriSalePriceConvert convert = PriSalePriceConvert.INSTANCE;
        List priSalePriceDOS = jpaQuery.fetch();
        return priSalePriceDOS.stream().map(convert::doToPageRespVo).collect(Collectors.toList());
    }

    public List<PriSalePricePageRespVO> queryExistPrice(List<Long> ouIds, List<Long> itemIds) {
        BooleanExpression predicate = this.qPriSalePriceDO.ouId.in(ouIds);
        if (CollUtil.isNotEmpty(itemIds)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemId.in(itemIds));
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPriSalePriceDO).where((Predicate)predicate);
        PriSalePriceConvert convert = PriSalePriceConvert.INSTANCE;
        List priSalePriceDOS = jpaQuery.fetch();
        return priSalePriceDOS.stream().map(convert::doToPageRespVo).collect(Collectors.toList());
    }

    public ApiResult<PriSalePriceRespVO> querySalePrice(PriSalePriceQueryParam param) {
        return null;
    }

    public ApiResult<PriCrossPriceRespVO> queryCrossPrice(PriCrossPriceQueryParam param) {
        return null;
    }

    private List<PriSalePriceDO> doQueryPrice(boolean crossType, Long ouId, String currCode, List<Long> itemIds) {
        BooleanExpression predicate = this.qPriSalePriceDO.ouId.eq((Object)ouId);
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.currCode.eq((Object)currCode));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemId.in(itemIds));
        predicate = crossType ? ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.priceType.eq((Object)TYPE_CROSS)) : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.priceType.notIn((Object[])new String[]{TYPE_CROSS}));
        predicate = this.addValidTimeCondition((Predicate)predicate);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPriSalePriceDO).where((Predicate)predicate);
        return jpaQuery.fetch();
    }

    @SysCodeProc
    public PriSalePriceDetailVO queryOnePrice(PriSalePriceQueryOneParam param) {
        return null;
    }

    public PriSalePriceTypeRespVO queryPrice(PriSalePriceTypeQueryParam param) {
        return null;
    }

    @Cacheable(value={"yst_sale_item_price"}, key="'all'", unless="#result.success == false")
    public ApiResult<List<BipCustPriceDTO>> queryCustPrice(Long itemId) {
        List priceList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipCustPriceDTO.class, (Expression[])new Expression[]{this.qPriSalePriceDO.priceType, this.qPriSalePriceDO.itemId, this.qPriSalePriceDO.itemCode, this.qPriSalePriceDO.custId, this.qPriSalePriceDO.custGroup, this.qPriSalePriceDO.price, this.qPriSalePriceDO.netPrice, this.qPriSalePriceDO.validFrom, this.qPriSalePriceDO.validTo})).from((EntityPath)this.qPriSalePriceDO)).where((Predicate)this.qPriSalePriceDO.itemId.eq((Object)itemId).and((Predicate)this.qPriSalePriceDO.priceType.in((Object[])new String[]{UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode(), UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode()})).and((Predicate)this.qPriSalePriceDO.priceStatus.eq((Object)UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode())))).fetch();
        if (priceList == null) {
            priceList = Collections.emptyList();
        }
        return ApiResult.ok(priceList);
    }

    private BigDecimal getItemUomConvRatio(List<ItmItemUomConvRpcDTO> itmUomConvRpcResult, Long itemId, String fromUom, String toUom) {
        Optional<ItmItemUomConvRpcDTO> uo = itmUomConvRpcResult.stream().filter(u -> u.getItemId().equals(itemId) && fromUom.equals(u.getFromUom()) && toUom.equals(u.getToUom())).findFirst();
        return uo.map(ItmItemUomConvRpcDTO::getRatio).orElse(null);
    }

    @SysCodeProc
    public List<BipInvItemDTO> queryItemByItemCode(List<String> sku) {
        List<BipInvItemDTO> fetch = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipInvItemDTO.class, (Expression[])new Expression[]{this.qPriSalePriceDO.itemCode, this.qPriSalePriceDO.itemName, this.qPriSalePriceDO.itemSpec, this.qPriSalePriceDO.uom, this.qPriSalePriceDO.netPrice, this.qPriSalePriceDO.taxRateNo, this.qPriSalePriceDO.taxRate, this.qPriSalePriceDO.price})).from((EntityPath)this.qPriSalePriceDO)).where((Predicate)this.qPriSalePriceDO.itemCode.in(sku))).fetch();
        if (fetch == null) {
            fetch = Collections.emptyList();
        }
        return fetch;
    }

    @SysCodeProc
    public List<BipInvItemDTO> queryBasePriceByItemCode(String sku) {
        List<PriSalePricePageRespVO> fetch = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PriSalePricePageRespVO.class, (Expression[])new Expression[]{this.qPriSalePriceDO.itemCode, this.qPriSalePriceDO.itemName, this.qPriSalePriceDO.itemSpec, this.qPriSalePriceDO.uom, this.qPriSalePriceDO.netPrice, this.qPriSalePriceDO.taxRateNo, this.qPriSalePriceDO.taxRate, this.qPriSalePriceDO.price, this.qPriSalePriceDO.promotionPrice, this.qPriSalePriceDO.promotionNetPrice, this.qPriSalePriceDO.promDateF, this.qPriSalePriceDO.promDateT})).from((EntityPath)this.qPriSalePriceDO)).where((Predicate)this.qPriSalePriceDO.itemCode.in((Object[])new String[]{sku}).and((Predicate)this.qPriSalePriceDO.priceType.eq((Object)TYPE_BASE)).and((Predicate)this.qPriSalePriceDO.validFrom.before((Comparable)LocalDateTime.now()).and((Predicate)this.qPriSalePriceDO.validTo.after((Comparable)LocalDateTime.now()))))).fetch();
        if (fetch == null) {
            fetch = Collections.emptyList();
        }
        return this.dateHandle(fetch);
    }

    private List<BipInvItemDTO> dateHandle(List<PriSalePricePageRespVO> fetch) {
        return fetch.stream().map(bip -> {
            BipInvItemDTO bipInvItemDTO = new BipInvItemDTO();
            if (!ObjectUtils.isEmpty((Object)bip.getPromDateF()) && (bip.getPromDateF().isBefore(LocalDateTime.now()) || bip.getPromDateF().isEqual(LocalDateTime.now())) && !ObjectUtils.isEmpty((Object)bip.getPromDateT()) && (bip.getPromDateT().isAfter(LocalDateTime.now()) || bip.getPromDateT().isEqual(LocalDateTime.now()))) {
                bipInvItemDTO.setPrice(bip.getPromotionPrice());
                bipInvItemDTO.setNetPrice(bip.getPromotionNetPrice());
            } else {
                bipInvItemDTO.setPrice(bip.getPrice());
                bipInvItemDTO.setNetPrice(bip.getNetPrice());
            }
            bipInvItemDTO.setItemCode(bip.getItemCode());
            bipInvItemDTO.setItemName(bip.getItemName());
            bipInvItemDTO.setItemSpec(bip.getItemSpec());
            bipInvItemDTO.setUom(bip.getUom());
            bipInvItemDTO.setTaxRate(bip.getTaxRate());
            bipInvItemDTO.setTaxRateNo(bip.getTaxRateNo());
            return bipInvItemDTO;
        }).collect(Collectors.toList());
    }

    private Predicate addValidTimeCondition(Predicate predicate) {
        LocalDateTime nowTime = LocalDateTime.now();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validFrom.before((Comparable)nowTime).or((Predicate)this.qPriSalePriceDO.validFrom.eq((Object)nowTime)));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validTo.after((Comparable)nowTime).or((Predicate)this.qPriSalePriceDO.validTo.eq((Object)nowTime)));
        return predicate;
    }

    private Predicate buildPageSearchCondition(PriSalePricePagingParam param) {
        BooleanExpression predicate = this.qPriSalePriceDO.isNotNull();
        if (Objects.nonNull(param)) {
            if (!StringUtils.isEmpty((Object)param.getItemCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemCode.like("%" + param.getItemCode() + "%"));
            }
            if (CollUtil.isNotEmpty((Collection)param.getItemIds())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemId.in((Collection)param.getItemIds()));
            }
            if (Objects.nonNull(param.getValidFromStart())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validFrom.after((Comparable)param.getValidFromStart()).or((Predicate)this.qPriSalePriceDO.validFrom.eq((Object)param.getValidFromStart())));
            }
            if (Objects.nonNull(param.getValidFromEnd())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validFrom.before((Comparable)param.getValidFromEnd()).or((Predicate)this.qPriSalePriceDO.validFrom.eq((Object)param.getValidFromEnd())));
            }
            if (Objects.nonNull(param.getValidToStart())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validTo.after((Comparable)param.getValidToStart()).or((Predicate)this.qPriSalePriceDO.validTo.eq((Object)param.getValidToStart())));
            }
            if (Objects.nonNull(param.getValidToEnd())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validTo.before((Comparable)param.getValidToEnd()).or((Predicate)this.qPriSalePriceDO.validTo.eq((Object)param.getValidToEnd())));
            }
            if (!StringUtils.isEmpty((Object)param.getItemCateCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.itemCateCode.eq((Object)param.getItemCateCode()));
            }
            if (!StringUtils.isEmpty((Object)param.getSaleRegion())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.saleRegion.eq((Object)param.getSaleRegion()));
            }
            if (!StringUtils.isEmpty((Object)param.getPriceType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.priceType.eq((Object)param.getPriceType()));
            }
            if (!CollectionUtils.isEmpty((Collection)param.getCustIds())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.custId.in((Collection)param.getCustIds()));
            }
            if (StrUtil.isNotBlank((CharSequence)param.getCustGroup())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.custGroup.eq((Object)param.getCustGroup()));
            }
            if (Objects.nonNull(param.getOuId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.ouId.eq((Object)param.getOuId()));
            }
            if (Objects.nonNull(param.getPriceStatus2())) {
                LocalDateTime now = LocalDateTime.now();
                predicate = param.getPriceStatus2() != false ? ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validFrom.loe((Comparable)now).and((Predicate)this.qPriSalePriceDO.validTo.gt((Comparable)now))) : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qPriSalePriceDO.validFrom.gt((Comparable)now).or((Predicate)this.qPriSalePriceDO.validTo.loe((Comparable)now)));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qPriSalePriceDO.getMetadata()));
        log.info("\u4ef7\u683c\u4e3b\u8868\u6743\u9650\u8fc7\u6ee4sql" + (Predicate)predicate);
        return predicate;
    }

    public PriSalePriceServiceImpl(CrmCustService crmCustService, RmiPriMainPriceService rmiPriMainPriceService, RmiOrgOuService rmiOrgOuService, RmiCommonService rmiComService, RmiPurPriceService rmiPurPriceService, RmiSysUserService rmiSysUserService) {
        this.crmCustService = crmCustService;
        this.rmiPriMainPriceService = rmiPriMainPriceService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiComService = rmiComService;
        this.rmiPurPriceService = rmiPurPriceService;
        this.rmiSysUserService = rmiSysUserService;
    }
}

