/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerDtlService;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAddrFindParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerDtlSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.convert.StatisticsDealerConvert;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerDtlRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepoSqlProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiEmployeeRpcService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StatisticsDealerServiceImpl
implements StatisticsDealerService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsDealerServiceImpl.class);
    @Autowired
    private SaleStatisticsDealerRepo statisticsDealerRepo;
    @Autowired
    private SaleStatisticsDealerRepoProc statisticsDealerRepoProc;
    @Autowired
    private SaleStatisticsDealerRepoSqlProc saleStatisticsDealerRepoSqlProc;
    @Autowired
    private SaleStatisticsDealerDtlRepo statisticsDealerDtlRepo;
    @Autowired
    private StatisticsDealerDtlService statisticsDealerDtlService;
    @Autowired
    private CrmCustService crmCustService;
    @Autowired
    private RmiEmployeeRpcService rmiEmployeeRpcService;
    @Autowired
    private SalesmanInfoService salesmanInfoService;

    public List<SaleStatisticsDealerRespVO> pullOrder(SaleStatisticsDealerQueryVO queryVO) {
        List<SaleStatisticsDealerSaveVO> dealerSaveVOList;
        if (Objects.isNull(queryVO.getDocTime())) {
            queryVO.setDocTime(LocalDateTime.now());
        }
        if (CollectionUtils.isEmpty(dealerSaveVOList = this.selectOrder(queryVO))) {
            log.info("\u7ecf\u9500\u5546\u9500\u552e\u4e1a\u7ee9\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6570\u636e,\u65f6\u95f4\uff1a{},\u4fe1\u606f\uff1a{}", (Object)queryVO);
            this.refreshHistory(queryVO);
            return Collections.EMPTY_LIST;
        }
        this.assembleStatisticsDealerSaveVO(dealerSaveVOList, false);
        this.deleteOldData(queryVO);
        List<SaleStatisticsDealerRespVO> dealerRespVOList = this.createBatch(dealerSaveVOList);
        this.refreshHistory(queryVO);
        return dealerRespVOList;
    }

    private void refreshHistory(SaleStatisticsDealerQueryVO queryVO) {
        int hour;
        if (queryVO.getDocTime() != null && ((hour = LocalDateTime.now().getHour()) == 3 || queryVO.getRefreshHistory() != null && queryVO.getRefreshHistory().booleanValue())) {
            LocalDateTime time = queryVO.getDocTime();
            for (int i = 0; i < 10; ++i) {
                LocalDateTime localDateTime = time.plusDays(-(i + 1));
                queryVO.setDocTime(localDateTime);
                List<SaleStatisticsDealerSaveVO> current = this.selectOrder(queryVO);
                this.assembleStatisticsDealerSaveVO(current, i == 0);
                this.deleteOldData(queryVO);
                this.createBatch(current);
            }
        }
    }

    public PagingVO<SaleStatisticsDealerRespVO> leaderPage(SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> pagingVO;
        this.assembleDocTime(pageParam);
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            List<Long> masIdList;
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            if (Objects.isNull(pageParam.getSeeSelf())) {
                pageParam.setSeeSelf(Boolean.valueOf(true));
            }
            if (pageParam.getSeeSelf().booleanValue()) {
                dealerDtlQueryVO.setLevel("0");
            }
            if (CollectionUtils.isEmpty(masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO))) {
                return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVO = this.statisticsDealerRepoProc.appPage(pageParam)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.translateDealer(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    public StatisticsDealerSumRespVO leaderPageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO dealerSumRespVO;
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();
        this.assembleDocTime(pageParam);
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            List<Long> masIdList;
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            if (Objects.isNull(pageParam.getSeeSelf())) {
                pageParam.setSeeSelf(Boolean.valueOf(true));
            }
            if (pageParam.getSeeSelf().booleanValue()) {
                dealerDtlQueryVO.setLevel("0");
            }
            if (CollectionUtils.isEmpty(masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO))) {
                return sumRespVO;
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (Objects.isNull(dealerSumRespVO = this.saleStatisticsDealerRepoSqlProc.pageSum(pageParam))) {
            return sumRespVO;
        }
        return dealerSumRespVO;
    }

    private void assembleStatisticsDealerSaveVO(List<SaleStatisticsDealerSaveVO> dealerSaveVOList, boolean refreshSaleManPath) {
        List dealerCodeList = dealerSaveVOList.stream().map(SaleStatisticsDealerSaveVO::getDealerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List dealerList = this.crmCustService.getCustInfoByCustCodes(dealerCodeList);
        if (refreshSaleManPath) {
            List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOS = this.selectSalesmanLevelByIds(dealerList);
            Map<Long, List> saleManMap = salesmanLevelInfoDTOS.stream().filter(i -> i.getSalesman_path() != null).collect(Collectors.toMap(i -> i.getSalesmanId(), i -> i.getSalesman_path(), (o, n) -> n));
            HashMap<String, List> custSalePathMap = new HashMap<String, List>();
            for (Long agentId : saleManMap.keySet()) {
                String custCode = dealerList.stream().filter(i -> Objects.equals(i.getAgentEmpId(), agentId)).map(i -> i.getCustCode()).findFirst().orElseGet(() -> null);
                if (!StringUtils.isNotBlank((CharSequence)custCode)) continue;
                custSalePathMap.put(custCode, saleManMap.get(agentId));
            }
            for (SaleStatisticsDealerSaveVO saleStatisticsDealerSaveVO : dealerSaveVOList) {
                List paths = saleManMap.get(saleStatisticsDealerSaveVO.getDealerCode());
                if (CollectionUtils.isEmpty((Collection)paths)) continue;
                saleStatisticsDealerSaveVO.setSalesmanPath(JSON.toJSONString((Object)paths));
            }
        }
        dealerSaveVOList.forEach(saveVO -> {
            Optional<LmSaveCustRespVO> dealerOptional = dealerList.stream().filter(dealerVO -> Objects.equals(dealerVO.getCustCode(), saveVO.getDealerCode())).findFirst();
            dealerOptional.ifPresent(dealerVO -> {
                saveVO.setCustType(dealerVO.getCustType());
                saveVO.setRegion(dealerVO.getRegion());
            });
            if (Objects.isNull(saveVO.getShipQty())) {
                saveVO.setShipQty(BigDecimal.ZERO);
            }
            if (Objects.isNull(saveVO.getOrderQty())) {
                saveVO.setOrderQty(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)saveVO.getSalesmanPath())) {
                saveVO.setSalesmanPath(null);
            }
            if (StringUtils.isBlank((CharSequence)saveVO.getRegion())) {
                saveVO.setRegion(null);
            }
        });
    }

    public List<SaleStatisticsDealerSaveVO> selectOrder(SaleStatisticsDealerQueryVO queryVO) {
        return Collections.EMPTY_LIST;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOldData(SaleStatisticsDealerQueryVO queryVO) {
        if (Objects.nonNull(queryVO.getDocTime())) {
            LocalDateTime docTimeStart = LocalDateTime.of(queryVO.getDocTime().toLocalDate(), LocalTime.MIN);
            LocalDateTime docTimeEnd = LocalDateTime.of(queryVO.getDocTime().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX);
            this.statisticsDealerDtlRepo.deleteByDocTime(docTimeStart, docTimeEnd);
            this.statisticsDealerRepo.deleteByDocTime(docTimeStart, docTimeEnd);
        } else if (Objects.nonNull(queryVO.getDocTimeStart()) && Objects.nonNull(queryVO.getDocTimeEnd())) {
            this.statisticsDealerDtlRepo.deleteByDocTime(queryVO.getDocTimeStart(), queryVO.getDocTimeEnd());
            this.statisticsDealerRepo.deleteByDocTime(queryVO.getDocTimeStart(), queryVO.getDocTimeEnd());
        }
    }

    public List<SaleStatisticsDealerRespVO> createBatch(List<SaleStatisticsDealerSaveVO> saveVOList) {
        if (CollectionUtils.isEmpty(saveVOList)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SaleStatisticsDealerSaveVO> errorSaveVOList = new ArrayList<SaleStatisticsDealerSaveVO>();
        ArrayList<SaleStatisticsDealerSaveVO> successSaveVOList = new ArrayList<SaleStatisticsDealerSaveVO>();
        for (SaleStatisticsDealerSaveVO saveVO : saveVOList) {
            if (this.checkMandatoryField(saveVO)) {
                errorSaveVOList.add(saveVO);
                continue;
            }
            successSaveVOList.add(saveVO);
        }
        List<SaleStatisticsDealerRespVO> respVOList = this.saveBatch(successSaveVOList);
        if (!CollectionUtils.isEmpty(errorSaveVOList)) {
            log.info("\u7ecf\u9500\u5546\u9500\u552e\u4e1a\u7ee9\u6821\u9a8c\u5931\u8d25\u6570\u636e,\u65f6\u95f4\uff1a{},\u4fe1\u606f\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(errorSaveVOList));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ecf\u9500\u5546\u9500\u552e\u4e1a\u7ee9\u6821\u9a8c\u5931\u8d25:" + JSON.toJSONString(errorSaveVOList));
        }
        return respVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<SaleStatisticsDealerRespVO> saveBatch(List<SaleStatisticsDealerSaveVO> saveVOList) {
        if (CollectionUtils.isEmpty(saveVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<SaleStatisticsDealerDO> statisticsDealerDOList = saveVOList.stream().map(saveVO -> {
            saveVO.setType("CUST");
            return StatisticsDealerConvert.INSTANCE.saveVoToDo((SaleStatisticsDealerSaveVO)saveVO);
        }).collect(Collectors.toList());
        this.statisticsDealerRepo.saveAll(statisticsDealerDOList);
        ArrayList dealerDtlSaveVOList = new ArrayList();
        statisticsDealerDOList.forEach(saveVO -> {
            List dtlSaveVOList;
            if (StringUtils.isNotBlank((CharSequence)saveVO.getSalesmanPath()) && !CollectionUtils.isEmpty((Collection)(dtlSaveVOList = JSONObject.parseArray((String)saveVO.getSalesmanPath(), SaleStatisticsDealerDtlSaveVO.class)))) {
                dtlSaveVOList.forEach(dtlSaveVO -> dtlSaveVO.setMasId(saveVO.getId()));
                dealerDtlSaveVOList.addAll(dtlSaveVOList);
            }
        });
        if (!CollectionUtils.isEmpty(dealerDtlSaveVOList)) {
            Set<String> employeeCodes = dealerDtlSaveVOList.stream().map(SaleStatisticsDealerDtlSaveVO::getCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List<SysEmployeeBasicDTO> basicDTOList = this.rmiEmployeeRpcService.findEmployeeByCodes(employeeCodes);
            dealerDtlSaveVOList.forEach(saveVO -> {
                Optional<SysEmployeeBasicDTO> optional = basicDTOList.stream().filter(employeeBasicDTO -> Objects.equals(saveVO.getCode(), employeeBasicDTO.getCode())).findFirst();
                optional.ifPresent(employeeBasicDTO -> saveVO.setUserId(employeeBasicDTO.getUserId()));
            });
            this.statisticsDealerDtlService.saveStatisticsDealerDtl(dealerDtlSaveVOList);
        }
        return Collections.EMPTY_LIST;
    }

    private boolean checkMandatoryField(SaleStatisticsDealerSaveVO saveVO) {
        if (Objects.isNull(saveVO.getDocTime())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getDealerCode())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getDealerName())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getDealerSerialNo())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getVehicleType())) {
            return true;
        }
        if (Objects.isNull(saveVO.getShipQty())) {
            return true;
        }
        if (Objects.isNull(saveVO.getOrderQty())) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)saveVO.getItemType3());
    }

    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> pagingVO;
        this.assembleDocTime(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            List<Long> masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO);
            if (CollectionUtils.isEmpty(masIdList)) {
                return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVO = this.statisticsDealerRepoProc.page(pageParam)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.translateDealer(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> pagingVO;
        this.assembleDocTime(pageParam);
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (!this.checkOneselfAndSub(pageParam.getAgentEmp())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            List<Long> masIdList;
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            if (Objects.isNull(pageParam.getSeeSelf())) {
                pageParam.setSeeSelf(Boolean.valueOf(true));
            }
            if (pageParam.getSeeSelf().booleanValue()) {
                dealerDtlQueryVO.setLevel("0");
            }
            if (CollectionUtils.isEmpty(masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO))) {
                return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVO = this.statisticsDealerRepoProc.appPage(pageParam)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.translateDealer(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    private boolean checkOneselfAndSub(String agentEmp) {
        SysUserDTO sysUserDTO = this.getSysUser();
        SysEmployeeBasicDTO employeeBasicDTO = this.getEmployeeByUser(sysUserDTO);
        List<String> subEmployeeCodeList = this.queryAllSubEmployeeByCode(employeeBasicDTO.getCode());
        if (CollectionUtils.isEmpty(subEmployeeCodeList)) {
            return false;
        }
        return subEmployeeCodeList.contains(agentEmp);
    }

    public List<String> statisticDealerCode(SaleStatisticsDealerQueryVO pageParam) {
        List<SaleStatisticsDealerRespVO> dealerRespVOList;
        this.assembleDocTime(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            List<Long> masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO);
            if (CollectionUtils.isEmpty(masIdList)) {
                return Collections.EMPTY_LIST;
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (CollectionUtils.isEmpty(dealerRespVOList = this.statisticsDealerRepoProc.dealerQuery(pageParam))) {
            return Collections.EMPTY_LIST;
        }
        List<String> dealerCodes = dealerRespVOList.stream().map(SaleStatisticsDealerRespVO::getDealerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dealerCodes)) {
            return Collections.EMPTY_LIST;
        }
        return dealerCodes;
    }

    public StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO dealerSumRespVO;
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();
        this.assembleDocTime(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            List<Long> masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO);
            if (CollectionUtils.isEmpty(masIdList)) {
                return sumRespVO;
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (Objects.isNull(dealerSumRespVO = this.saleStatisticsDealerRepoSqlProc.pageSum(pageParam))) {
            return sumRespVO;
        }
        return dealerSumRespVO;
    }

    public StatisticsDealerSumRespVO appPageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO dealerSumRespVO;
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();
        this.assembleDocTime(pageParam);
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (!this.checkOneselfAndSub(pageParam.getAgentEmp())) {
            return sumRespVO;
        }
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            List<Long> masIdList;
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            if (Objects.isNull(pageParam.getSeeSelf())) {
                pageParam.setSeeSelf(Boolean.valueOf(true));
            }
            if (pageParam.getSeeSelf().booleanValue()) {
                dealerDtlQueryVO.setLevel("0");
            }
            if (CollectionUtils.isEmpty(masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO))) {
                return sumRespVO;
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (Objects.isNull(dealerSumRespVO = this.saleStatisticsDealerRepoSqlProc.pageSum(pageParam))) {
            return sumRespVO;
        }
        return dealerSumRespVO;
    }

    private List<Long> selectMasIdByDtlParam(SaleStatisticsDealerDtlQueryVO dtlQueryVO) {
        List dtlRespVOList = this.statisticsDealerDtlService.selectPidByQueryVO(dtlQueryVO);
        if (CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> masIdList = dtlRespVOList.stream().map(SaleStatisticsDealerDtlRespVO::getPid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(masIdList)) {
            return Collections.EMPTY_LIST;
        }
        return masIdList;
    }

    private void translateDealer(List<SaleStatisticsDealerRespVO> respVOList) {
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsDealerDtlRespVO> dtlRespVOList = this.selectDtlByMasId(idList);
        respVOList.forEach(respVO -> {
            List dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);
            respVO.setDocDay(respVO.getDocTime().toLocalDate().toString());
            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals("0", dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals("1", dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals("2", dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals("3", dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals("4", dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals("5", dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });
        });
    }

    private List<SaleStatisticsDealerDtlRespVO> selectDtlByMasId(List<Long> masIds) {
        if (CollectionUtils.isEmpty(masIds)) {
            return Collections.EMPTY_LIST;
        }
        SaleStatisticsDealerDtlQueryVO dtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
        dtlQueryVO.setMasIds(masIds);
        List dtlRespVOList = this.statisticsDealerDtlService.selectByParam(dtlQueryVO);
        if (CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlRespVOList;
    }

    public void assembleDocTime(SaleStatisticsDealerQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }

    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> appDetails(SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> pagingVO;
        this.appDetailsCheck(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getAgentEmp())) {
            List<Long> masIdList;
            SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
            if (Objects.isNull(pageParam.getSeeSelf())) {
                pageParam.setSeeSelf(Boolean.valueOf(true));
            }
            if (pageParam.getSeeSelf().booleanValue()) {
                dealerDtlQueryVO.setLevel("0");
            }
            if (CollectionUtils.isEmpty(masIdList = this.selectMasIdByDtlParam(dealerDtlQueryVO))) {
                return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
            List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setIds(idList);
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getRegion())) {
            pageParam.setRegionFlag(Integer.valueOf(1));
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            pageParam.setSalesmanPathFlag(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVO = this.statisticsDealerRepoProc.appDetailsPage(pageParam)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return pagingVO;
    }

    private void appDetailsCheck(SaleStatisticsDealerQueryVO pageParam) {
        if (StringUtils.isBlank((CharSequence)pageParam.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
    }

    public List<StatisticsDealerAppSumRespVO> appSumByEmpCode(SaleStatisticsDealerQueryVO pageParam) {
        List empCodes = pageParam.getAgentEmpList();
        String docMonth = pageParam.getDocMonth();
        if (CollectionUtils.isEmpty((Collection)empCodes)) {
            return Collections.EMPTY_LIST;
        }
        if (pageParam.getDocTimeStart() != null) {
            pageParam.setDocTimeStart(LocalDateTime.of(pageParam.getDocTimeStart().toLocalDate(), LocalTime.MIN));
        }
        if (pageParam.getDocTimeEnd() != null) {
            pageParam.setDocTimeEnd(LocalDateTime.of(pageParam.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX));
        }
        if (pageParam.getDocTimeStart() == null && pageParam.getDocTimeEnd() == null && StringUtils.isBlank((CharSequence)docMonth)) {
            pageParam.setDocTimeStart(LocalDateTime.of(LocalDate.now(), LocalTime.MIN));
            pageParam.setDocTimeEnd(LocalDateTime.of(LocalDate.now(), ConstantsSale.LOCAL_TIME_MAX));
        }
        SaleStatisticsDealerQueryVO myQueryVO = new SaleStatisticsDealerQueryVO();
        myQueryVO.setDocMonth(docMonth);
        myQueryVO.setDocTimeStart(pageParam.getDocTimeStart());
        myQueryVO.setDocTimeEnd(pageParam.getDocTimeEnd());
        myQueryVO.setAgentEmpList(empCodes);
        myQueryVO.setLevel("0");
        List<StatisticsDealerAppSumRespVO> myRespVOList = this.selectAppSumByEmpCode(myQueryVO);
        SaleStatisticsDealerQueryVO teamQueryVO = new SaleStatisticsDealerQueryVO();
        teamQueryVO.setDocMonth(docMonth);
        teamQueryVO.setDocTimeStart(pageParam.getDocTimeStart());
        teamQueryVO.setDocTimeEnd(pageParam.getDocTimeEnd());
        teamQueryVO.setAgentEmpList(empCodes);
        List<StatisticsDealerAppSumRespVO> teamRespVOList = this.selectAppSumByEmpCode(teamQueryVO);
        ArrayList<StatisticsDealerAppSumRespVO> respVOList = new ArrayList<StatisticsDealerAppSumRespVO>();
        for (String code : empCodes) {
            Optional<StatisticsDealerAppSumRespVO> teamOptional;
            StatisticsDealerAppSumRespVO appSumRespVO = new StatisticsDealerAppSumRespVO();
            appSumRespVO.setAgentEmpCode(code);
            appSumRespVO.setMyShipTotalQty(BigDecimal.ZERO);
            appSumRespVO.setMyOrderTotalQty(BigDecimal.ZERO);
            appSumRespVO.setTeamShipTotalQty(BigDecimal.ZERO);
            appSumRespVO.setTeamOrderTotalQty(BigDecimal.ZERO);
            appSumRespVO.setDealerTotalQty(Long.valueOf(0L));
            Optional<StatisticsDealerAppSumRespVO> myOptional = myRespVOList.stream().filter(respVO -> Objects.equals(respVO.getAgentEmpCode(), code)).findFirst();
            if (myOptional.isPresent()) {
                appSumRespVO.setMyShipTotalQty(myOptional.get().getShipTotalQty());
                appSumRespVO.setMyOrderTotalQty(myOptional.get().getOrderTotalQty());
                appSumRespVO.setDealerTotalQty(myOptional.get().getDealerTotalQty());
            }
            if ((teamOptional = teamRespVOList.stream().filter(respVO -> Objects.equals(respVO.getAgentEmpCode(), code)).findFirst()).isPresent()) {
                appSumRespVO.setTeamShipTotalQty(teamOptional.get().getShipTotalQty());
                appSumRespVO.setTeamOrderTotalQty(teamOptional.get().getOrderTotalQty());
                appSumRespVO.setDealerTotalQty(teamOptional.get().getDealerTotalQty());
            }
            respVOList.add(appSumRespVO);
        }
        return respVOList;
    }

    private List<StatisticsDealerAppSumRespVO> selectAppSumByEmpCode(SaleStatisticsDealerQueryVO queryVO) {
        List<StatisticsDealerAppSumRespVO> respVOList = this.statisticsDealerRepoProc.appSumByEmpCode(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            return Collections.EMPTY_LIST;
        }
        return respVOList;
    }

    private List<SaleStatisticsDealerRespVO> selectByQueryVO(SaleStatisticsDealerQueryVO queryVO) {
        List<SaleStatisticsDealerRespVO> respVOList = this.statisticsDealerRepoProc.selectByQueryVO(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            return Collections.EMPTY_LIST;
        }
        return respVOList;
    }

    private List<SaleStatisticsDealerDtlRespVO> selectDtlByParam(SaleStatisticsDealerDtlQueryVO dtlQueryVO) {
        List dtlRespVOList = this.statisticsDealerDtlService.selectByParam(dtlQueryVO);
        if (CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlRespVOList;
    }

    private SysUserDTO getSysUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return sysUser;
    }

    private SysEmployeeBasicDTO getEmployeeByUser(SysUserDTO sysUserDTO) {
        if (Objects.isNull(sysUserDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
        }
        SysEmployeeBasicDTO employeeBasicDTO = this.rmiEmployeeRpcService.findEmployeeByUserId(sysUserDTO.getId());
        if (Objects.isNull(employeeBasicDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a!");
        }
        return employeeBasicDTO;
    }

    private List<String> queryAllSubEmployeeByCode(String salesmanNo) {
        HashSet<String> codeList = new HashSet<String>();
        codeList.add(salesmanNo);
        List<EmployeeUnderlingDTO> resultData = this.rmiEmployeeRpcService.getUnderlingByCode(salesmanNo, Boolean.TRUE, Boolean.TRUE);
        if (CollectionUtils.isEmpty(resultData)) {
            return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(resultData)) {
            ArrayList<EmployeeUnderlingDTO> listEmp = new ArrayList<EmployeeUnderlingDTO>();
            List<EmployeeUnderlingDTO> res = this.queryAllSubTreeToList(resultData, listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<EmployeeUnderlingDTO> queryAllSubTreeToList(List<EmployeeUnderlingDTO> source, List<EmployeeUnderlingDTO> obj) {
        source.stream().forEach(v -> {
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties((Object)v, (Object)t);
            t.setUnderlingList(new ArrayList());
            obj.add(t);
            if (CollectionUtil.isNotEmpty((Collection)v.getUnderlingList())) {
                this.queryAllSubTreeToList(v.getUnderlingList(), obj);
            }
        });
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> updateRegion(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636eID\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
        }
        SaleStatisticsDealerQueryVO queryVO = new SaleStatisticsDealerQueryVO();
        queryVO.setIds(ids);
        List<SaleStatisticsDealerRespVO> respVOList = this.selectByQueryVO(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u9009\u62e9\u6570\u636e\u4fe1\u606f!");
        }
        List<String> dealerCodes = respVOList.stream().map(SaleStatisticsDealerRespVO::getDealerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<LmSaveCustRespVO> custRespVOList = this.selectCustByCodes(dealerCodes);
        ArrayList<SaleStatisticsDealerDO> updateStatisticsDealerDOList = new ArrayList<SaleStatisticsDealerDO>();
        for (SaleStatisticsDealerRespVO dealerRespVO : respVOList) {
            SaleStatisticsDealerQueryVO dealerQueryVO = new SaleStatisticsDealerQueryVO();
            dealerQueryVO.setDealerCode(dealerRespVO.getDealerCode());
            dealerQueryVO.setRegion(null);
            dealerQueryVO.setSalesmanPath(dealerRespVO.getSalesmanPath());
            dealerQueryVO.setVehicleType(dealerRespVO.getVehicleType());
            dealerQueryVO.setDocTime(dealerRespVO.getDocTime());
            Iterable dealerDOIterable = this.statisticsDealerRepo.findAll(this.statisticsDealerRepoProc.selectRegionOrSalesmanPathWhere(dealerQueryVO));
            List<SaleStatisticsDealerDO> statisticsDealerDOList = StreamSupport.stream(dealerDOIterable.spliterator(), false).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(statisticsDealerDOList)) continue;
            this.assembleStatisticsDealerRegion(statisticsDealerDOList, custRespVOList);
            updateStatisticsDealerDOList.addAll(statisticsDealerDOList);
        }
        if (!CollectionUtils.isEmpty(updateStatisticsDealerDOList)) {
            return this.statisticsDealerRepo.saveAll(updateStatisticsDealerDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private void assembleStatisticsDealerRegion(List<SaleStatisticsDealerDO> statisticsDealerDOList, List<LmSaveCustRespVO> custRespVOList) {
        statisticsDealerDOList.forEach(saleStatisticsDealerDO -> {
            if (CollectionUtils.isEmpty((Collection)custRespVOList)) {
                saleStatisticsDealerDO.setUpdateRegionFailureReason("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e");
            } else {
                Optional<LmSaveCustRespVO> first = custRespVOList.stream().filter(cust -> Objects.equals(saleStatisticsDealerDO.getDealerCode(), cust.getCustCode())).findFirst();
                if (first.isPresent()) {
                    if (StringUtils.isBlank((CharSequence)first.get().getRegion())) {
                        saleStatisticsDealerDO.setUpdateRegionFailureReason("\u6b64\u5ba2\u6237\u7684\u533a\u57df\u4fe1\u606f\u4e3a\u7a7a");
                    } else {
                        saleStatisticsDealerDO.setRegion(first.get().getRegion());
                        saleStatisticsDealerDO.setUpdateRegionFailureReason(null);
                    }
                } else {
                    saleStatisticsDealerDO.setUpdateRegionFailureReason("\u672a\u67e5\u8be2\u5230\u6b64\u5ba2\u6237\u4e3b\u4fe1\u606f");
                }
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> updateSalesmanPath(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636eID\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
        }
        SaleStatisticsDealerQueryVO queryVO = new SaleStatisticsDealerQueryVO();
        queryVO.setIds(ids);
        List<SaleStatisticsDealerRespVO> respVOList = this.selectByQueryVO(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u9009\u62e9\u6570\u636e\u4fe1\u606f!");
        }
        List<String> dealerCodes = respVOList.stream().map(SaleStatisticsDealerRespVO::getDealerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<LmSaveCustRespVO> custRespVOList = this.selectCustByCodes(dealerCodes);
        HashMap<String, Long> custCodeAndAgentEmpIdMap = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(custRespVOList)) {
            custRespVOList.stream().forEach(t -> custCodeAndAgentEmpIdMap.put(t.getCustCode(), t.getAgentEmpId()));
        }
        List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOList = this.selectSalesmanLevelByIds(custRespVOList);
        ArrayList<SaleStatisticsDealerDO> updateStatisticsDealerDOList = new ArrayList<SaleStatisticsDealerDO>();
        for (SaleStatisticsDealerRespVO dealerRespVO : respVOList) {
            SaleStatisticsDealerQueryVO dealerQueryVO = new SaleStatisticsDealerQueryVO();
            dealerQueryVO.setDealerCode(dealerRespVO.getDealerCode());
            dealerQueryVO.setRegion(dealerRespVO.getRegion());
            dealerQueryVO.setSalesmanPath(null);
            dealerQueryVO.setVehicleType(dealerRespVO.getVehicleType());
            dealerQueryVO.setDocTime(dealerRespVO.getDocTime());
            Iterable dealerDOIterable = this.statisticsDealerRepo.findAll(this.statisticsDealerRepoProc.selectRegionOrSalesmanPathWhere(dealerQueryVO));
            List<SaleStatisticsDealerDO> statisticsDealerDOList = StreamSupport.stream(dealerDOIterable.spliterator(), false).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(statisticsDealerDOList)) continue;
            this.assembleStatisticsDealerSalesmanPath(statisticsDealerDOList, custRespVOList, custCodeAndAgentEmpIdMap, salesmanLevelInfoDTOList);
            updateStatisticsDealerDOList.addAll(statisticsDealerDOList);
        }
        if (!CollectionUtils.isEmpty(updateStatisticsDealerDOList)) {
            List<Long> statisticsDealerIds = this.statisticsDealerRepo.saveAll(updateStatisticsDealerDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
            this.assembleDtlSalesmanPath(updateStatisticsDealerDOList);
            return statisticsDealerIds;
        }
        return Collections.EMPTY_LIST;
    }

    private void assembleDtlSalesmanPath(List<SaleStatisticsDealerDO> updateStatisticsDealerDOList) {
        List<Long> idList = updateStatisticsDealerDOList.stream().map(BaseModel::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.statisticsDealerDtlRepo.deleteByMasIdIn(idList);
        ArrayList dealerDtlSaveVOList = new ArrayList();
        updateStatisticsDealerDOList.forEach(saveVO -> {
            List dtlSaveVOList;
            if (StringUtils.isNotBlank((CharSequence)saveVO.getSalesmanPath()) && !CollectionUtils.isEmpty((Collection)(dtlSaveVOList = JSONObject.parseArray((String)saveVO.getSalesmanPath(), SaleStatisticsDealerDtlSaveVO.class)))) {
                dtlSaveVOList.forEach(dtlSaveVO -> dtlSaveVO.setMasId(saveVO.getId()));
                dealerDtlSaveVOList.addAll(dtlSaveVOList);
            }
        });
        if (!CollectionUtils.isEmpty(dealerDtlSaveVOList)) {
            Set<String> employeeCodes = dealerDtlSaveVOList.stream().map(SaleStatisticsDealerDtlSaveVO::getCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List<SysEmployeeBasicDTO> basicDTOList = this.rmiEmployeeRpcService.findEmployeeByCodes(employeeCodes);
            dealerDtlSaveVOList.forEach(saveVO -> {
                Optional<SysEmployeeBasicDTO> optional = basicDTOList.stream().filter(employeeBasicDTO -> Objects.equals(saveVO.getCode(), employeeBasicDTO.getCode())).findFirst();
                optional.ifPresent(employeeBasicDTO -> saveVO.setUserId(employeeBasicDTO.getUserId()));
            });
            this.statisticsDealerDtlService.saveStatisticsDealerDtl(dealerDtlSaveVOList);
        }
    }

    private void assembleStatisticsDealerSalesmanPath(List<SaleStatisticsDealerDO> statisticsDealerDOList, List<LmSaveCustRespVO> custRespVOList, Map<String, Long> custCodeAndAgentEmpIdMap, List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOList) {
        statisticsDealerDOList.forEach(saleStatisticsDealerDO -> {
            if (CollectionUtils.isEmpty((Collection)custRespVOList)) {
                saleStatisticsDealerDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e");
            } else {
                Optional<LmSaveCustRespVO> custOptional = custRespVOList.stream().filter(custRespVO -> Objects.equals(saleStatisticsDealerDO.getDealerCode(), custRespVO.getCustCode())).findFirst();
                if (custOptional.isPresent()) {
                    if (CollectionUtils.isEmpty((Map)custCodeAndAgentEmpIdMap) || Objects.isNull(custCodeAndAgentEmpIdMap.get(custOptional.get().getCustCode()))) {
                        saleStatisticsDealerDO.setUpdateSalesmanFailureReason("\u6b64\u5ba2\u6237\u7684\u4e1a\u52a1\u5458ID\u4fe1\u606f\u4e3a\u7a7a");
                    } else if (CollectionUtils.isEmpty((Collection)salesmanLevelInfoDTOList)) {
                        saleStatisticsDealerDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u6570\u636e");
                    } else {
                        Long agentEmpId = (Long)custCodeAndAgentEmpIdMap.get(custOptional.get().getCustCode());
                        Optional<SalesmanLevelInfoDTO> salesmanOptional = salesmanLevelInfoDTOList.stream().filter(salesmanLevelInfo -> Objects.equals(agentEmpId, salesmanLevelInfo.getId())).findFirst();
                        if (salesmanOptional.isPresent()) {
                            if (CollectionUtils.isEmpty((Collection)salesmanOptional.get().getSalesman_path())) {
                                saleStatisticsDealerDO.setUpdateSalesmanFailureReason("\u6b64\u5ba2\u6237\u7684\u4e1a\u52a1\u5458\u7684\u4e1a\u52a1\u5458\u8def\u5f84\u4fe1\u606f\u4e3a\u7a7a");
                            } else {
                                saleStatisticsDealerDO.setSalesmanPath(JSON.toJSONString((Object)salesmanOptional.get().getSalesman_path()));
                                saleStatisticsDealerDO.setUpdateSalesmanFailureReason(null);
                            }
                        } else {
                            saleStatisticsDealerDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u6b64\u5ba2\u6237\u7684\u4e1a\u52a1\u5458\u4e3b\u4fe1\u606f");
                        }
                    }
                } else {
                    saleStatisticsDealerDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u6b64\u5ba2\u6237\u4e3b\u4fe1\u606f");
                }
            }
        });
    }

    private List<LmSaveCustRespVO> selectCustByCodes(List<String> custCodes) {
        if (CollectionUtils.isEmpty(custCodes)) {
            return Collections.EMPTY_LIST;
        }
        CustAddrFindParam custAddrFindParam = new CustAddrFindParam();
        custAddrFindParam.setCustCodes(custCodes);
        List custRespVOList = this.crmCustService.getCustInfoByParam(custAddrFindParam);
        if (CollectionUtils.isEmpty((Collection)custRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return custRespVOList;
    }

    private List<SalesmanLevelInfoDTO> selectSalesmanLevelByIds(List<LmSaveCustRespVO> custRespVOList) {
        if (CollectionUtils.isEmpty(custRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List agentEmpIds = custRespVOList.stream().map(LmSaveCustRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(agentEmpIds)) {
            return Collections.EMPTY_LIST;
        }
        List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOList = agentEmpIds.stream().map(t -> this.salesmanInfoService.queryLevelInfo(t)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesmanLevelInfoDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return salesmanLevelInfoDTOList;
    }
}

