/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.component;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitesland.yst.production.sale.api.vo.param.component.SalesmanParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.component.SalesmanPageRespVO;
import com.elitesland.yst.production.sale.repo.SalesmanComponentRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysOrgService;
import com.elitesland.yst.production.sale.service.component.SalesmanComponentService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SalesmanComponentServiceImpl
implements SalesmanComponentService {
    private static final Logger log = LoggerFactory.getLogger(SalesmanComponentServiceImpl.class);
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiSysOrgService rmiSysOrgService;
    private final SalesmanComponentRepoProc salesmanComponentRepoProc;

    @Override
    public PagingVO<SalesmanPageRespVO> querySalesmanList(SalesmanParamVO paramVO) {
        long count = this.salesmanComponentRepoProc.countSalesMan(paramVO);
        if (count > 0L) {
            List<SalesmanPageRespVO> salesmanPageRespVOS = this.salesmanComponentRepoProc.querySalesMan(paramVO);
            this.translateSalesman(salesmanPageRespVOS);
            return new PagingVO(count, salesmanPageRespVOS);
        }
        return new PagingVO();
    }

    private void translateSalesman(List<SalesmanPageRespVO> salesmanPageRespVOS) {
        List<String> empCodes = salesmanPageRespVOS.stream().map(SalesmanPageRespVO::getEmpCode).collect(Collectors.toList());
        List<SysEmployeeDetailDTO> sysEmpList = this.rmiSysOrgService.findEmpByCode(empCodes);
        List<String> ouCodes = salesmanPageRespVOS.stream().map(SalesmanPageRespVO::getOuCode).collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuList = this.rmiOrgOuService.findOuDtoListByOuCodes(ouCodes);
        if (CollUtil.isNotEmpty(sysEmpList)) {
            salesmanPageRespVOS.forEach(row -> {
                sysEmpList.stream().filter(emp -> row.getEmpCode().equals(emp.getCode())).findAny().ifPresent(emp -> {
                    row.setBuId(CollUtil.isNotEmpty((Collection)emp.getOrgList()) ? ((SysEmployeeDetailDTO.EmployeeOrg)emp.getOrgList().get(0)).getOrgId() : null);
                    row.setBuName(CollUtil.isNotEmpty((Collection)emp.getOrgList()) ? ((SysEmployeeDetailDTO.EmployeeOrg)emp.getOrgList().get(0)).getOrgName() : null);
                    row.setUserId(emp.getUserId());
                    row.setUserName(emp.getFullName());
                });
                orgOuList.stream().filter(ou -> row.getOuCode().equals(ou.getOuCode())).findAny().ifPresent(ou -> {
                    row.setOuId(ou.getId());
                    row.setCurrCode(ou.getOuCurr());
                    row.setAddrNo(ou.getAddrNo());
                });
            });
        }
    }

    public SalesmanComponentServiceImpl(RmiOrgOuService rmiOrgOuService, RmiSysOrgService rmiSysOrgService, SalesmanComponentRepoProc salesmanComponentRepoProc) {
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiSysOrgService = rmiSysOrgService;
        this.salesmanComponentRepoProc = salesmanComponentRepoProc;
    }
}

