/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.service.shop.BipItemService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderDService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDFindParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderDParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderDSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipOrderDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDDO;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepo;
import com.elitesland.yst.production.sale.service.LogisticsTemplateDServiceImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipOrdeDServiceimpl
extends BaseServiceImpl
implements BipOrderDService {
    private static final Logger log = LoggerFactory.getLogger(BipOrdeDServiceimpl.class);
    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderDRepoProc bipOrderDRepoProc;
    @Autowired
    private BipItemService bipItemService;
    @Autowired
    protected JPAQueryFactory jpaQueryFactory;
    private final QBipOrderDDO QbipOrderDDo = QBipOrderDDO.bipOrderDDO;
    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;
    @Autowired
    private MktGiftRepo mktGiftRepo;
    @Autowired
    private LogisticsTemplateDServiceImpl logisticsTemplateDService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private MktDiscountGiftRepoProc mktDiscountGiftRepoProc;

    public PagingVO<BipOrderDRespVO> findPageOrderD(BipOrderDParmVO bipOrderParmDVO) {
        Page page = this.bipOrderDRepo.findAll(this.where(bipOrderParmDVO), (Pageable)bipOrderParmDVO.getPageRequest());
        List resList = page.getContent().stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        return PagingVO.builder().total(page.getTotalElements()).records(resList).build();
    }

    public List<BipOrderDRespVO> findOrderD(BipOrderDParmVO bipOrderParmDVO) {
        List list = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.QbipOrderDDo).from((EntityPath)this.QbipOrderDDo)).where(this.where(bipOrderParmDVO))).fetch();
        List<BipOrderDRespVO> resList = list.stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        for (BipOrderDRespVO vo : resList) {
            vo.setUom((String)uomUdcMap.get(vo.getUom()));
        }
        return resList;
    }

    public List<BipOrderDRespVO> findOrderById(List<Long> ids) {
        List list = this.bipOrderDRepo.findAllById(ids);
        List<BipOrderDRespVO> resList = list.stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        return resList;
    }

    public List<BipOrderDRespVO> fingOrderDByorderId(Long orderId) {
        List<BipOrderDDO> list = this.bipOrderDRepo.findByOrderId(orderId);
        List<BipOrderDRespVO> resList = list.stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrder(List<BipOrderDSaveVO> bipOrderDSaveVOS) {
        List list = bipOrderDSaveVOS.stream().map(BipOrderDConvert.INSTANCE::saveToDo).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderDStatus(List<BipOrderDSaveVO> bipOrderDSaveVOS) {
        List list = bipOrderDSaveVOS.stream().map(BipOrderDConvert.INSTANCE::saveToDo).collect(Collectors.toList());
        List bipOrderDDOList = this.bipOrderDRepo.saveAll(list);
        List distinctStatusList = bipOrderDDOList.stream().map(bipOrderDDo -> bipOrderDDo.getStatus()).collect(Collectors.toList());
        List distinctIdList = bipOrderDDOList.stream().map(bipOrderDDo -> bipOrderDDo.getOrderId()).collect(Collectors.toList());
        if (distinctIdList != null && distinctStatusList.size() == 1 && distinctIdList != null && distinctIdList.size() == 1) {
            BipOrderDO bipOrderDo = new BipOrderDO();
            bipOrderDo.setId((Long)distinctIdList.get(0));
            bipOrderDo.setStatus((String)distinctStatusList.get(0));
            this.bipOrderRepo.save(bipOrderDo);
        }
    }

    public String validStatusCompatibility(List<BipOrderDDO> list) {
        String status = "";
        if (list == null || list.isEmpty()) {
            return "no";
        }
        boolean compatibility = true;
        for (int i = 0; i < list.size(); ++i) {
            if (StringUtils.isBlank((CharSequence)list.get(i).getStatus())) {
                throw new BusinessException("\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (i == 0) {
                status = list.get(i).getStatus();
                continue;
            }
            compatibility = status.equals(list.get(i).getStatus());
            if (!compatibility) break;
        }
        if (compatibility) {
            return status;
        }
        return "no";
    }

    public void deleteOrderDByIds(List<Long> ids) {
        this.bipOrderDRepo.deleteOrderDByIds(ids);
    }

    public void deleteOrderDById(Long id) {
        this.bipOrderDRepo.deleteOrderDByOrderId(id);
    }

    public void deleteOrderByOrderIds(List<Long> ids) {
        this.bipOrderDRepo.deleteOrderDByOrderIds(ids);
    }

    public void deleteOrderD(List<BipOrderDSaveVO> bipOrderDSaveVOS) {
        List list = bipOrderDSaveVOS.stream().map(BipOrderDConvert.INSTANCE::saveToDo).collect(Collectors.toList());
        list.stream().forEach(bipOrderDo -> bipOrderDo.setDeleteFlag(1));
        this.bipOrderDRepo.deleteInBatch(list);
    }

    public ApiResult<Long> countItemSaleNum(Long itemId, LocalDateTime start, LocalDateTime end) {
        if (start == null && end == null) {
            return ApiResult.ok((Object)this.bipOrderDRepoProc.countItemSaleNum(itemId));
        }
        return ApiResult.ok((Object)this.bipOrderDRepoProc.countItemSaleNum(itemId, start, end));
    }

    public List<BipInvItemDTO> queryItemByOrderId(Long orderId) {
        JPAQuery where = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipInvItemDTO.class, (Expression[])new Expression[]{this.QbipOrderDDo.itemCode, this.QbipOrderDDo.itemName, this.QbipOrderDDo.buyQty, this.QbipOrderDDo.payAmt, this.QbipOrderDDo.fareAmt, this.QbipOrderDDo.itemSpec, this.QbipOrderDDo.skuId, this.QbipOrderDDo.skuCode, this.QbipOrderDDo.buyAmt, this.QbipOrderDDo.allowBackNum, this.QbipOrderDDo.uom, this.QbipOrderDDo.itemId})).from((EntityPath)this.QbipOrderDDo)).where((Predicate)this.QbipOrderDDo.orderId.eq((Object)orderId));
        List<BipInvItemDTO> fetch = where.fetch();
        if (fetch == null) {
            fetch = Collections.emptyList();
        }
        return fetch;
    }

    public Predicate where(BipOrderDParmVO bipOrderDParmVO) {
        BooleanExpression predicate = this.QbipOrderDDo.isNotNull();
        if (Objects.nonNull(bipOrderDParmVO)) {
            if (Objects.nonNull(bipOrderDParmVO.getOrderId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.orderId.eq((Object)bipOrderDParmVO.getOrderId()));
            }
            if (Objects.nonNull(bipOrderDParmVO.getFreeFare())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.freeFare.eq(bipOrderDParmVO.getFreeFare()));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getItemBrand())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.itemBrand.like("%" + bipOrderDParmVO.getItemBrand() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getItemCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.itemCode.like("%" + bipOrderDParmVO.getItemCode() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getItemName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.itemName.like("%" + bipOrderDParmVO.getItemName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getItemTitle())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.itemTitle.eq((Object)bipOrderDParmVO.getItemTitle()));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getLogisNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.logisNo.like("%" + bipOrderDParmVO.getLogisNo() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getOrderDocNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.orderDocNo.eq((Object)bipOrderDParmVO.getOrderDocNo()));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getStatus())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.status.eq((Object)bipOrderDParmVO.getStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)bipOrderDParmVO.getCouponId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.QbipOrderDDo.couponId.like("%" + bipOrderDParmVO.getCouponId() + "%"));
            }
        }
        return predicate;
    }

    public List<BipOrderDDO> createOrder(List<BipCartItemRespVO> bipCartItemRespVOS) {
        ArrayList<BipOrderDDO> bipOrderDDOList = new ArrayList<BipOrderDDO>();
        int lineNo = 1;
        for (BipCartItemRespVO bipCartItemRespVO : bipCartItemRespVOS) {
            Long itemId = bipCartItemRespVO.getItemId();
            Long skuId = bipCartItemRespVO.getItemSkuRespVO().getId();
            if (this.bipItemSkuRepoProc.findFreezeStatus(skuId).booleanValue()) {
                throw new BusinessException("\u9500\u552e\u51bb\u7ed3\u72b6\u6001\u7684\u5546\u54c1\u4e0d\u80fd\u8d2d\u4e70");
            }
            Long qty = bipCartItemRespVO.getItemNum();
            this.bipItemService.incrementStock(skuId, Integer.valueOf(-qty.intValue()));
            if (null != bipCartItemRespVO.getGiftCodes() && !bipCartItemRespVO.getGiftCodes().isEmpty()) {
                List<Long> giftCodes = Arrays.asList(bipCartItemRespVO.getGiftCodes().split(",")).stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
                List<MktGiftDO> giftList = this.mktGiftRepo.findByIdIn(giftCodes);
                List<Long> giftIds = giftList.stream().filter(a -> a.getId() != null).map(BaseModel::getId).collect(Collectors.toList());
                this.mktGiftRepo.updateMktGiftById(giftIds);
            }
            BipOrderDDO bipOrderDDo = new BipOrderDDO();
            bipOrderDDo.setLineNo(lineNo);
            ++lineNo;
            bipOrderDDo.setBuyQty(qty);
            this.bulidOrderDitemInfo(bipCartItemRespVO, bipOrderDDo);
            log.info("\u4e0b\u5355\u65f6\uff0c\u8ba2\u5355\u4fe1\u606f\u6570\u636e\u6e90\uff1a" + JSON.toJSONString((Object)bipCartItemRespVO));
            log.info("\u4e0b\u5355\u65f6\uff0c\u521b\u5efa\u7684\u8ba2\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)bipOrderDDo));
            this.buildOrderDiscountOffsetInfo(bipCartItemRespVO, bipOrderDDo);
            this.buildOrderDCouponInfo(bipCartItemRespVO, bipOrderDDo);
            if (null != bipOrderDDo.getFareAmt() && bipOrderDDo.getFareAmt().compareTo(BigDecimal.ZERO) < 0) {
                bipOrderDDo.setFareAmt(BigDecimal.ZERO);
            }
            if (null != bipOrderDDo.getPayAmt() && bipOrderDDo.getPayAmt().compareTo(BigDecimal.ZERO) < 0) {
                bipOrderDDo.setPayAmt(BigDecimal.ZERO);
            }
            bipOrderDDo = (BipOrderDDO)this.bipOrderDRepo.save(bipOrderDDo);
            bipOrderDDOList.add(bipOrderDDo);
        }
        return bipOrderDDOList;
    }

    public void bulidOrderDitemInfo(BipCartItemRespVO bipCartItemRespVO, BipOrderDDO bipOrderDDo) {
        bipOrderDDo.setItemId(bipCartItemRespVO.getItemId());
        bipOrderDDo.setItemCode(bipCartItemRespVO.getItemCode());
        bipOrderDDo.setItemName(bipCartItemRespVO.getItemName());
        bipOrderDDo.setItemBrand(bipCartItemRespVO.getItemSkuRespVO().getBrand());
        bipOrderDDo.setItemBrand(bipCartItemRespVO.getItemSkuRespVO().getBarcode());
        bipOrderDDo.setUom(bipCartItemRespVO.getUom());
        bipOrderDDo.setItemSpec(bipCartItemRespVO.getItemSkuRespVO().getSpec());
        bipOrderDDo.setItemTitle(bipCartItemRespVO.getTitle());
        bipOrderDDo.setRelateItemId(bipCartItemRespVO.getRelateItemId());
        bipOrderDDo.setItemPicFileCode(bipCartItemRespVO.getMainPicFileCode());
        bipOrderDDo.setBasePrice(bipCartItemRespVO.getItemSkuRespVO().getPrice());
        bipOrderDDo.setCustPrice(bipCartItemRespVO.getCustPrice());
        bipOrderDDo.setFreeFare(bipCartItemRespVO.getFareFree());
        bipOrderDDo.setFareTmplId(bipCartItemRespVO.getFareTmplId());
        bipOrderDDo.setItemPicFileCode(bipCartItemRespVO.getMainPicFileCode());
        bipOrderDDo.setSkuId(bipCartItemRespVO.getSkuId());
        bipOrderDDo.setSkuCode(bipCartItemRespVO.getSkuCode());
        bipOrderDDo.setItemType(UdcEnum.ITM_ITM_TYPE_10.getValueCode());
        bipOrderDDo.setMateriel(bipCartItemRespVO.getMateriel());
        bipOrderDDo.setType(bipCartItemRespVO.getType());
        bipOrderDDo.setFreeFare(bipCartItemRespVO.getFareFree());
        bipOrderDDo.setFareAmt(bipCartItemRespVO.getFareArm());
        bipOrderDDo.setGiftCodes(bipCartItemRespVO.getGiftCodes());
        BigDecimal price = bipCartItemRespVO.getCustPrice() == null ? bipCartItemRespVO.getItemSkuRespVO().getPrice() : bipCartItemRespVO.getCustPrice();
        bipOrderDDo.setItemAmt(price.multiply(BigDecimal.valueOf(bipOrderDDo.getBuyQty())));
    }

    public void bulidOrderDGiftInfo(MktGiftRespVO mktGiftRespVO, BipOrderDDO bipOrderDDo) {
        Long itemId = mktGiftRespVO.getItemId();
        String skuCode = mktGiftRespVO.getSkuCode();
        MktGiftDO mktGiftDO = this.mktGiftRepo.findMktGiftDOByIdAndSkuCode(itemId, skuCode);
        Long qty = 1L;
        if (mktGiftDO.getStockNum() <= qty) {
            throw new BusinessException("\u8d60\u54c1\u5e93\u5b58\u4e0d\u8db3!");
        }
        this.mktGiftRepo.updateMktGiftStoucNum(qty, itemId, skuCode);
        bipOrderDDo.setItemId(mktGiftRespVO.getDiscountGiftItemId());
        bipOrderDDo.setRelateItemId(mktGiftRespVO.getItemId());
        bipOrderDDo.setItemCode(mktGiftRespVO.getItemCode());
        bipOrderDDo.setSkuCode(mktGiftRespVO.getSkuCode());
        bipOrderDDo.setItemName(mktGiftRespVO.getItemName());
        bipOrderDDo.setItemType(UdcEnum.ITM_ITM_TYPE_30.getValueCode());
        bipOrderDDo.setBuyQty(1L);
    }

    public void buildOrderDiscountOffsetInfo(BipCartItemRespVO bipCartItemRespVO, BipOrderDDO bipOrderDDo) {
        if (Objects.nonNull(bipCartItemRespVO.getMktDiscountOffsetId()) && Objects.nonNull(bipCartItemRespVO.getMktDiscountOffsetDId())) {
            bipOrderDDo.setDiscountOffsetCode(bipCartItemRespVO.getMktDiscountOffsetCode());
            bipOrderDDo.setDiscountOffsetDId(bipCartItemRespVO.getMktDiscountOffsetDId());
            bipOrderDDo.setDiscountOffsetId(bipCartItemRespVO.getMktDiscountOffsetId());
            bipOrderDDo.setDiscountAmt(bipCartItemRespVO.getMktDiscountOffsetFreeAmt());
        }
    }

    public void buildOrderDCouponInfo(BipCartItemRespVO bipCartItemRespVO, BipOrderDDO bipOrderDDo) {
    }

    public void buildOrderDFareInfo(BipCartItemRespVO bipCartItemRespVO, BipOrderDDO bipOrderDDo) {
        LogisticsTemplateDFindParam logisticsTemplateDFindParam = new LogisticsTemplateDFindParam();
        if (bipCartItemRespVO.getFareTmplId() == null) {
            throw new BusinessException("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        logisticsTemplateDFindParam.setArea(bipCartItemRespVO.getBipAddressVO().getArea());
        logisticsTemplateDFindParam.setTemplateId(bipOrderDDo.getFareTmplId());
        ArrayList<LogisticsTemplateDFindParam> params = new ArrayList<LogisticsTemplateDFindParam>();
        params.add(logisticsTemplateDFindParam);
        bipOrderDDo.setFreeFare(true);
        if (bipOrderDDo.getFreeFare() != null && !bipOrderDDo.getFreeFare().booleanValue()) {
            List<LogisticsTemplateDVO> result = this.logisticsTemplateDService.getByArea(logisticsTemplateDFindParam);
            if (result != null && !result.isEmpty()) {
                LogisticsTemplateDVO logisticsTemplateDVO = result.get(0);
                BigDecimal incAmt = logisticsTemplateDVO.getAddFreight();
                BigDecimal baseAmt = logisticsTemplateDVO.getDefFreight();
                Integer baseNum = logisticsTemplateDVO.getPieceNumber();
                Integer incNum = logisticsTemplateDVO.getContinuypieceNumber();
                Long itemNum = bipOrderDDo.getBuyQty();
                Long num = itemNum - (long)baseNum.intValue();
                BigDecimal inc = BigDecimal.valueOf(num).divide(BigDecimal.valueOf(incNum.intValue()), 0, RoundingMode.UP);
                BigDecimal fareAmt = baseAmt.add(incAmt.multiply(inc));
                bipOrderDDo.setFareAmt(fareAmt);
            }
        } else {
            bipOrderDDo.setFareAmt(BigDecimal.ZERO);
        }
    }
}

