/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.MktGiftService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QMktGiftDO;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepoProc;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

@Service
public class MktGiftServiceImpl
extends BaseServiceImpl
implements MktGiftService {
    private static final Logger log = LoggerFactory.getLogger(MktGiftServiceImpl.class);
    private final MktGiftRepoProc mktGiftRepoProc;

    public PagingVO<MktGiftRespVO> search(MktGiftQueryVO queryParam) {
        QMktGiftDO qmktGiftDO = QMktGiftDO.mktGiftDO;
        JPAQuery<MktGiftRespVO> jpaQuery = this.mktGiftRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(queryParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qmktGiftDO);
        List pageResult = jpaQuery.fetch();
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    public Optional<List<MktGiftRespVO>> findByDiscountGiftCode(String code) {
        QMktGiftDO qmktGiftDO = QMktGiftDO.mktGiftDO;
        List source = ((JPAQuery)this.mktGiftRepoProc.select(null).where((Predicate)qmktGiftDO.itemCode.eq((Object)code))).fetch();
        if (CollUtil.isEmpty((Collection)source)) {
            return Optional.empty();
        }
        return Optional.of(source);
    }

    public Optional<MktGiftRespVO> findIdOne(Long id) {
        QMktGiftDO qmktGiftDO = QMktGiftDO.mktGiftDO;
        MktGiftRespVO mktGiftRespVO = (MktGiftRespVO)((JPAQuery)this.mktGiftRepoProc.select(null).where((Predicate)qmktGiftDO.id.eq((Object)id))).fetchOne();
        if (mktGiftRespVO == null) {
            return Optional.empty();
        }
        return Optional.of(mktGiftRespVO);
    }

    public MktGiftServiceImpl(MktGiftRepoProc mktGiftRepoProc) {
        this.mktGiftRepoProc = mktGiftRepoProc;
    }
}

