package com.elitesland.yst.production.sale.controller.crm;


import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CustAccountService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.save.CheckKapchaParam;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountEnableVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import com.elitesland.yst.production.sale.config.cas.CasUserClientHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/cust/account", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "客户账户")
@Slf4j
public class CustAccountController {

    @Autowired
    private CustAccountService custAccountService;

    @Autowired
    private CasUserClientHelper casUserClientHelper;



    @PutMapping(value = "/create/{custCodes}")
    @ApiOperation(value = "创建账号")
    public ApiResult<List<Long>> createCustAccount(@PathVariable List<String> custCodes){
        List<Long> res = new ArrayList<>();
        var authUsers = custAccountService.createUser(custCodes);
        authUsers.forEach(user ->{
            Long userId = casUserClientHelper.onUpsert(user);
            res.add(userId);
        });
        return ApiResult.ok(res);
    }

    @PutMapping(value = "/updatePwd")
    @ApiOperation(value = "修改密码")
    public ApiResult<Long> updatePwd(@RequestBody CustAccountUpdateVO custAccountUpdate){
        ApiResult<SysUserDTO> sysUser = custAccountService.updatePwd(custAccountUpdate);
        Long userId = null;
        try {
            if(sysUser.isSuccess()){
                userId = casUserClientHelper.onUpdatePassword(sysUser.getData().getId(),custAccountUpdate.getNewPwd());
            }else {
                return ApiResult.fail(sysUser.getCode(),sysUser.getMsg());
            }
        }catch (Exception e){
            log.error("修改密码 error:",e);
            throw new BusinessException("调用修改密码服务异常"+e,e);
        }
        custAccountService.updateAccountPwd(sysUser.getData().getId(),custAccountUpdate);
        return ApiResult.ok(userId);
    }

    @PostMapping("/checkKaptcha")
    @ApiOperation(value = "验证码验证")
    public ApiResult<String> checkKaptcha(@RequestBody CheckKapchaParam param){
        return custAccountService.checkKaptcha(param);
    }

    @PostMapping(value = "/onEnabled")
    @ApiOperation(value = "修改用户状态 启用/禁用")
    public ApiResult<List<Long>> onEnabled(@RequestBody CustAccountEnableVO custAccountEnableVO){
        List<CustAccountVO> list = custAccountService.getByCustCodes(custAccountEnableVO);
        List<Long> accountIds = new ArrayList<>();
        list.forEach(l ->{
            casUserClientHelper.onEnabled(l.getUserId(),custAccountEnableVO.getEnable());
            accountIds.add(l.getId());
        });
        List<Long> accountId = custAccountService.updateAccountEnable(accountIds,custAccountEnableVO.getEnable());
        return ApiResult.ok(accountId);
    }

    @GetMapping("/onDelete/{custCodes}")
    public ApiResult<Object> onDelete(@PathVariable List<String> custCodes){
        if(CollectionUtil.isEmpty(custCodes)){
            throw new BusinessException("参数为空");
        }
        List<CustAccountVO> list = custAccountService.getByCustCodes(custCodes);
        if(!CollectionUtil.isEmpty(list)){
            list.stream().filter(l -> l.getIsOpenAccount().equals(true) && null != l.getUserId()).collect(Collectors.toList());
            list.forEach(l ->{
                if(l.getIsOpenAccount().equals(true) && null != l.getUserId()){
                    casUserClientHelper.onDelete(l.getUserId());
                }
            });
        }
        List<Long> ids = list.stream().map(CustAccountVO :: getId).collect(Collectors.toList());
        custAccountService.deleteAccount(ids);
        return ApiResult.ok();
    }




//    public Long onDelete(long id) {
//        if (!sdkProperties.getCasClient().getEnabled()) {
//            // 已禁用
//            log.warn("统一身份认证客户端已禁用");
//            return null;
//        }
//
//        return execute(() -> {
//            // 删除
//            userTransferHelper.delete(id);
//            return id;
//        });
//    }

}
