package com.elitesland.yst.production.sale.controller.crm.checkdata;

import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustCheckParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.sale.controller.crm.checkdata
 * @date 2021/12/13 14:37
 */
@RestController
@RequestMapping(value = "/crm/check")
@Api(tags = "客户信息检查数据")
@Slf4j
public class CrmCheckController extends BaseController {


    @Autowired
    private CrmCustService custService;


    @ApiOperation(value = "查询客户信息,客户为大B但是没有ERP客户编码的")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/query")
    public ApiResult<PagingVO<CrmCustSimpleVO>> query(@RequestBody CrmCustCheckParamVO searchParam) {
        PagingVO<CrmCustSimpleVO> crmCustSimpleVOPagingVO = custService.checkQuery(searchParam);
        return ApiResult.ok(crmCustSimpleVOPagingVO);
    }


}
