package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.MktDiscountGiftService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import netscape.javascript.JSObject;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 功能说明：
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Slf4j
@RestController
@RequestMapping("/mkt/discountGift")
@Api(value = "满减赠折扣", tags = {"满减赠折扣"})
@RequiredArgsConstructor
public class MktDiscountGiftController {

    private final MktDiscountGiftService mktDiscountGiftService;

    @PostMapping("/search")
    @ApiOperation("分页查询(主表)")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "分页查询参数", required = true, dataType = "MktDiscountGiftQueryVO")
    })
    public ApiResult<PagingVO<MktDiscountGiftRespVO>> search(@RequestBody MktDiscountGiftQueryVO param) {
        val ret = mktDiscountGiftService.search(param);
        return ApiResult.ok(ret);
    }

    @GetMapping("/findCodeOne/{key}")
    @ApiOperation("根据编码查询数据（主表、明细表、赠品表）")
    @ApiOperationSupport(order = 2)
    public ApiResult<MktDiscountGiftRespVO> findCodeOne(@PathVariable String key) {
        return mktDiscountGiftService.findCodeOne(key).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @GetMapping("/findIdOne/{id}")
    @ApiOperation("根据ID查询数据（主表、明细表、赠品表）")
    @ApiOperationSupport(order = 3)
    public ApiResult<MktDiscountGiftRespVO> findIdOne(@PathVariable Long id) {
        return mktDiscountGiftService.findIdOne(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "新增数据", required = true, dataType = "MktDiscountGiftSaveVO")
    })
    public ApiResult<Object> createOne(@RequestBody MktDiscountGiftSaveVO param) {
        return ApiResult.ok(mktDiscountGiftService.createBatch(Collections.singletonList(param)));
    }

    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "新增数据", required = true, dataType = "MktDiscountGiftSaveVO")
    })
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> createBatch(@RequestBody List<MktDiscountGiftSaveVO> list) {
        return ApiResult.ok(mktDiscountGiftService.createBatch(list));
    }

    @PutMapping("/update")
    @ApiOperation("修改数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> update(@RequestBody MktDiscountGiftSaveVO param) {
        mktDiscountGiftService.update(param);
        return ApiResult.ok();
    }

    @GetMapping("/findMktDiscountGiftByParam")
    @ApiOperation("根据入参 查询符合条件的商品折扣信息")
    @ApiOperationSupport(order = 8)
    public ApiResult<List<MktDiscountGiftVO>> findMktDiscountGiftByParam(
            @RequestParam Long ouId,
            @RequestParam(required = false) String customLevel,
            @RequestParam List<Long> itemIds) {
        return ApiResult.ok(mktDiscountGiftService.findMktDiscountGiftByParam(ouId, customLevel, itemIds));
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除【主表、明细、赠品】信息")
    @ApiOperationSupport(order = 9)
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        mktDiscountGiftService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @DeleteMapping("/deleteDBatch")
    @ApiOperation("批量删除【明细、赠品】信息")
    @ApiOperationSupport(order = 10)
    public ApiResult<Object> deleteDBatch(@RequestBody List<Long> ids) {
        mktDiscountGiftService.deleteDBatch(ids);
        return ApiResult.ok();
    }

    @DeleteMapping("/deleteGiftBatch")
    @ApiOperation("批量删除【赠品】信息")
    @ApiOperationSupport(order = 11)
    public ApiResult<Object> deleteGiftBatch(@RequestBody List<Long> ids) {
        mktDiscountGiftService.deleteGiftBatch(ids);
        return ApiResult.ok();
    }

    @PatchMapping(value = "/appr/{ids}/{status}")
    @ApiOperation(value = "审批(启用：ENABLE、禁用：DISABLE)")
    @ApiOperationSupport(order = 20)
    public ApiResult<JSObject> appr(@PathVariable("ids") List<Long> ids, @PathVariable("status") String status) {
        mktDiscountGiftService.appr(ids, status);
        return ApiResult.ok();
    }
}
