package com.elitesland.yst.production.sale.controller.statistics.pc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoExportRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerSaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/01
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping(value = "/statistics/dealer", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "销售业绩统计-经销商", tags = {"销售业绩统计-经销商"})
@RequiredArgsConstructor
public class StatisticsDealerController {
    private final StatisticsDealerService statisticsDealerService;

    @PostMapping(value = "/create/batch")
    @ApiOperation(value = "经销商销售业绩-批量新增")
    public ApiResult<List<SaleStatisticsDealerRespVO>> createBatch(@RequestBody @Validated List<SaleStatisticsDealerSaveVO> saveVOList) {
        List<SaleStatisticsDealerRespVO> respVOList = statisticsDealerService.createBatch(saveVOList);
        return ApiResult.ok(respVOList);
    }

    @PostMapping("/page")
    @ApiOperation("经销商销售业绩分页查询")
    public ApiResult<PagingVO<SaleStatisticsDealerRespVO>> page(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> page = statisticsDealerService.page(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/statisticDealerCode")
    @ApiOperation("查询符合查询条件的已发生交易的经销商编码")
    ApiResult<List<String>> storeQuery(@RequestBody SaleStatisticsDealerQueryVO queryVO) {
        return ApiResult.ok(statisticsDealerService.statisticDealerCode(queryVO));
    }

    @PostMapping("/pageSum")
    @ApiOperation("经销商销售业绩统计汇总")
    ApiResult<StatisticsDealerSumRespVO> pageSum(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        return ApiResult.ok(statisticsDealerService.pageSum(pageParam));
    }

   /* @PostMapping("/exportPage")
    @ApiOperation("经销商销售业绩导出分页查询")
    public ApiResult<PagingVO<SaleStatisticsDealerRespVO>> exportPage(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> page = statisticsDealerService.exportPage(pageParam);
        return ApiResult.ok(page);
    }*/

    @PostMapping("/pullOrder")
    @ApiOperation("经销商销售业绩拉取订单数据并保存")
    public ApiResult<List<SaleStatisticsDealerRespVO>> pullOrder(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        List<SaleStatisticsDealerRespVO> respVOList = statisticsDealerService.pullOrder(pageParam);
        return ApiResult.ok(respVOList);
    }

    @PostMapping("/update/region")
    @ApiOperation("更新区域")
    public ApiResult<List<Long>> updateRegion(@RequestBody List<Long> ids) {
        List<Long> list = statisticsDealerService.updateRegion(ids);
        return ApiResult.ok(list);
    }

    @PostMapping("/update/salesmanPath")
    @ApiOperation("更新业务员")
    public ApiResult<List<Long>> updateSalesmanPath(@RequestBody List<Long> ids) {
        List<Long> list = statisticsDealerService.updateSalesmanPath(ids);
        return ApiResult.ok(list);
    }

}
