package com.elitesland.yst.production.sale.controller.taskInfo;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.TaskInfoDtlService;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoAppQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskExecuteRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoCommonAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/20
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping(value = "/taskInfo/app", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "业务员任务APP端", tags = {"业务员任务APP端"})
@RequiredArgsConstructor
public class TaskInfoAppController {
    private final TaskInfoDtlService taskInfoDtlService;
    private final TaskInfoService taskInfoService;

    @PostMapping("/page")
    @ApiOperation("APP端我的任务-任务明细分页查询")
    public ApiResult<PagingVO<TaskInfoAppRespVO>> appDtlPage(@RequestBody TaskInfoAppQueryVO queryVO) {
        PagingVO<TaskInfoAppRespVO> page = taskInfoDtlService.appDtlPage(queryVO);
        return ApiResult.ok(page);
    }

    @PostMapping("/team/page")
    @ApiOperation("APP端团队任务列表-任务明细分页查询")
    public ApiResult<PagingVO<TaskInfoAppRespVO>> appDtlTeamPage(@RequestBody TaskInfoAppQueryVO queryVO) {
        PagingVO<TaskInfoAppRespVO> page = taskInfoDtlService.appDtlTeamPage(queryVO);
        return ApiResult.ok(page);
    }

    @GetMapping("/findById/{id}")
    @ApiOperation("根据任务ID查询任务详情数据")
    public ApiResult<TaskInfoRespVO> findAppTaskById(@PathVariable Long id) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.findAppTaskById(id);
        return ApiResult.ok(taskInfoRespVO);
    }

    @GetMapping("/findByDtlId/{dtlId}")
    @ApiOperation("根据任务明细ID查询任务详情信息")
    public ApiResult<TaskInfoRespVO> findAppTaskByDtlId(@PathVariable Long dtlId) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.findTaskByDtlId(dtlId);
        return ApiResult.ok(taskInfoRespVO);
    }

    @GetMapping("/execute/check/{id}")
    @ApiOperation("根据任务明细ID开始执行前置校验")
    public ApiResult<TaskExecuteRespVO> taskDtlExecuteCheck(@PathVariable Long id) {
        TaskExecuteRespVO taskExecuteRespVO = taskInfoDtlService.taskDtlExecuteCheck(id, false);
        return ApiResult.ok(taskExecuteRespVO);
    }

    @PostMapping("/query/angleMark/count")
    @ApiOperation("根据执行人编码和任务类型查询角标的数量")
    public ApiResult<List<TaskInfoCommonAppRespVO>> queryAngleMark(@RequestBody TaskInfoAppQueryVO queryVO) {
        List<TaskInfoCommonAppRespVO> commonAppRespVOList = taskInfoDtlService.queryAngleMark(queryVO);
        return ApiResult.ok(commonAppRespVOList);
    }


}
