package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/15:38
 * @Description:我的收藏
 */
@Entity
@Table(name = "bip_favorites")
@org.hibernate.annotations.Table(appliesTo = "bip_favorites", comment = "我的收藏")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipFavoritesDo extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2201459916777952652L;

    @Column(name = "item_id", columnDefinition = "bigInt(20)   comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(20)   comment '商品编码'")
    private String itemCode;


    @Column(name = "cust_account_id", columnDefinition = "varchar(20)   comment '账号id'")
    private Long custAccountId;

    @Column(name = "num", columnDefinition = "varchar(20)   comment '数量'")
    private Long num;

    @Column(name = "put_amt", columnDefinition = "decimal(20,2)   comment '加入时价格'")
    private BigDecimal putAmt;

    @Column(name = "collect_time", columnDefinition = "datetime default null  comment '收藏时间'")
    private LocalDateTime collectTime;

}
