package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/11:17
 * @Description:商品分类
 */

@Entity
@Table(name = "bip_item_category", indexes = {
        @Index(name = "idx_bip_item_category_pid", columnList = "pid"),
        @Index(name = "idx_bip_item_category_ouid", columnList = "ou_id"),
        @Index(name = "idx_bip_item_category_code", columnList = "code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "bip_item_category", comment = "商品品类")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class BipItemCategoryDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 8352927290881717985L;

    @Column(name = "pid", columnDefinition = "bigint(20) not null comment '父id'")
    private Long pid;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '所属公司ID'")
    private Long ouId;

    @Column(name = "code", columnDefinition = "varchar(64) not null comment '分类编码'")
    private String code;

    @Column(name = "name", columnDefinition = "varchar(256)  comment '分类名称'")
    private String name;

    @Column(name = "sortNo", columnDefinition = "int(10) default 0  comment '排序号'")
    private Integer sortNo;

    @Column(name = "enable", columnDefinition = "tinyint(1) default 0 comment '是否启用'")
    private Boolean enable;

    @Column(name = "level", columnDefinition = "int(10) default 1  comment '级别'")
    private Integer level;

    @Column(name = "pic_file_code", columnDefinition = "varchar(32) comment '分类图片的文件标识'")
    private String picFileCode;
}
