package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 物流模板
 */
@Entity
@Table(name = "logistics_template")
@org.hibernate.annotations.Table(appliesTo = "logistics_template", comment = "物流模板")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class LogisticsTemplateDO extends BaseModel implements Serializable {

    @ApiModelProperty("物流模板编码")
    @Column(name = "logistics_code", columnDefinition = "varchar(64)  comment '物流模板编码'")
    private String logisticsCode;


    @ApiModelProperty("物流模板名称")
    @Column(name = "logistics_name", columnDefinition = "varchar(64)  comment '物流模板名称'")
    private String logisticsName;

    @ApiModelProperty("所属公司")
    @Column(name = "ou_id", columnDefinition = "bigint(18)  comment '所属公司'")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(256)  comment '所属公司名称'")
    private String ouName;


    @ApiModelProperty("运费模板描述")
    @Column(name = "logistic_desc", columnDefinition = "varchar(256)  comment '运费模板描述'")
    private String logisticDesc;


    @ApiModelProperty("状态")
    @Column(name = "status", columnDefinition = "varchar(32)  comment '状态'")
    private String status;

    @ApiModelProperty("发货省")
    @Column(name = "province_name", columnDefinition = "varchar(256)  comment '发货省'")
    private String provinceName;

    @ApiModelProperty("发货省代码")
    @Column(name = "province_code", columnDefinition = "varchar(256)  comment '发货省代码'")
    private String provinceCode;

    @ApiModelProperty("发货市")
    @Column(name = "city_name", columnDefinition = "varchar(256)  comment '发货市'")
    private String cityName;

    @ApiModelProperty("发货市代码")
    @Column(name = "city_code", columnDefinition = "varchar(256)  comment '发货市代码'")
    private String cityCode;

    @ApiModelProperty("发货区")
    @Column(name = "county_name", columnDefinition = "varchar(256)  comment '发货区'")
    private String countyName;

    @ApiModelProperty("发货区代码")
    @Column(name = "county_code", columnDefinition = "varchar(256)  comment '发货区代码'")
    private String countyCode;




}
