package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 价格变更申请单明细表
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 9:46 上午
 */
@Entity
@Table(name = "pri_sale_price_alter_d")
@org.hibernate.annotations.Table(appliesTo = "pri_sale_price_alter_d", comment = "销售价格变更明细")

@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class PriSalePriceAlterDDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 5960784857999467486L;

    @ApiModelProperty(value = "租户ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) not null  comment '主表ID'")
    private Long masId;

    @ApiModelProperty("销售区域")
    @Column(name = "sale_region", columnDefinition = "varchar(40) comment '销售区域 [UDC]ORG:OU_REGION'")
    private String saleRegion;

    @ApiModelProperty("客户组(客户等级)")
    @Column(name = "cust_group", columnDefinition = "varchar(40) comment '客户组(客户等级) [UDC]CRM:CUST_GROUP'")
    private String custGroup;

    @ApiModelProperty("客户组2")
    @Column(name = "cust_group2", columnDefinition = "varchar(40) comment '客户组2'")
    private String custGroup2;

    @ApiModelProperty("客户组3")
    @Column(name = "cust_group3", columnDefinition = "varchar(40) comment '客户组3'")
    private String custGroup3;

    @ApiModelProperty("客户组4")
    @Column(name = "cust_group4", columnDefinition = "varchar(40) comment '客户组4'")
    private String custGroup4;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;
    @ApiModelProperty("客户编号")
    @Column(name = "cust_code", columnDefinition = "varchar(40) comment '客户编号'")
    private String custCode;
    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(100) comment '客户编号'")
    private String custName;

    @ApiModelProperty(value = "商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(20) default null  comment '商品ID'")
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    @Column(name = "item_code", columnDefinition = "varchar(40) default null  comment '商品编号'")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称'")
    private String itemName;

    @ApiModelProperty(value = "商品名称2")
    @Column(name = "item_name2", columnDefinition = "varchar(100) default null comment '商品名称2'")
    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    @Column(name = "item_spec", columnDefinition = "varchar(255) default null comment '商品规格'")
    private String itemSpec;

    @ApiModelProperty(value = "SPU ID")
    @Column(name = "spu_id", columnDefinition = "bigint(20) default null comment 'SPU ID'")
    private Long spuId;

    @ApiModelProperty(value = "SPU CODE")
    @Column(name = "spu_code", columnDefinition = "varchar(40) default null comment 'SPU CODE'")
    private String spuCode;

    @ApiModelProperty(value = "SPU名称")
    @Column(name = "spu_name", columnDefinition = "varchar(100) default null comment 'SPU名称'")
    private String spuName;

    @ApiModelProperty(value = "条码")
    @Column(name = "barcode", columnDefinition = "varchar(100) default null comment '条码'")
    private String barcode;

    @ApiModelProperty("含税价格")
    @Column(name = "price", columnDefinition = "decimal(20,8) comment '含税价格'")
    private BigDecimal price;

    @ApiModelProperty("不含税价格")
    @Column(name = "net_price", columnDefinition = "decimal(20,8) comment '不含税价格'")
    private BigDecimal netPrice;

    @ApiModelProperty("税率编号")
    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) comment '税率编号'")
    private String taxRateNo;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20,8) comment '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "生效时间")
    @Column(name = "valid_from", columnDefinition = "datetime  comment '生效时间'")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效时间")
    @Column(name = "valid_to", columnDefinition = "datetime  comment '失效时间'")
    private LocalDateTime validTo;

    // 以下字段没有设计
    @ApiModelProperty(value = "商品分类码")
    @Column(name = "item_cate_code", columnDefinition = "varchar(40) default null  comment '商品分类码'")
    private String itemCateCode;

    @ApiModelProperty(value = "商品分类全路径")
    @Column(name = "item_cate_path", columnDefinition = "varchar(80) default null  comment '商品分类全路径'")
    private String itemCatePath;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(10) comment '单位'")
    private String uom;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10) comment '币种'")
    private String currCode;

    // 活动价格新增
    @ApiModelProperty(value = "活动价生效日期")
    @Column(name = "prom_date_f", columnDefinition = "datetime  comment '活动价生效日期'")
    private LocalDateTime promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    @Column(name = "prom_date_t", columnDefinition = "datetime  comment '活动价失效日期'")
    private LocalDateTime promDateT;

    @ApiModelProperty("活动含税价格")
    @Column(name = "promotion_price", columnDefinition = "decimal(20,8) comment '活动含税价格'")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    @Column(name = "promotion_net_price", columnDefinition = "decimal(20,8) comment '活动不含税价格'")
    private BigDecimal promotionNetPrice;


}
