package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * SAL_INV_SERIAL(发票明细表)
 *
 * @auther JinXK
 * @date 2021/9/29 14:46
 */
@Entity
@Table(name = "sal_inv_serial")
@org.hibernate.annotations.Table(appliesTo = "sal_inv_serial", comment = "发票明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalInvSerialDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(18) default null comment '开票申请ID'")
    private Long masId;

    @Column(name = "inv_serial_no", columnDefinition = "varchar(100) default null  comment '开票系统流水号'")
    private String invSerialNo;

    @Column(name = "inv_no", columnDefinition = "varchar(100) default null  comment '发票号码'")
    private String invNo;

    @Column(name = "inv_code", columnDefinition = "varchar(100) default null  comment '发票代码'")
    private String invCode;

    @Column(name = "inv_check_code", columnDefinition = "varchar(100) default null  comment '发票校验码'")
    private String invCheckCode;

    @Column(name = "inv_status", columnDefinition = "varchar(100) default null  comment '发票状态'")
    private String invStatus;

    @Column(name = "inv_date", columnDefinition = "datetime default null  comment '开票日期'")
    private LocalDateTime invDate;

    @Column(name = "e_pdf_url", columnDefinition = "varchar(255) default null  comment '电子发票PDF地址'")
    private String ePdfUrl;

    @Column(name = "inv_picture_url", columnDefinition = "varchar(255) default null  comment '发票图片地址'")
    private String ouCode;

    @Column(name = "paper_pdf_url", columnDefinition = "varchar(255) default null  comment '纸质发票PDF地址'")
    private String paperPdfUrl;

    @Column(name = "state", columnDefinition = "tinyint(1) default 0  comment '是否作废'")
    private Boolean state;

    @Column(name = "is_red", columnDefinition = "tinyint(1) default 0  comment '是否红冲'")
    private Boolean isRed;
}
