package com.elitesland.yst.production.sale.repo;


import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogVO;
import com.elitesland.yst.production.sale.entity.QCustLoginLogDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class CustLoginLogRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    private final QCustLoginLogDO qCustLoginLogDO = QCustLoginLogDO.custLoginLogDO;


    public List<CustLoginLogVO> getByUserName(String userName){
        return jpaQueryFactory.select(Projections.bean(CustLoginLogVO.class,
                        qCustLoginLogDO.loginIp,
                        qCustLoginLogDO.loginTime,
                        qCustLoginLogDO.userId,
                        qCustLoginLogDO.userName
                )).from(qCustLoginLogDO)
                .where(qCustLoginLogDO.deleteFlag.eq(0).and(qCustLoginLogDO.userName.eq(userName)))
                .orderBy(qCustLoginLogDO.createTime.desc()).limit(2)
                .fetch();
    }


}
