package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalSoaDRespVO;
import com.elitesland.yst.production.sale.entity.QSalReceiptDDO;
import com.elitesland.yst.production.sale.entity.QSalSoaDDO;
import com.elitesland.yst.production.sale.entity.QSalSoaDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/7/7 10:38
 */
@Repository
public class SalSoaDRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    /**
     * 根据masId查询客户对账单明细
     */
    public JPAQuery<SalSoaDRespVO> findBymasId(Long masId) {
        val salSoaDDO = QSalSoaDDO.salSoaDDO;

        Predicate predicate = salSoaDDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalSoaDRespVO.class,
                salSoaDDO.id,
                salSoaDDO.masId,
                salSoaDDO.docNo,
                salSoaDDO.lineNo,
                salSoaDDO.custId,
                salSoaDDO.lineStatus,
                salSoaDDO.soId,
                salSoaDDO.soNo,
                salSoaDDO.soDId,
                salSoaDDO.soLineNo,
                salSoaDDO.docCls,
                salSoaDDO.doDocNo,
                salSoaDDO.dodId,
                salSoaDDO.itemId,
                salSoaDDO.itemCode,
                salSoaDDO.itemName,
                salSoaDDO.itemSpec,
                salSoaDDO.itemBrand,
                salSoaDDO.soQty,
                salSoaDDO.soUom,
                salSoaDDO.soTaxRateNo,
                salSoaDDO.soTaxRate,
                salSoaDDO.soAmt,
                salSoaDDO.soTaxAmt,
                salSoaDDO.doQty,
                salSoaDDO.doAmt,
                salSoaDDO.doTaxAmt,
                salSoaDDO.confirmQty,
                salSoaDDO.confirmAmt,
                salSoaDDO.confirmTaxAmt,
                salSoaDDO.soaQty,
                salSoaDDO.soaAmt,
                salSoaDDO.soaTaxAmt,
                salSoaDDO.doQty2,
                salSoaDDO.confirmNetAmt,
                salSoaDDO.soNetAmt,
                salSoaDDO.confirmTime,
                salSoaDDO.docTime,
                salSoaDDO.soPrice,
                salSoaDDO.soNetPrice,
                salSoaDDO.taxClass,
                salSoaDDO.taxClassDesc,
                salSoaDDO.contractId,
                salSoaDDO.contractCode,
                salSoaDDO.contractName

        )).from(salSoaDDO);
        jpaQuery.where(predicate, salSoaDDO.masId.eq(masId));
        jpaQuery.where(predicate, salSoaDDO.deleteFlag.eq(0).or(salSoaDDO.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 根据masId批量查询客户对账单明细
     */
    public JPAQuery<SalSoaDRespVO> findAllBymasIds(List<Long> masIds) {
        val salSoaDDO = QSalSoaDDO.salSoaDDO;

        Predicate predicate = salSoaDDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalSoaDRespVO.class,
                salSoaDDO.id,
                salSoaDDO.masId,
                salSoaDDO.docNo,
                salSoaDDO.lineNo,
                salSoaDDO.custId,
                salSoaDDO.lineStatus,
                salSoaDDO.soId,
                salSoaDDO.soNo,
                salSoaDDO.soDId,
                salSoaDDO.soLineNo,
                salSoaDDO.docCls,
                salSoaDDO.doDocNo,
                salSoaDDO.dodId,
                salSoaDDO.itemId,
                salSoaDDO.itemCode,
                salSoaDDO.itemName,
                salSoaDDO.itemSpec,
                salSoaDDO.itemBrand,
                salSoaDDO.soQty,
                salSoaDDO.soUom,
                salSoaDDO.soTaxRateNo,
                salSoaDDO.soTaxRate,
                salSoaDDO.soAmt,
                salSoaDDO.soTaxAmt,
                salSoaDDO.doQty,
                salSoaDDO.doAmt,
                salSoaDDO.doTaxAmt,
                salSoaDDO.confirmQty,
                salSoaDDO.confirmAmt,
                salSoaDDO.confirmTaxAmt,
                salSoaDDO.soaQty,
                salSoaDDO.soaAmt,
                salSoaDDO.soaTaxAmt,
                salSoaDDO.doQty2,
                salSoaDDO.confirmNetAmt,
                salSoaDDO.soNetAmt,
                salSoaDDO.confirmTime,
                salSoaDDO.docTime,
                salSoaDDO.soPrice,
                salSoaDDO.taxClass,
                salSoaDDO.taxClassDesc,
                salSoaDDO.contractId,
                salSoaDDO.contractCode,
                salSoaDDO.contractName

        )).from(salSoaDDO);
        jpaQuery.where(predicate, salSoaDDO.masId.in(masIds));
        jpaQuery.where(predicate, salSoaDDO.deleteFlag.eq(0).or(salSoaDDO.deleteFlag.isNull()));
        return jpaQuery;
    }
}
