package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/23 16:50
 */
@Component
@Slf4j
public class RmiSysRoleService {

    @Autowired
    private SysUserPermissionRpcService permissionRpcService;

    public ApiResult<Long> generateCode(Long userId, List<Long> roleIds){
        try {
            ApiResult<Long> longApiResult = permissionRpcService.saveUserRoles(userId, roleIds);
            if (!longApiResult.isSuccess()){
                throw new BusinessException("远程调用系统域角色修改相关服务异常");
            }
            return longApiResult;
        } catch (Exception e) {
            log.error("远程调用系统域角色修改相关服务异常:", e);
            throw new BusinessException("远程调用系统域角色修改失败", e);
        }
    }
}
