package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalAcceptanceService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptancePagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptanceSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptanceDDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptanceDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptancePageRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.SalAcceptanceConvert;
import com.elitesland.yst.production.sale.convert.SalAcceptanceDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QSalAcceptanceDO;
import com.elitesland.yst.production.sale.entity.SalAcceptanceDDO;
import com.elitesland.yst.production.sale.entity.SalAcceptanceDO;
import com.elitesland.yst.production.sale.repo.SalAcceptanceDRepo;
import com.elitesland.yst.production.sale.repo.SalAcceptanceRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 10:41:22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SalAcceptanceServiceImpl extends BaseServiceImpl implements SalAcceptanceService {
    private final QSalAcceptanceDO qalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;
    private final SalAcceptanceRepo salAcceptanceRepo;
    private final SalAcceptanceDRepo salAcceptanceDRepo;
    private final UserService userService;
    private final RmiSysNextNumberService nextNumberService;
    //远程调用订单中心相关服务
    private final RmiOrderSalSoDService rmiOrderSalSoDService;
    private static final String DOC_STATUS_DONE = "DONE";

    private final RmiOrgEmpService rmiOrgEmpService;

    private final RmiOrgBuService rmiOrgBuService;

    private final RmiOrgOuService rmiOrgOuService;

    private final ComSaleFileInfoService comSaleFileInfoService;

//    private final RmiItemService rmiItemService;

    private final RmiCommonService rmiCommonService;

    private final TransactionTemplate transactionTemplate;

    @Autowired
    private WorkflowService workflowService;
    @Override
    @SysCodeProc
    public PagingVO<SalAcceptancePageRespVO> query(SalAcceptancePagingParam pageParam) {
        var jpaQuery = jpaQueryFactory.selectFrom(qalAcceptanceDO).where(buildPageSearchCondition(pageParam));
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalAcceptancePageRespVO>builder().build();
        }
        // 添加分页和排序
        var pageRequest = wrapperPageRequest(pageParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qalAcceptanceDO);
        // 查询结果
        List<SalAcceptanceDO> queryResult = jpaQuery.fetch();
        List<SalAcceptancePageRespVO> pageResult = queryResult.stream().map(SalAcceptanceConvert.INSTANCE::doToPageRespVo).collect(Collectors.toList());

        this.translationPage(pageResult);

        return PagingVO.<SalAcceptancePageRespVO>builder().total(total).records(pageResult).build();
    }

    private void translationPage(List<SalAcceptancePageRespVO> pageRespVOS) {
        // ----------- 根据申请人Id(applyEmpId)回显姓名 ------------
        List<Long> applyEmpIds = pageRespVOS.stream().map(SalAcceptancePageRespVO::getApplyEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgEmpRpcDTO> empListByParam = new ArrayList<>();
        if (!ObjectUtils.isEmpty(applyEmpIds)) {
            OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
            orgEmpRpcDtoParam.setEmpIds(applyEmpIds);
            empListByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        // ----------- 根据公司Id(ouId)回显姓名 -------------------
        List<Long> ouIds = pageRespVOS.stream().map(SalAcceptancePageRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<OrgOuRpcDTO> ouListByParam = new ArrayList<>();
        if (!ObjectUtils.isEmpty(ouIds)) {
            ouListByParam = rmiOrgOuService.findOuDtoList(ouIds, null);
        }

        List<OrgEmpRpcDTO> finalEmpListByParam = empListByParam;
        List<OrgOuRpcDTO> finalOuListByParam = ouListByParam;
        pageRespVOS.forEach(page -> {
            finalEmpListByParam.stream().filter(emp -> emp.getId().equals(page.getApplyEmpId()))
                    .findFirst()
                    .ifPresent(resp -> page.setApplyEmpName(resp.getEmpName()));
            finalOuListByParam.stream().filter(ou -> ou.getId().equals(page.getOuId()))
                    .findFirst()
                    .ifPresent(resp -> page.setOuName(resp.getOuName()));
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject saveOrSubmit(SalAcceptanceSaveParam param, String operation) {

        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }


        // 设置隔离级别
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        // ----------- 不同价格类型，进行校验特定的参数，校验通过返回已存在的申请单 -----------
        // 开启事务
        SalAcceptanceDO salAcceptanceDO1 = transactionTemplate.execute(transactionStatus -> {
            try {
                // 1.通过id来判断是否是新增还是提交
                if (Objects.isNull(param.getId())) {
                    String docNO = nextNumberService.generateCode("yst-sale","SAL_AC_NO", new ArrayList<>());
                    param.setDocNo(docNO);
                } else {
                    // 若参数中传递Id，则表示已存在单子，需要判断单子状态
                    // 2.这里为提交操作
                    SalAcceptanceDO salAcceptanceDO = this.findSalAcceptanceDO(param.getId());
                    String acStatus = salAcceptanceDO.getAcStatus();
                    if (!UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode().equals(acStatus) && !UdcEnum.SAL_AC_STATUS_REJECTED.getValueCode().equals(acStatus)) {
                        throw new BusinessException("当前验收单状态不可执行该操作");
                    }
                    param.setDocNo(salAcceptanceDO.getDocNo());
                }
                // 确保数据一致性在保存时要进行再查一次(销售订单表)
                SalAcceptanceDetailRespVO salAcceptanceDetailRespVO = SalAcceptanceConvert.INSTANCE.paramToDetailVo(param);
                // 明细金额数量需要额外处理
          //      this.syncSalSoDService(salAcceptanceDetailRespVO,null);
//        List<SalAcceptanceDDetailRespVO> details = new ArrayList<>();
//        details = param.getDetails().stream().map(SalAcceptanceDConvert.INSTANCE::saveParamToDetailVo).collect(Collectors.toList());

                // 主表信息和处理后的主表数据保持一致
                var salAcceptanceDO = SalAcceptanceConvert.INSTANCE.detailVoDo(salAcceptanceDetailRespVO);
                salAcceptanceDO.setDeleteFlag(0);
                // 设置单据状态
                if (ConstantsSale.SAVE_OPERATION.equals(operation)){
                    salAcceptanceDO.setAcStatus(UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode());
                }
//                salAcceptanceDO.setAcStatus(ConstantsSale.SAVE_OPERATION.equals(operation) ? UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode() : UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
//                salAcceptanceDO.setApprStatus(ConstantsSale.SAVE_OPERATION.equals(operation) ? null : UdcEnum.COM_APPR_STATUS_APPROVING.getValueCode());
                // 添加权限字段
                salAcceptanceDO.setSecBuId(param.getBuId());
                salAcceptanceDO.setSecOuId(param.getOuId());
                salAcceptanceDO.setSecUserId(param.getApplyEmpId());
                salAcceptanceRepo.save(salAcceptanceDO);
//                if (!CollectionUtils.isEmpty(param.getFileComVOS())) {
                    comSaleFileInfoService.comSaleFileHardSave("SAL_ACC", salAcceptanceDO.getId(), param.getFileComVOS());
//                }
                // 处理明细，全删重插入
                salAcceptanceDRepo.deleteAllByMasId(salAcceptanceDO.getId());

                // 只取本次入参中的本次验收数量和本次验收金额
                List<SalAcceptanceDDetailRespVO> paramDetails = salAcceptanceDetailRespVO.getDetails();

                // 查询详情的时候我需要从销售订单查询一次
                log.info("报价单保存明细打印{}", JSON.toJSONString(paramDetails));
                if (CollUtil.isNotEmpty(paramDetails)) {
                    // 从入参中补充必要的数据
                    paramDetails.forEach(detail -> {
                        detail.setMasId(salAcceptanceDO.getId());
                        // 数据校验[保存和提交](本次验收数量的绝对值不能大于 待验收数量(=已签收数量-已验收数量-验收中数量 ))
//                BigDecimal unConfirmQty = (detail.getConfirmQty() == null ? BigDecimal.ZERO : detail.getConfirmQty())
//                        .subtract((detail.getExamedQty() == null ? BigDecimal.ZERO : detail.getExamedQty()).add(detail.getExamingQty() == null ? BigDecimal.ZERO : detail.getExamingQty()));
                        if ((detail.getAcQty().abs() == null ? BigDecimal.ZERO : detail.getAcQty()).compareTo(detail.getAeQty().abs()) > 0) {
                            throw new BusinessException("发货单号：" + detail.getSoNo() + "，本次验收数量大于待验收数量");
                        }
                    });
                    // 保存数据
                    List<SalAcceptanceDDO> salAcceptanceDDOList = paramDetails.stream().map(SalAcceptanceDConvert.INSTANCE::detailVoToDo).collect(Collectors.toList());
                    salAcceptanceDRepo.saveAll(salAcceptanceDDOList);
//                    // 如果该操作为提交操作
//                    if (ConstantsSale.SUBMIT_OPERATION.equals(operation)) {
//                        this.updateOrderSal(salAcceptanceDDOList, 1);
//                    }
                }
                return salAcceptanceDO;

            } catch (Exception e) {
                // 回滚
                transactionStatus.setRollbackOnly();
                throw e;
            }
        });
        if (ConstantsSale.SUBMIT_OPERATION.equals(operation)){
            salAcceptanceDO1.setAcStatus(UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
            salAcceptanceRepo.save(salAcceptanceDO1);
            List<SalAcceptanceDDO> salAcceptanceDDOS = salAcceptanceDRepo.findAllByMasId(salAcceptanceDO1.getId());
       //     this.updateOrderSal(salAcceptanceDDOS, 1);
            log.info("报价单提交开启工作流{}", JSON.toJSONString(salAcceptanceDO1));
            /************************************************************************
             *                              工作流开始                                *
             ************************************************************************/

            if (param.getId() == null                                                                    //1,新对象
                    || salAcceptanceDO1.getProcInstId() == null                                                   //2,旧单子，未起过工作流
                    || WorkflowConstant.CAN_START_PROC_STATUSES.contains(salAcceptanceDO1.getProcInstStatus())    //3,旧单子，可以起工作流
            ) {
                /**
                 * 为什么要加上面3个判断，是因为流程已经启动了,就没必要再启动流程(场景:在'审批中'的过程中，做保存操作)
                 * 工作流规则:
                 *  1,一个业务单据在一个流程没结束前是不能再起的同一个工作流
                 *  2,一个业务单据可以同时有2个"不同类型"的流程再跑
                 */
                //启动流程
                String procInstName = null;//流程实例名称
                ProcDefKey procDefKey = null;//流程

                procInstName = "B端合同验收单";//这里可以自定义
                procDefKey = ProcDefKey.SAL_ACCEPTANCE;
                WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(procDefKey.name(),
                        procInstName + "-" + salAcceptanceDO1.getDocNo(), salAcceptanceDO1.getId() + "", null));
                if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                    throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
                }
                log.info("报价单工作流开启结果{}", JSON.toJSONString(processInfoWorkflowResult.getData()));
                //修改业务审批数据
                QSalAcceptanceDO qSalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;
                JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qSalAcceptanceDO)
                        .set(qSalAcceptanceDO.procInstId, processInfoWorkflowResult.getData().getProcInstId())//流程实例id
//                        .set(qPriSalePriceAlterDO.procInstStatus, ProcInstStatus.APPROVING)//审批状态
                        .set(qSalAcceptanceDO.submitTime, LocalDateTime.now())//提交实际那
//                        .set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode())//单据状态
                        .where(qSalAcceptanceDO.id.eq(salAcceptanceDO1.getId()));
                if (!Objects.equals(processInfoWorkflowResult.getData().getProcInstStatus(), ProcInstStatus.APPROVED)){
                    jpaUpdateClause.set(qSalAcceptanceDO.procInstStatus,ProcInstStatus.APPROVING);
                    jpaUpdateClause.set(qSalAcceptanceDO.acStatus,UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
                }
                jpaUpdateClause.execute();
            }

            /************************************************************************
             *                              工作流结束                                *
             ************************************************************************/
        }
        // 返回验收单ID及验收单号
        var result = new JSONObject();
        result.put("id", salAcceptanceDO1.getId());
        result.put("docNo", salAcceptanceDO1.getDocNo());
        return result;
    }

//    private void updateOrderSal(List<SalAcceptanceDDO> salAcceptanceDDOList, Integer operation) {
//        // 调用订单域的更新接口
//        List<SalDoDExamDTO> salDoDExamDTOS = salAcceptanceDDOList.stream().map(sal -> {
//            SalDoDExamDTO salDoDExamDTO = new SalDoDExamDTO();
//            salDoDExamDTO.setDoDId(sal.getSoDId());
//            salDoDExamDTO.setExamQty(sal.getAcQty());
//            salDoDExamDTO.setExamAmt(sal.getAcAmt());
//            salDoDExamDTO.setStatus(operation);
//            return salDoDExamDTO;
//        }).collect(Collectors.toList());
//        ApiResult<String> stringApiResult = rmiOrderSalSoDService.updateSalDoDForExam(salDoDExamDTOS);
//        if (!stringApiResult.isSuccess()) {
//            throw new BusinessException(stringApiResult.getMsg());
//        }
//    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submitOne(Long id) {
        var salAcceptanceDO = this.findSalAcceptanceDO(id);
        if (!UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode().equals(salAcceptanceDO.getAcStatus())) {
            throw new BusinessException("当前验收单状态不可执行该操作");
        }
//        salAcceptanceDO.setApprStatus(UdcEnum.COM_APPR_STATUS_APPROVING.getValueCode());
        salAcceptanceDO.setAcStatus(UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());
        salAcceptanceRepo.save(salAcceptanceDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteAc(Long id) {
        var salAcceptanceDO = this.findSalAcceptanceDO(id);
        salAcceptanceDO.setDeleteFlag(1);
        salAcceptanceRepo.save(salAcceptanceDO);
        // 逻辑删除明细
        List<SalAcceptanceDDO> details = salAcceptanceDRepo.findAllByMasId(id);
        details.forEach(d -> d.setDeleteFlag(1));
        salAcceptanceDRepo.saveAll(details);
    }

    @Override
    @SysCodeProc
    public SalAcceptanceDetailRespVO findOneDetail(Long id) {
//        var salAcceptanceDO = this.findSalAcceptanceDO(id);
//        SalAcceptanceDetailRespVO salAcceptanceVO = SalAcceptanceConvert.INSTANCE.doToDetailVo(salAcceptanceDO);
//        // 补充数据(附件
//        List<ComSaleFileComVO> comSaleFileComVOS = comSaleFileInfoService.findFileByBusinessId("SAL_ACC", id);
//        salAcceptanceVO.setFileComVOS(comSaleFileComVOS);
//        // 查询销售订单域的数据进行数据同步
//       // this.syncSalSoDService(salAcceptanceVO,"FIND");
//        this.translation(salAcceptanceVO);
//        return salAcceptanceVO;
//    }
//
//    private void translation(SalAcceptanceDetailRespVO salAcceptanceVO) {
//        if (ObjectUtils.isEmpty(salAcceptanceVO)) {
//            return;
//        }
//        // 补充申请人名称
//        if (!StringUtils.isEmpty(salAcceptanceVO.getApplyEmpId())) {
//            OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
//            List<Long> empIds = new ArrayList<>();
//            empIds.add(salAcceptanceVO.getApplyEmpId());
//            orgEmpRpcDtoParam.setEmpIds(empIds);
//            List<OrgEmpRpcDTO> empListByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
//            empListByParam.stream().filter(emp -> emp.getId().equals(salAcceptanceVO.getApplyEmpId()))
//                    .findFirst()
//                    .ifPresent(sale -> salAcceptanceVO.setApplyEmpName(sale.getEmpName()));
//        }
//        // 补充ouName
//        if (!StringUtils.isEmpty(salAcceptanceVO.getOuId())) {
//            OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
//            List<Long> ouIds = new ArrayList<>();
//            ouIds.add(salAcceptanceVO.getOuId());
//            orgOuRpcDtoParam.setOuIds(ouIds);
//            List<OrgOuRpcDTO> ouDtoByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
//            ouDtoByParam.stream().filter(ou -> ou.getId().equals(salAcceptanceVO.getOuId()))
//                    .findFirst()
//                    .ifPresent(ouParam -> salAcceptanceVO.setOuName(ouParam.getOuName()));
//        }
//        // 补充buName
//        if (!StringUtils.isEmpty(salAcceptanceVO.getBuId())) {
//            OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
//            List<Long> buIds = new ArrayList<>();
//            buIds.add(salAcceptanceVO.getBuId());
//            orgBuRpcDtoParam.setBuIds(buIds);
//            List<OrgBuRpcDTO> buDtoByParam = rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
//            buDtoByParam.stream().filter(bu -> bu.getId().equals(salAcceptanceVO.getBuId()))
//                    .findFirst()
//                    .ifPresent(buParam -> salAcceptanceVO.setBuName(buParam.getBuName()));
//        }
//        // 补充明细品牌
//        if (!ObjectUtils.isEmpty(salAcceptanceVO.getDetails())) {
//            List<SalAcceptanceDDetailRespVO> salAcceptanceDDetailRespVOS = salAcceptanceVO.getDetails();
//            // 翻译品牌名称
//            List<String> itemBrands = salAcceptanceDDetailRespVOS.stream().map(SalAcceptanceDDetailRespVO::getItemBrand).distinct().filter(Objects::nonNull)
//                    .collect(Collectors.toList());
//            ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
//            itmItemRpcDtoParam.setBrands(itemBrands);
//            List<ItmItemRpcDTO> itmItemRpcDTOS = rmiItemService.findItemListByParam(itmItemRpcDtoParam);
//
//            // 翻译单位名称
//            List<String> uoms = salAcceptanceDDetailRespVOS.stream().map(SalAcceptanceDDetailRespVO::getUom).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//            List<SysUdcComboVO> udcValues = sysUdcService.findByUdcValues(uoms);
//
//            // 翻译税率
//            List<String> taxRates = salAcceptanceDDetailRespVOS.stream().map(SalAcceptanceDDetailRespVO::getTaxRateNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//            ComTaxRateRpcDtoParam comTaxRateRpcDtoParam = new ComTaxRateRpcDtoParam();
//            List<ComTaxRateRpcDTO> taxRateRpcDtoByParam = new ArrayList<>();
//            if (!CollectionUtils.isEmpty(taxRates)) {
//                comTaxRateRpcDtoParam.setTaxRateNos(taxRates);
//                taxRateRpcDtoByParam = rmiCommonService.findTaxRateRpcDtoByParam(comTaxRateRpcDtoParam);
//            }
//
//            List<ComTaxRateRpcDTO> finalTaxRateRpcDtoByParam = taxRateRpcDtoByParam;
//            salAcceptanceDDetailRespVOS.forEach(sal -> {
//                itmItemRpcDTOS.stream().filter(itm -> !StringUtils.isEmpty(sal.getItemBrand()) && sal.getItemBrand().equals(itm.getBrand()))
//                        .findFirst()
//                        .ifPresent(item -> sal.setItemBrandName(item.getBrandName()));
//                udcValues.stream().filter(uom -> !StringUtils.isEmpty(sal.getUom()) && sal.getUom().equals(uom.getUdcVal()))
//                        .findFirst()
//                        .ifPresent(udc -> sal.setUomName(udc.getValDesc()));
//                finalTaxRateRpcDtoByParam.stream().filter(tax -> !StringUtils.isEmpty(sal.getTaxRateNo()) && sal.getTaxRateNo().equals(tax.getTaxRateNo()))
//                        .findFirst()
//                        .ifPresent(taxRate -> sal.setTaxRateDesc(taxRate.getTaxRateDesc()));
//            });
//        }
        return null;
    }

    // 从sal订单域查的数据方法单独提出来便于方法复用，在提交保存时再次动态获取数据防止高并发造成数据不一致
//    private void syncSalSoDService(SalAcceptanceDetailRespVO salAcceptanceVO,String operate) {
//        // 获取所有验收单明细(如果第一次保存时，明细取入参中的明细,如果是提交或者是查询则取表中的明细数据)
//        List<SalAcceptanceDDetailRespVO> dDetailRespVOS = new ArrayList<>();
//        if (!StringUtils.isEmpty(salAcceptanceVO.getId()) && ConstantsSale.FIND_OPERATION.equals(operate)) {
//            List<SalAcceptanceDDO> salAcceptanceDDOS = salAcceptanceDRepo.findAllByMasId(salAcceptanceVO.getId());
//            dDetailRespVOS = salAcceptanceDDOS.stream().map(SalAcceptanceDConvert.INSTANCE::doToDetailVo).collect(Collectors.toList());
//        } else {
//            dDetailRespVOS = salAcceptanceVO.getDetails();
//        }
//        // 查询详情的时候我需要从销售订单查询一次
//        salAcceptanceVO.setDetails(dDetailRespVOS);
//        List<SalDoDRPCRespDTO> fromRmiOrderSalSoDService = this.findFromRmiOrderSalSoDService(salAcceptanceVO);
//        // 获取所有的查到的订单的明细信息(我会根据订单明细id对数据进行补充)
//        List<SalAcceptanceDDetailRespVO> details = fromRmiOrderSalSoDService.stream().map(SalAcceptanceDConvert.INSTANCE::dtoToDetailVo).collect(Collectors.toList());
//        //计算 验收金额（含税）amt  、 验收金额（不含税）netAmt   和   验收税额taxAmt
//        BigDecimal amt = new BigDecimal("0.00");
//        BigDecimal netAmt = new BigDecimal("0.00");
//        BigDecimal taxAmt = new BigDecimal("0.00");
//        for (SalAcceptanceDDetailRespVO detail : dDetailRespVOS) {
//            amt = amt.add(detail.getAcAmt());
//            netAmt = netAmt.add(detail.getAcNetAmt());
//            taxAmt = taxAmt.add(detail.getAcTaxAmt());
//        }
//        salAcceptanceVO.setAmt(amt);
//        salAcceptanceVO.setNetAmt(netAmt);
//        salAcceptanceVO.setTaxAmt(taxAmt);
//        //将本地存储的(本次验收数量、本次验收含税金额、本次验收不含税金额、本次验收税额)输出
//        // 翻译品牌
//        log.info("销售验收单明细(oms方){}", JSON.toJSONString(details));
//        dDetailRespVOS.forEach(detail -> {
//            details.stream().filter(sal -> sal.getSoDId().equals(detail.getSoDId()))
//                    .findFirst().ifPresent(salD -> {
//                detail.setAeQty(salD.getAeQty());
//                detail.setConfirmQty(salD.getConfirmQty());
//                detail.setConfirmAmt(salD.getConfirmAmt());
//                detail.setConfirmNetAmt(salD.getConfirmNetAmt());
//                detail.setConfirmTaxAmt(salD.getConfirmTaxAmt());
//                detail.setSoDId(salD.getSoDId());
//                detail.setLineNo(salD.getLineNo());
//                detail.setItemCode(salD.getItemCode());
//                detail.setItemName(salD.getItemName());
//                detail.setItemSpec(salD.getItemSpec());
//                detail.setItemBrand(salD.getItemBrand());
//                detail.setSoQty(salD.getSoQty());
//                detail.setUom(salD.getUom());
//                detail.setQty(salD.getQty());
//                detail.setPrice(salD.getPrice());
//                detail.setSoAmt(salD.getSoAmt());
//                detail.setSoTaxAmt(salD.getSoTaxAmt());
//                detail.setTaxRateNo(salD.getTaxRateNo());
//                detail.setSoTaxRate(salD.getSoTaxRate());
//                detail.setExamedQty(salD.getExamedQty());
//                detail.setExamingQty(salD.getExamingQty());
//            });
//        });
//        salAcceptanceVO.setDetails(dDetailRespVOS);
//        log.info("销售验收单明细2(oms方){}", JSON.toJSONString(details));
//    }

//    public List<SalDoDRPCRespDTO> findFromRmiOrderSalSoDService(SalAcceptanceDetailRespVO salAcceptanceVO) {
//        List<SalAcceptanceDDetailRespVO> acceptanceVODetails = salAcceptanceVO.getDetails();
//        if (!CollectionUtils.isEmpty(acceptanceVODetails)) {
//            SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
//            List<Long> soDIds = acceptanceVODetails.stream().map(SalAcceptanceDDetailRespVO::getSoDId)
//                    .filter(Objects::nonNull).collect(Collectors.toList());
//            salDoDQueryDTO.setIds(soDIds);
////            salDoDQueryDTO.setDocNo(acceptanceVODetails.get(0).getSoNo());
//            salDoDQueryDTO.setDocStatus(DOC_STATUS_DONE);
//            log.info("销售验收单明细(oms方查询){}", JSON.toJSONString(salDoDQueryDTO));
//            return rmiOrderSalSoDService.queryDodForExam(salDoDQueryDTO).getData();
//        } else {
//            return Collections.emptyList();
//        }
//    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void apprAcc(Long id, String apprStatus) {
//        if (!StrUtil.equalsAny(apprStatus, UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(), UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode())) {
//            throw new BusinessException("不支持该操作");
//        }
//        var salAcceptanceDO = this.findSalAcceptanceDO(id);
//        if (!UdcEnum.COM_APPR_STATUS_APPROVING.getValueCode().equals(salAcceptanceDO.getAcStatus())) {
//            throw new BusinessException("该验收单非待审核状态，不支持该操作");
//        }
//        List<SalAcceptanceDDO> salAcceptanceDDOS = salAcceptanceDRepo.findAllByMasId(id);
//        // 修改验收单状态及审批状态
////        salAcceptanceDO.setApprStatus(apprStatus);
//        if (UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode().equals(apprStatus)) {
//            salAcceptanceDO.setAcStatus(UdcEnum.SAL_AC_STATUS_APPROVED.getValueCode());
//            if (!CollectionUtils.isEmpty(salAcceptanceDDOS)) {
//                this.updateOrderSal(salAcceptanceDDOS, 2);
//            }
//        } else {
//            salAcceptanceDO.setAcStatus(UdcEnum.SAL_AC_STATUS_REJECTED.getValueCode());
//            if (!CollectionUtils.isEmpty(salAcceptanceDDOS)) {
//                this.updateOrderSal(salAcceptanceDDOS, 3);
//            }
//        }
//        salAcceptanceRepo.save(salAcceptanceDO);
    }

    /**
     * 根据验收单ID查询，不存在报异常
     */
    private SalAcceptanceDO findSalAcceptanceDO(Long id) {
        return salAcceptanceRepo.findById(id).orElseThrow(new BusinessException("验收单不存在"));
    }

    /**
     * 拼接分页查询条件
     */
    private Predicate buildPageSearchCondition(SalAcceptancePagingParam pageParam) {
        Predicate predicate = qalAcceptanceDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (StrUtil.isNotBlank(pageParam.getDocNo())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.docNo.like("%" + pageParam.getDocNo() + "%"));
            }
            if (Objects.nonNull(pageParam.getOuId())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.ouId.eq(pageParam.getOuId()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.custId.eq(pageParam.getCustId()));
            }
            if (StrUtil.isNotBlank(pageParam.getContractNo())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.contractNo.like("%" + pageParam.getContractNo() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractName())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.contractName.like("%" + pageParam.getContractName() + "%"));
            }
            if (Objects.nonNull(pageParam.getApplyDate())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.applyDate.eq(pageParam.getApplyDate()));
            }
            if (Objects.nonNull(pageParam.getAcDate())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.acDate.eq(pageParam.getAcDate()));
            }
            if (StrUtil.isNotBlank(pageParam.getAcStatus())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.acStatus.eq(pageParam.getAcStatus()));
            }
            if (Objects.nonNull(pageParam.getApplyEmpId())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.applyEmpId.eq(pageParam.getApplyEmpId()));
            }
            if (Objects.nonNull(pageParam.getProjName())) {
                predicate = ExpressionUtils.and(predicate, qalAcceptanceDO.projName.like("%" + pageParam.getProjName() + "%"));
            }
        }
//        // 添加权限信息
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qalAcceptanceDO.getMetadata()));
        return predicate;
    }
}
