package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsDtlService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreDtlRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreDtlRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoProc;
import com.elitesland.yst.production.sale.rmi.ystaftersale.RmiAfterSaleRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiEmployeeRpcService;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wz
 * @title SalesmanInfoServiceImpl
 * @Date2023/2/21 16:08
 */
@Log4j2
@Service
@AllArgsConstructor
public class SaleStatisticsDtlServiceImpl implements SaleStatisticsDtlService {

    private final SaleStatisticsStoreDtlRepoProc saleStatisticsStoreDtlRepoProc;


    @Override
    @SysCodeProc
    public List<SaleStatisticsStoreDtlRespVO> selectByParam(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<SaleStatisticsStoreDtlRespVO> masIds = saleStatisticsStoreDtlRepoProc.selectByParam(queryVO);
        if (CollectionUtils.isEmpty(masIds)) {
            return Collections.emptyList();
        }
        return masIds;
    }


}
