package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoRpcService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSettingService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBankAccRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipAddressService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderToOmsService;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/28/15:47
 * @Description:
 */
@Service
@Slf4j
public class BipOrderToOmsServiceimpl extends BaseServiceImpl implements BipOrderToOmsService {
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private RmiOrgEmpService rmiOrgEmpService;

    @Autowired
    private RmiOrgOuService rmiOrgOuService;

    @Autowired
    private BipAddressService bipAddressService;

    @Autowired
    private CrmCustService crmCustService;

    @Autowired
    private BipAddressRepo bipAddressRepo;

    @Autowired
    private BipOrderDRepo bipOrderDRepo;

    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;

//    @Autowired
//    private PriSalePriceServiceImpl priSalePriceService;

//    @Autowired
//    private RmiOrderSalSoService rmiOrderSalSoService;

//    @Autowired
//    private RmiItemService rmiItemService;

    @Autowired
    private RmiCommonService rmiCommonService;

    @Autowired
    private RmiSettingService rmiSettingService;

    private static final String SETTING_CODE = "ORDER_AUTO_SIGN_DAY";

    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;

    @Autowired
    private RmiDoRpcService rmiDoRpcService;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Autowired
    private BipMessageRepo bipMessageRepo;

//    @Autowired
//    private SalReceiptService salReceiptService;

    @Autowired
    private MktDiscountGiftRepoProc mktDiscountGiftRepoProc;

    @Autowired
    private RmiOrgAddrService rmiOrgAddrService;

    @Autowired
    private MktGiftRepoProc mktGiftRepoProc;

    @Autowired
    private MktGiftRepo mktGiftRepo;

    /**
     * 同步订单中心
     *
     * @param orderId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sendToOms(Long orderId) {
        log.info("订单同步");
//
//        ToBSalSoSaveDTO toBSalSoSaveDTO = new ToBSalSoSaveDTO();
//
//        BipOrderDO bipOrderDo = bipOrderRepo.findById(orderId).get();
//
//        buildDtoInfo(toBSalSoSaveDTO, bipOrderDo);
//
//        List<BipOrderDDO> bipOrderDDOS = bipOrderDRepo.findByOrderId(orderId);
//        List<ToBSalSoDSaveDTO> toBSalSoDSaveDTOs = new ArrayList<>();
//
//        bipOrderDDOS.stream().forEach(bipOrderDDO -> {
//            ToBSalSoDSaveDTO toBSalSoDSaveDTO = new ToBSalSoDSaveDTO();
//            buildDDtoItemInfo(toBSalSoDSaveDTO, bipOrderDDO);
//            AtomicInteger count = new AtomicInteger(bipOrderDDO.getLineNo());
//            toBSalSoDSaveDTO.setPayStatus(toBSalSoSaveDTO.getPayStatus());
//            toBSalSoDSaveDTOs.add(toBSalSoDSaveDTO);
//            //查询赠品信息
//            if(!StringUtils.isEmpty(bipOrderDDO.getGiftCodes())){
//                List<Long> giftCodes = Arrays.asList(bipOrderDDO.getGiftCodes().split(","))
//                        .stream().map(a->Long.parseLong(a)).collect(Collectors.toList());
//                List<MktGiftDO> giftList = mktGiftRepo.findByIdIn(giftCodes);
//                log.info("giftList----------------:"+JSON.toJSONString(giftList));
//                if(null != giftList && !giftList.isEmpty()){
//                    for (var gift : giftList) {
//                        count.addAndGet(1);
//                        //订单明细
//                        ToBSalSoDSaveDTO salSoDSaveDTO = new ToBSalSoDSaveDTO();
//                        salSoDSaveDTO.setAllocQty(BigDecimal.ZERO);
//                        salSoDSaveDTO.setAllocStatus("0");
//                        salSoDSaveDTO.setAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setBasePrice(BigDecimal.ZERO);
//                        salSoDSaveDTO.setCardAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setConfirmStatus("0");
//                        salSoDSaveDTO.setCouponAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setDiscAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setDiscNetAmt(BigDecimal.ZERO);
////                        Long skuId = gift.getSkuId();shipping
////                        Optional<BipItemSkuDO> optional = bipItemSkuRepo.findById(skuId);
////                        if (optional.isPresent()) {
////                            BipItemSkuDO skuDo = optional.get();
//                        salSoDSaveDTO.setItemCode(gift.getItemCode());
//                        salSoDSaveDTO.setItemName(gift.getItemName());
//                        String skuCode = bipOrderDDO.getSkuCode();
//                        List<String> itemCodes = new ArrayList<>();
//                        itemCodes.add(skuCode);
//                        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
//                        itmItemRpcDtoParam.setItemCodes(itemCodes);
//
//                        log.info("同步订单中心查询供应商参数---itmItemRpcDtoParam" + JSON.toJSONString(itmItemRpcDtoParam));
//
//                        List<ItmItemRpcDTO> itmItemRpcDTOList = rmiItemService.findItemListByParam(itmItemRpcDtoParam);
//
//                        log.info("调用供应商返回信息:" + JSON.toJSONString(itmItemRpcDTOList));
//                        ItmItemRpcDTO itmItemRpcDTO = itmItemRpcDTOList.get(0);
//
//                        salSoDSaveDTO.setUom(itmItemRpcDTO.getUom());
//                        log.info("是否一件代发:" + itmItemRpcDTO.getAllocType());
//                        if ("SUPP".equals(itmItemRpcDTO.getAllocType())) {
//                            salSoDSaveDTO.setSuppFlag("1");
//                            if (itmItemRpcDTO.getSuppId() == null) {
//                                throw new BusinessException("商品的供应商id为空!");
//                            }
//                            salSoDSaveDTO.setSuppId(itmItemRpcDTO.getSuppId());
//                            salSoDSaveDTO.setAllocStatus("NONEED");
//                        }else{
//                            salSoDSaveDTO.setSuppFlag("0");
//                        }
////                        }
//                        salSoDSaveDTO.setLineType("102");
//                        salSoDSaveDTO.setLogisStatus("0");
//                        salSoDSaveDTO.setNetAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setNetPrice(BigDecimal.ZERO);
//                        salSoDSaveDTO.setOpenAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setOrignAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setOrignNetAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setOuterNo(bipOrderDo.getDocNo());
//                        salSoDSaveDTO.setPayStatus(toBSalSoSaveDTO.getPayStatus());
//                        salSoDSaveDTO.setPayedAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setPrice(BigDecimal.ZERO);
//                        salSoDSaveDTO.setQty(BigDecimal.ONE);
//                        salSoDSaveDTO.setTaxAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setTaxRate(BigDecimal.ZERO);
//                        salSoDSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setApAmt(BigDecimal.ZERO);
//                        salSoDSaveDTO.setOuterLineno(String.valueOf(count.get()));
//                        salSoDSaveDTO.setTaxRateNo("CNVAT0");
//                        //是否需要安装
//                        ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//                        List<String> skuCodes = new ArrayList<>();
//                        skuCodes.add(gift.getSkuCode());
//                        codeparam.setItemCodes(skuCodes);
//                        log.info("查询支撑域商品-----参数：-----------"+JSON.toJSONString(codeparam));
//                        List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//                        log.info("查询支撑域商品-----返回：-----------"+JSON.toJSONString(dtos));
//                        if(null != dtos && !dtos.isEmpty()){
//                            Boolean inInstall = dtos.get(0).getInstallFlag();
//                            if(null != inInstall){
//                                salSoDSaveDTO.setNeedServiceFlag(String.valueOf(inInstall));
//                            }
//                        }
//
//
//                        toBSalSoDSaveDTOs.add(salSoDSaveDTO);
//                    }
//                }
//            }
////            List<String> giftCodes = Arrays.asList(bipCartItemRespVO.getGiftCodes().split(","));
////            List<Long> skuIds = new ArrayList<>();
////            skuIds.add(bipCartItemRespVO.getSkuId());
////            List<BipGiftVO> giftList = mktDiscountGiftRepoProc.getGiftListByCode(giftCodes,skuIds,null).fetch();
////            List<Long> giftIds = giftList.stream().filter(a->a.getId()!=null).map(BipGiftVO::getId).collect(Collectors.toList());
////            mktGiftRepo.updateMktGiftById(giftIds);
//        });
//
//
//        toBSalSoSaveDTO.setToBSalSoDSaveDTOS(toBSalSoDSaveDTOs);
//
//        toBSalSoSaveDTO.setDocType2("B");
//        toBSalSoSaveDTO.setDocStatus("CF");
//        //运费行  运费大于0需要传给OMS运费行
//        if(bipOrderDo.getFareAmt().compareTo(BigDecimal.ZERO) > 0){
//            ToBSalSoDSaveDTO freeNum = getFreeInfo(bipOrderDo,toBSalSoDSaveDTOs.size());
//            toBSalSoDSaveDTOs.add(freeNum);
//        }
//
//        buildDtoAmtInfo(toBSalSoDSaveDTOs, toBSalSoSaveDTO);
//
//
//        if(bipOrderDo.getPayMethodName().equals("offline")){
//            toBSalSoSaveDTO.setDocStatus("HD");
//        }
//        ToBSalSoSaveDTO dto = toBSalSoSaveDTO;
//        dto.setPayedAmt(BigDecimal.ZERO);
//
//        dto.getToBSalSoDSaveDTOS().stream().forEach(dots ->{
//            dots.setPayedAmt(BigDecimal.ZERO);
//        });
//
//
//
//        log.info("订单同步参数:"+JSON.toJSONString(dto));
//        ApiResult<Long> result=rmiOrderSalSoService.ToBOrderSave(toBSalSoSaveDTO);
//        if(!result.isSuccess()&&"200".equals(result.getCode())){
//            throw new BusinessException("订单同步失败!");
//        }
//
////        收款单
//        //线下支付不生成收款单
//        if(bipOrderDo.getPayMethodName().equals("online")){
//
//            SalReceiptSaveParam salReceiptSaveParam=buildReceiptInfo(toBSalSoSaveDTO);
//            SalReceiptRespVO vo = salReceiptSaveParam.getSalReceiptRespVO();
//            vo.setCreateUserId(bipOrderDo.getCreateUserId());
//            vo.setPlanReceiptDate(bipOrderDo.getPayTime());
//            vo.setReceiptSerial(bipOrderDo.getTxsn());
//            if(null != vo){
//                vo.setCreator(bipOrderDo.getCreator());
//                RmiOrgBankAccRpcVO bankAccRpcVO = getVirtualInfo(bipOrderDo.getOuId());
//                if(null != bankAccRpcVO){ //方式，账号 主数据 ouBankAcc ouHolderName payMethod
//                    //收款账号
//                    vo.setOuBankAcc(bankAccRpcVO.getBankAcc());
//                    //开户人姓名
//                    vo.setOuHolderName(bankAccRpcVO.getHolderName());
//                    vo.setPayMethod("CNCP");
//
//                    List<SalReceiptdRespVO> salReceiptdRespVOS = vo.getSalReceiptdRespVOS();
//                    if(null != salReceiptdRespVOS && !salReceiptdRespVOS.isEmpty()){
//                   //     salReceiptdRespVOS = salReceiptdRespVOS.stream().filter(v -> null !=v.getReceiptAmt() && v.getReceiptAmt().compareTo(BigDecimal.ZERO)==1).collect(Collectors.toList());
//                        log.info("salReceiptdRespVOS：-----------------"+JSON.toJSONString(salReceiptdRespVOS));
//                        salReceiptdRespVOS.stream().forEach(vos ->{
//                            //大于0
//                            if(vos.getReceiptAmt().compareTo(BigDecimal.ZERO)==1){
//                                //查询oms订单ID和明细ID
//                                ToBGetSalRSoIdDTO toBGetSalRSoIdDTO = new ToBGetSalRSoIdDTO();
//                                toBGetSalRSoIdDTO.setDocNo(toBSalSoSaveDTO.getOuterNo());
//                                toBGetSalRSoIdDTO.setItemCode(vos.getItemCode());
//                                log.info("查询oms订单id参数---------:"+JSON.toJSONString(toBGetSalRSoIdDTO));
//                                if(null == vos.getSoId() || null == vos.getSoDId()){
//                                    ApiResult<Object> omsId = rmiOrderSalSoService.GetRsoIdAndDid(toBGetSalRSoIdDTO);
//                                    log.info("查询oms订单id参数返回---------"+JSON.toJSONString(omsId));
//                                    if(null != omsId && omsId.getCode() == 200 && null != omsId.getData()){
//                                        Map<String,Long> map = (Map<String, Long>) omsId.getData();
//                                        vos.setSoId(map.get("id"));
//                                        vos.setSoDId(map.get("did"));
//                                    }
//                                }
//                            }
//                        });
//                    }
//                }
//                salReceiptSaveParam.setSalReceiptRespVO(vo);
//            }
//
//            log.info("收款单信息----"+JSON.toJSONString(salReceiptSaveParam));
//
//            try {
//                ApiResult result1=salReceiptService.saveOrSubmit(salReceiptSaveParam);
//                log.info("收款单响应信息--"+JSON.toJSONString(result1));
//                if(result1.getCode()!=200){
//                    throw new BusinessException("收款单生成异常");
//                }
//            }catch (Exception e){
//                throw new BusinessException("收款单生成失败:"+e.getMessage());
//            }
//        }
//        bipOrderDo.setSyncOms(true);
//        bipOrderRepo.save(bipOrderDo);

    }

//    public ToBSalSoDSaveDTO getFreeInfo(BipOrderDO bipOrderDO,Integer size){
//        ToBSalSoDSaveDTO salSoDSaveDTO = new ToBSalSoDSaveDTO();
//        SysSettingVO settingByCode = rmiSettingService.findSettingByCode("ITEM_OF_FEE");
//        if (null == settingByCode){
//            throw new BusinessException("未配置运费商品");
//        }
//        String skuCode = settingByCode.getSettingVal();
//        List<String> itemCodes=new ArrayList<>();
//        itemCodes.add(skuCode);
//
//        ItmItemRpcDtoParam itmItemRpcDtoParam=new ItmItemRpcDtoParam();
//        itmItemRpcDtoParam.setItemCodes(itemCodes);
//        log.info("查询支撑域商品-----参数：-----------"+JSON.toJSONString(itmItemRpcDtoParam));
//        List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(itmItemRpcDtoParam));
//        log.info("查询支撑域商品-----返回：-----------"+JSON.toJSONString(dtos));
//        if(null != dtos && !dtos.isEmpty()){
//            Boolean inInstall = dtos.get(0).getInstallFlag();
//            if(null != inInstall){
//                if(inInstall){
//                    salSoDSaveDTO.setNeedServiceFlag("1");
//                }else {
//                    salSoDSaveDTO.setNeedServiceFlag("0");
//                }
//            }
//        }
//        log.info("调用供应商返回信息:"+JSON.toJSONString(dtos));
//        if(dtos==null||dtos.isEmpty()){
//            throw new BusinessException("商品中心查询数据为空!");
//        }
//        ItmItemRpcDTO itmItemRpcDTO=dtos.get(0);
//
//        salSoDSaveDTO.setUom(itmItemRpcDTO.getUom());
//        log.info("是否一件代发:"+itmItemRpcDTO.getAllocType());
//        if("SUPP".equals(itmItemRpcDTO.getAllocType())){
//            salSoDSaveDTO.setSuppFlag("1");
////            toBSalSoDSaveDTO.setSuppId(bipOrderDO.getSupplier());
//            if(itmItemRpcDTO.getSuppId()==null){
//                throw new BusinessException("商品的供应商id为空!");
//            }
//            salSoDSaveDTO.setSuppId(itmItemRpcDTO.getSuppId());
//            salSoDSaveDTO.setAllocStatus("NONEED");
//        }else{
//            salSoDSaveDTO.setSuppFlag("0");
//            salSoDSaveDTO.setAllocStatus("0");
//        }
//        if("10".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                salSoDSaveDTO.setLineType("101");
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                salSoDSaveDTO.setLineType("102");
//            }else{
//                salSoDSaveDTO.setLineType("101");
//            }
//
//        }
//        if("20".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                salSoDSaveDTO.setLineType("201");
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                salSoDSaveDTO.setLineType("202");
//            }else{
//                salSoDSaveDTO.setLineType("201");
//            }
//        }
//        if("30".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                salSoDSaveDTO.setLineType("301");
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                salSoDSaveDTO.setLineType("302");
//
//            }else{
//                salSoDSaveDTO.setLineType("301");
//            }
//        }
//        if(salSoDSaveDTO.getLineType()==null){
//            salSoDSaveDTO.setLineType("999");
//        }
//
//        salSoDSaveDTO.setAllocQty(BigDecimal.ZERO);
//        salSoDSaveDTO.setAllocStatus("0");
//        salSoDSaveDTO.setAmt(bipOrderDO.getFareAmt());
//        salSoDSaveDTO.setBasePrice(bipOrderDO.getFareAmt());
//        salSoDSaveDTO.setCardAmt(BigDecimal.ZERO);
//        salSoDSaveDTO.setConfirmStatus("0");
//        salSoDSaveDTO.setCouponAmt(BigDecimal.ZERO);
//        salSoDSaveDTO.setDiscAmt(BigDecimal.ZERO);
//        salSoDSaveDTO.setDiscNetAmt(BigDecimal.ZERO);
//        salSoDSaveDTO.setItemCode(itmItemRpcDTO.getItemCode());
//        salSoDSaveDTO.setItemName(itmItemRpcDTO.getItemName());
//        ItmItemBusinessRpcDtoParam param = new ItmItemBusinessRpcDtoParam();
//        param.setItemCodes(itemCodes);
//        List<ItmItemBusinessRpcDTO>  list = rmiItemService.findItmItemBusinessByParam(param);
//        if(null != list && !list.isEmpty()){
//            ItmItemBusinessRpcDTO itmItemBusinessRpcDTO = list.get(0);
//            //销项
//            salSoDSaveDTO.setTaxRate(itmItemBusinessRpcDTO.getTaxRate2());
//            salSoDSaveDTO.setTaxRateNo(itmItemBusinessRpcDTO.getTaxCode2());
//        }else {
//            //销项
//            salSoDSaveDTO.setTaxRate(itmItemRpcDTO.getTaxRate2());
//            salSoDSaveDTO.setTaxRateNo(itmItemRpcDTO.getTaxCode2());
//        }
//
//        salSoDSaveDTO.setPayingAmt(BigDecimal.ZERO);
//
//
//        salSoDSaveDTO.setLogisStatus("0");
//        salSoDSaveDTO.setOpenAmt(BigDecimal.ZERO);
//        salSoDSaveDTO.setOuterNo(bipOrderDO.getDocNo());
//        if("offline".equals(bipOrderDO.getPayMethodName())){
//            salSoDSaveDTO.setPayStatus("0");
//        }
//
//        if("online".equals(bipOrderDO.getPayMethodName())){
//            salSoDSaveDTO.setPayStatus("30");
//        }
//        salSoDSaveDTO.setPayedAmt(bipOrderDO.getFareAmt());
//
//        salSoDSaveDTO.setQty(BigDecimal.ONE);
//        salSoDSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//        salSoDSaveDTO.setApAmt(bipOrderDO.getFareAmt());
//        salSoDSaveDTO.setOuterLineno(String.valueOf(size + 1));
//        BigDecimal price = bipOrderDO.getFareAmt();
//        salSoDSaveDTO.setPrice(price);
//        BigDecimal taxAmt = (price.multiply(salSoDSaveDTO.getQty()).multiply(itmItemRpcDTO.getTaxRate2())).divide(BigDecimal.ONE.add(itmItemRpcDTO.getTaxRate2()),2,BigDecimal.ROUND_HALF_UP);
//        salSoDSaveDTO.setTaxAmt(taxAmt);
//
//        //未税金额
//        BigDecimal netPrice = BigDecimal.ZERO;
//        netPrice.setScale(8, BigDecimal.ROUND_HALF_UP);
//        netPrice = price.subtract(taxAmt);
//        //不含税价格
//        salSoDSaveDTO.setNetPrice(netPrice);
//
//
//        BigDecimal netAmt = BigDecimal.ZERO;
//        netAmt.setScale(2, BigDecimal.ROUND_HALF_UP);
//        //折扣未税额  netPrice
//        netAmt = netPrice.multiply(salSoDSaveDTO.getQty());
//        salSoDSaveDTO.setNetAmt(netAmt);
//
//
//        BigDecimal orignAmt = BigDecimal.ZERO;
//        orignAmt.setScale(2, BigDecimal.ROUND_HALF_UP);
//        //含税原金额 = 含税价格 * 数量
//        orignAmt = price.multiply(salSoDSaveDTO.getQty());
//        //未税原金额OrignNetAmt
//        salSoDSaveDTO.setOrignNetAmt(orignAmt);
//        //含税原金额
//        salSoDSaveDTO.setOrignAmt(orignAmt);
//
//
//
//        Boolean inInstall = itmItemRpcDTO.getInstallFlag();
//        if(null != inInstall){
//            if(inInstall){
//                salSoDSaveDTO.setNeedServiceFlag("1");
//            }else {
//                salSoDSaveDTO.setNeedServiceFlag("0");
//            }
//        }
//
//        return salSoDSaveDTO;
//        return null;
//    }





    //查询虚拟账号信息
    public RmiOrgBankAccRpcVO getVirtualInfo(Long ouId){
        //查询虚拟用户ID和账户
        List<RmiOrgBankAccRpcVO> resList = new ArrayList<>();
        log.info("订单公司ID:---"+ouId);
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam=new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        List<OrgOuRpcDTO> orgOuRpcDTOS = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        log.info("根据公司的信息获取到公司对应的地址号信息:-----"+JSON.toJSONString(orgOuRpcDTOS));
        if(null != orgOuRpcDTOS && !orgOuRpcDTOS.isEmpty()){
            OrgOuRpcDTO orgOuRpcDTO=orgOuRpcDTOS.get(0);
            OrgBankAccRpcDtoParam orgBankAccRpcDtoParam = new OrgBankAccRpcDtoParam();
            if(null != orgOuRpcDTO.getAddrNo()){
                List<Long> addNos = new ArrayList<>();
                addNos.add(orgOuRpcDTO.getAddrNo());
                orgBankAccRpcDtoParam.setAddrNos(addNos);
                log.info("根据地址信息获取银行信息参数:-----"+JSON.toJSONString(orgBankAccRpcDtoParam));
                List<RmiOrgBankAccRpcVO> list = rmiOrgAddrService.findBankAccRpcDtoByParam(orgBankAccRpcDtoParam);
                log.info("根据地址信息获取银行信息:-----"+JSON.toJSONString(list));
                if(null != list && !list.isEmpty()){
                    list.stream().forEach(l ->{
                        //收款账号
                        if(org.apache.commons.lang3.StringUtils.isNotBlank(l.getAccType()) && "IN".equals(l.getAccType()) && org.apache.commons.lang3.StringUtils.isNotBlank(l.getThirdpartyVirtualUserId()) && org.apache.commons.lang3.StringUtils.isNotBlank(l.getThirdpartyVirtualAcc())){
                            resList.add(l);
                        }
                    });
                }else {
                    throw new BusinessException("银行账户信息获取异常，参数:------"+JSON.toJSONString(orgBankAccRpcDtoParam));
                }
            }else {
                throw new BusinessException("支付时获取的参数:--------"+JSON.toJSONString(orgBankAccRpcDtoParam));
            }
        }
        if(null == resList || resList.isEmpty()){
            return null;
        }
        return resList.get(0);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void auOrderSignPush() {
        // 1.查询所有订单在自动签收范围之内的订单
        SysSettingVO settingByCode = rmiSettingService.findSettingByCode(SETTING_CODE);
        String settingVal = settingByCode.getSettingVal();
        List<String> aoOrders = bipOrderRepo.findAoOrders(Integer.parseInt(settingVal),
                UdcEnum.SAL_SO_STATUS_SHIP.getValueCode(),UdcEnum.SAL_SO_TYPE2_B.getValueCode(),
                UdcEnum.COM_DOC_CLS_SO.getValueCode(),UdcEnum.SAL_SO_TYPE_SOB1.getValueCode(),UdcEnum.SAL_SO_TYPE_SOB2.getValueCode());
        List<BipOrderDO> bipOrderDOList = bipOrderRepo.findAllByDocNoIn(aoOrders);
        // 查询签收人名称
//        List<String> accountIds = bipOrderDOList.stream().map(BipOrderDO::getContPerson).distinct().filter(Objects::nonNull)
//                .collect(Collectors.toList());
//        List<BipCustUserBindDO> allByUserIds = bipCustUserBindRepoProc.getAllByUserIds(accountIds);
        // 2.调用mos的方法进行签收
        bipOrderDOList.forEach(bip ->{
//            SalSoSignReqDto salSoSignReqDto = new SalSoSignReqDto();
//            salSoSignReqDto.setDocNo(bip.getDocNo());
//            SalDoSignUserInfoDto salDoSignUserInfoDto = new SalDoSignUserInfoDto();
//            salDoSignUserInfoDto.setConfirmUserId(bip.getAdressId());
//            salDoSignUserInfoDto.setConfirmUserName(bip.getContPerson());
//            salSoSignReqDto.setSalDoSignUserInfoDto(salDoSignUserInfoDto);
//            if (!ObjectUtils.isEmpty(bip.getAdressId()) && !ObjectUtils.isEmpty(bip.getContPerson())){
//                ApiResult<Boolean> result = rmiDoRpcService.SignBySalSo(salSoSignReqDto);
//                if (result.isSuccess()){
//                    bip.setAutoSignFlag(Boolean.TRUE);
//                }else{
//                    bip.setAutoSignFlag(Boolean.FALSE);
//                }
//            }
        } );
        // 3.修改我方订单的状态
        List<BipOrderDO> bipOrderDOS = bipOrderDOList.stream().filter(b -> b.getAutoSignFlag().equals(Boolean.TRUE)).collect(Collectors.toList());
        List<BipOrderDO> bipOrderDOS1 = bipOrderDOS.stream().filter(b -> !ObjectUtils.isEmpty(b.getAdressId()) && !ObjectUtils.isEmpty(b.getContPerson())).collect(Collectors.toList());
        bipOrderDOS1.forEach(i -> i.setStatus(ConstantsSale.SIGNED));
        bipOrderRepo.saveAll(bipOrderDOS1);
        // 4.生成消息推送
        List<BipMessageDO> bipMessageDOS = bipOrderDOS1.stream().map(mes -> {
            BipMessageDO bipMessageDO = new BipMessageDO();
            bipMessageDO.setTitle("发货通知");
            bipMessageDO.setContext("您有订单已发货");
            bipMessageDO.setToCustId(mes.getCustAccountId());
            bipMessageDO.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            return bipMessageDO;
        }).collect(Collectors.toList());
        bipMessageRepo.saveAll(bipMessageDOS);
    }




//    public SalReceiptSaveParam buildReceiptInfo(ToBSalSoSaveDTO toBSalSoSaveDTO){
//        SalReceiptSaveParam salReceiptSaveParam=new SalReceiptSaveParam();
//
//        salReceiptSaveParam.setSaveFlag("SUBMIT");
//        SalReceiptRespVO salReceiptRespVO=new SalReceiptRespVO();
//
//        List<SalReceiptdRespVO> salReceiptdRespVOS=new ArrayList<>();
//
////        salReceiptSaveParam.setOffFlag("");
//        salReceiptRespVO.setOuId(toBSalSoSaveDTO.getOuId());
//        salReceiptRespVO.setOuCode(toBSalSoSaveDTO.getOuCode());
//        salReceiptRespVO.setOuName(toBSalSoSaveDTO.getOuName());
//
//        salReceiptRespVO.setCustId(toBSalSoSaveDTO.getCustId());
//        salReceiptRespVO.setCustCode(toBSalSoSaveDTO.getCustCode());
//        salReceiptRespVO.setCustName(toBSalSoSaveDTO.getCustName());
//
//        salReceiptRespVO.setDocType("RE");
//        salReceiptRespVO.setReceiptType("ONLINE_PRE");
//
//        salReceiptRespVO.setCurrCode(toBSalSoSaveDTO.getCurrCode());
//
//
//        salReceiptRespVO.setBuId(toBSalSoSaveDTO.getBuId());
//        salReceiptRespVO.setBuName(toBSalSoSaveDTO.getBuName());
//
//
//
//
////        CurrentUserDTO currentUserDTO= UserService.currentUser();
//        salReceiptRespVO.setCreateUserId(toBSalSoSaveDTO.getAgentEmpId());
//        salReceiptRespVO.setCreator(toBSalSoSaveDTO.getEmpName());
//
//        salReceiptRespVO.setApplyEmpId(toBSalSoSaveDTO.getAgentEmpId());
//        salReceiptRespVO.setApplyName(toBSalSoSaveDTO.getEmpName());
//
//        salReceiptRespVO.setApplyDate(LocalDateTime.now());
//
//        salReceiptRespVO.setAmt(toBSalSoSaveDTO.getAmt());
//
//        List<ToBSalSoDSaveDTO> toBSalSoDSaveDTOS=toBSalSoSaveDTO.getToBSalSoDSaveDTOS();
//
//        for(ToBSalSoDSaveDTO toBSalSoDSaveDTO:toBSalSoDSaveDTOS){
//            if(toBSalSoDSaveDTO.getAmt().compareTo(BigDecimal.ZERO) == 1){
//                SalReceiptdRespVO salReceiptdRespVO=new SalReceiptdRespVO();
//                salReceiptdRespVO.setItemCode(toBSalSoDSaveDTO.getItemCode());
//                salReceiptdRespVO.setItemName(toBSalSoDSaveDTO.getItemName());
//
//                salReceiptdRespVO.setSoNo(toBSalSoDSaveDTO.getOuterNo());
//                salReceiptdRespVO.setSoLineNo(BigDecimal.valueOf(Long.valueOf(toBSalSoDSaveDTO.getOuterLineno())));
//
//
//                salReceiptdRespVO.setReceiptAmt(toBSalSoDSaveDTO.getAmt());
//                salReceiptdRespVO.setReceiptTax(toBSalSoDSaveDTO.getTaxAmt());
//                salReceiptdRespVO.setSoUom(toBSalSoDSaveDTO.getUom());
//
//                salReceiptdRespVOS.add(salReceiptdRespVO);
//            }
//        }
//        salReceiptRespVO.setSalReceiptdRespVOS(salReceiptdRespVOS);
//        salReceiptSaveParam.setSalReceiptRespVO(salReceiptRespVO);
////        salReceiptRespVO
//        return salReceiptSaveParam;
//    }


    public void buildSalSoPriceInfo(BipOrderDDO bipOrderDDO) {

        if (bipOrderDDO.getCouponAmt() != null) {
        }

        if (bipOrderDDO.getDiscountAmt() != null) {
        }


    }
    /**
     * 构造公司信息
     *
     * @param toBSalSoSaveDTO
     * @param bipOrderDO
     */
//    public void buildDtoOuInfo(ToBSalSoSaveDTO toBSalSoSaveDTO, BipOrderDO bipOrderDO) {
//        toBSalSoSaveDTO.setOuId(bipOrderDO.getOuId());
//        toBSalSoSaveDTO.setOuCode(bipOrderDO.getOuCode());
//        toBSalSoSaveDTO.setOuName(bipOrderDO.getOuName());
//        toBSalSoSaveDTO.setBuId(bipOrderDO.getBuId());
//        toBSalSoSaveDTO.setBuCode(bipOrderDO.getBuCode());
//        toBSalSoSaveDTO.setBuName(bipOrderDO.getBuName());
//        toBSalSoSaveDTO.setDocCls("SO");
//        toBSalSoSaveDTO.setDocNo(bipOrderDO.getDocNo());
//
//        String docType="SOB1";
//        if("offline".equals(bipOrderDO.getPayMethodName())){
//            docType="SOB2";
//            toBSalSoSaveDTO.setPayStatus("0");
//        }
//
//        if("online".equals(bipOrderDO.getPayMethodName())){
//            docType="SOB1";
//            toBSalSoSaveDTO.setPayStatus("30");
//        }
//        toBSalSoSaveDTO.setDocType(docType);
//
//        toBSalSoSaveDTO.setDocTime(DateTimeUtil.FORMATTER_DATETIME.format(bipOrderDO.getOrderTime()==null? LocalDateTime.now():bipOrderDO.getOrderTime()));
//
//        toBSalSoSaveDTO.setSoScene("SO");
//
//        toBSalSoSaveDTO.setSoSource("WX");
//        toBSalSoSaveDTO.setAgentingFlag("0");
//        toBSalSoSaveDTO.setOuterNo(bipOrderDO.getDocNo());
//
//        toBSalSoSaveDTO.setCreateTime(DateTimeUtil.FORMATTER_DATETIME.format(bipOrderDO.getCreateTime()==null? LocalDateTime.now():bipOrderDO.getCreateTime()));
//        toBSalSoSaveDTO.setModifyTime(DateTimeUtil.FORMATTER_DATETIME.format(bipOrderDO.getModifyTime()==null? LocalDateTime.now():bipOrderDO.getCreateTime()));
//
//
//        toBSalSoSaveDTO.setInvStatus("0");
//
//        toBSalSoSaveDTO.setPayTime(DateTimeUtil.FORMATTER_DATETIME.format(bipOrderDO.getPayTime()==null? LocalDateTime.now():bipOrderDO.getCreateTime()));
//    }


    /**
     * 构造收货地址信息
     *
     * @param toBSalSoSaveDTO
     * @param bipOrderDO
     */
//    public void buildDtoAddressInfo(ToBSalSoSaveDTO toBSalSoSaveDTO, BipOrderDO bipOrderDO) {
//        Long custId = bipOrderDO.getCustId();
//        CrmCustDO crmCustDO = crmCustRepo.findById(custId).get();
//
//        BipAddressVO addrs =bipAddressService.findById(bipOrderDO.getAdressId());
////                bipAddressRepo.findById(bipOrderDO.getAdressId()).get();
//        if (addrs != null) {
////            toBSalSoSaveDTO.setRecvCountry(addrs.getc());
//            toBSalSoSaveDTO.setRecvProvince(addrs.getProvince());
//            toBSalSoSaveDTO.setRecvCity(addrs.getCity());
//            toBSalSoSaveDTO.setRecvCounty(addrs.getCounty());
//            toBSalSoSaveDTO.setRecvStreet(addrs.getStreet());
//            toBSalSoSaveDTO.setRecvDetailaddr(addrs.getDetailAddr());
//
//            toBSalSoSaveDTO.setCustContactName(addrs.getContPerson());
//            toBSalSoSaveDTO.setCustContactTel(addrs.getMobile());
//
//        }
//
//    }

    /**
     * 构造客户信息
     *
     * @param toBSalSoSaveDTO
     * @param bipOrderDO
     */
//    public void buildDtoCustInfo(ToBSalSoSaveDTO toBSalSoSaveDTO, BipOrderDO bipOrderDO) {
//        CrmCustDetailRespVO crmCustDetailRespVO = crmCustService.get(bipOrderDO.getCustId());
//        toBSalSoSaveDTO.setCustId(bipOrderDO.getCustId());
//        toBSalSoSaveDTO.setCustCode(crmCustDetailRespVO.getCustCode());
//        toBSalSoSaveDTO.setCustName(crmCustDetailRespVO.getCustName());
////        toBSalSoSaveDTO.setCustContactTel(crmCustDetailRespVO.getContactPhone());
////        toBSalSoSaveDTO.setCustContactEmail(crmCustDetailRespVO.getm);
//
//        // 获取业务员
//        toBSalSoSaveDTO.setAgentEmpId(bipOrderDO.getAgentEmpId());
//        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
//        param.setEmpIds(Arrays.asList(bipOrderDO.getAgentEmpId()));
//        List<OrgEmpRpcDTO> emp = rmiOrgEmpService.findEmpListByParam(param);
//        log.info("调用员工信息:"+JSON.toJSONString(emp));
//        emp.stream().filter(emp1 -> emp1.getId().equals(bipOrderDO.getAgentEmpId()))
//                .findFirst()
//                .ifPresent(oo -> {
//                    toBSalSoSaveDTO.setEmpCode(oo.getEmpCode());
//                    toBSalSoSaveDTO.setEmpName(oo.getEmpName());
//                });
//
//        // 获取本地币种
//        if (!StringUtils.isEmpty(bipOrderDO.getOuId())) {
//            List<Long> ouIds = new ArrayList<>();
//            ouIds.add(bipOrderDO.getOuId());
//            List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
//            log.info("调用公司信息:"+JSON.toJSONString(ouDtoList));
//            ouDtoList.stream().filter(ou -> ou.getId().equals(bipOrderDO.getOuId()))
//                    .findFirst()
//                    .ifPresent(
//                            ou2 -> {
//                                toBSalSoSaveDTO.setHomeCurr(ou2.getOuCurr());
//                                toBSalSoSaveDTO.setCurrCode(ou2.getOuCurr());
//                            }
//                    );
//        }
//
//    }

    /**
     * 构造固定值信息
     *
     * @param toBSalSoSaveDTO
     * @param bipOrderDO
     */
//    public void buildDtoFinalInfo(ToBSalSoSaveDTO toBSalSoSaveDTO, BipOrderDO bipOrderDO) {
//
//        toBSalSoSaveDTO.setCurrRate(BigDecimal.ONE);
//        toBSalSoSaveDTO.setCouponAmt(BigDecimal.ZERO);
////        if(null != bipOrderDO){
////            toBSalSoSaveDTO.setCouponAmt(bipOrderDO.getCouponAmt());
////        }else {
////            toBSalSoSaveDTO.setCouponAmt(BigDecimal.ZERO);
////        }
//
//        toBSalSoSaveDTO.setCardAmt(BigDecimal.ZERO);
//        toBSalSoSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//        toBSalSoSaveDTO.setDiscNetAmt(BigDecimal.ZERO);
//        toBSalSoSaveDTO.setOpenAmt(BigDecimal.ZERO);
//        toBSalSoSaveDTO.setTaxInclFlag("1");
//
//        toBSalSoSaveDTO.setFreightFee(bipOrderDO.getFareAmt());
//
//
//    }

    /**
     * 够赞订单金额信息
     *
     * @param toBSalSoDSaveDTOs
     * @param toBSalSoSaveDTO
     */
//    public void buildDtoAmtInfo(List<ToBSalSoDSaveDTO> toBSalSoDSaveDTOs, ToBSalSoSaveDTO toBSalSoSaveDTO) {
//        BigDecimal amt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setAmt(amt);
//
//        BigDecimal netAMt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getNetAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getNetAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setNetAmt(netAMt);
//
//        BigDecimal taxAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getTaxAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getTaxAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setTaxAmt(taxAmt);
//
//
//        BigDecimal orignAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getOrignAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getOrignAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setOrignAmt(orignAmt);
//
//        BigDecimal orignNetAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getOrignNetAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getOrignNetAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setOrignNetAmt(orignNetAmt);
//
//
//        BigDecimal apAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getApAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getApAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setApAmt(apAmt);
//
//        BigDecimal payedAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getPayedAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getPayedAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setPayedAmt(payedAmt);
//
//        BigDecimal openAmt = toBSalSoDSaveDTOs.stream().map(toBSalSoDSaveDTO -> {
//            if (toBSalSoDSaveDTO.getOpenAmt() == null) {
//                return BigDecimal.ZERO;
//            }
//            return toBSalSoDSaveDTO.getOpenAmt();
//        }).reduce(BigDecimal::add).get();
//        toBSalSoSaveDTO.setOpenAmt(openAmt);
//
//        toBSalSoSaveDTO.setDiscAmt(BigDecimal.ZERO);
//        toBSalSoSaveDTO.setDiscNetAmt(BigDecimal.ZERO);
//
//    }


    /**
     * 构造订单信息
     *
     * @param toBSalSoSaveDTO
     * @param bipOrderDD
     */
//    public void buildDtoInfo(ToBSalSoSaveDTO toBSalSoSaveDTO, BipOrderDO bipOrderDD) {
//        buildDtoOuInfo(toBSalSoSaveDTO, bipOrderDD);
//        buildDtoAddressInfo(toBSalSoSaveDTO, bipOrderDD);
//        buildDtoCustInfo(toBSalSoSaveDTO, bipOrderDD);
//        buildDtoFinalInfo(toBSalSoSaveDTO, bipOrderDD);
//    }

    ;


    /**
     * 构造订单商品行信息
     *
     * @param toBSalSoDSaveDTO
     * @param bipOrderDDO
     */
//    public void buildDDtoItemInfo(ToBSalSoDSaveDTO toBSalSoDSaveDTO, BipOrderDDO bipOrderDDO) {
//
//        log.info("同步订单中心ToBSalSoDSaveDTO---"+ JSON.toJSONString(toBSalSoDSaveDTO));
//        log.info("同步订单中心---BipOrderDDO"+ JSON.toJSONString(bipOrderDDO));

//
//        toBSalSoDSaveDTO.setOuterNo(bipOrderDDO.getOrderDocNo());
//        toBSalSoDSaveDTO.setOuterLineno(String.valueOf(bipOrderDDO.getLineNo()));
//
//        toBSalSoDSaveDTO.setNoinvAmt(bipOrderDDO.getPayAmt());
//        toBSalSoDSaveDTO.setNoinvQty(BigDecimal.valueOf(bipOrderDDO.getBuyQty()));
//
////        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(bipOrderDDO.getSkuId()).get();
////
////        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findByBipItemIdAndSkuCode(bipOrderDDO.getItemId(),bipOrderDDO.getSkuCode());
////        if(bipItemSkuDO==null||bipItemSkuDO.getMateriel()==null||bipItemSkuDO.getType()==null){
////            bipItemSkuDO=new BipItemSkuDO();
////            bipItemSkuDO.setMateriel(bipOrderDDO.getMateriel());
////            bipItemSkuDO.setType(bipOrderDDO.getType());
////        }
////        BipItemSkuDO bipItemSkuDO=bipItemSkuRepoProc.queryByBipItemId(bipOrderDDO.getItemId());
////        log.info("商品sku信息:"+JSON.toJSONString(bipItemSkuDO));
//
//        String itemCode=bipOrderDDO.getItemCode();
//        String skuCode=bipOrderDDO.getSkuCode();
//        List<String> itemCodes=new ArrayList<>();
//        itemCodes.add(skuCode);
//        ItmItemRpcDtoParam itmItemRpcDtoParam=new ItmItemRpcDtoParam();
//        itmItemRpcDtoParam.setItemCodes(itemCodes);
//
//        //是否需要安装
//        ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//        codeparam.setItemCodes(itemCodes);
//            log.info("查询支撑域商品-----参数：-----------"+JSON.toJSONString(codeparam));
//        List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//        log.info("查询支撑域商品-----返回：-----------"+JSON.toJSONString(dtos));
//        if(null != dtos && !dtos.isEmpty()){
//            Boolean inInstall = dtos.get(0).getInstallFlag();
//            if(null != inInstall){
//                if(inInstall){
//                    toBSalSoDSaveDTO.setNeedServiceFlag("1");
//                }else {
//                    toBSalSoDSaveDTO.setNeedServiceFlag("0");
//                }
//
//            }
//        }
//        log.info("同步订单中心查询供应商参数---itmItemRpcDtoParam"+ JSON.toJSONString(itmItemRpcDtoParam));
//
//        List<ItmItemRpcDTO> itmItemRpcDTOList=rmiItemService.findItemListByParam(itmItemRpcDtoParam);
//
//        log.info("调用供应商返回信息:"+JSON.toJSONString(itmItemRpcDTOList));
//
//        if(itmItemRpcDTOList==null||itmItemRpcDTOList.isEmpty()){
//            throw new BusinessException("商品中心查询数据为空!");
//        }
//        ItmItemRpcDTO itmItemRpcDTO=itmItemRpcDTOList.get(0);
//
//        toBSalSoDSaveDTO.setUom(itmItemRpcDTO.getUom());
//        log.info("是否一件代发:"+itmItemRpcDTO.getAllocType());
//        if("SUPP".equals(itmItemRpcDTO.getAllocType())){
//            toBSalSoDSaveDTO.setSuppFlag("1");
////            toBSalSoDSaveDTO.setSuppId(bipOrderDO.getSupplier());
//            if(itmItemRpcDTO.getSuppId()==null){
//                throw new BusinessException("商品的供应商id为空!");
//            }
//
//            toBSalSoDSaveDTO.setSuppId(itmItemRpcDTO.getSuppId());
//            toBSalSoDSaveDTO.setAllocStatus("NONEED");
//        }else{
//            toBSalSoDSaveDTO.setSuppFlag("0");
//            toBSalSoDSaveDTO.setAllocStatus("0");
//        }
//
//        if("10".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("101");
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("102");
//            }else{
//                toBSalSoDSaveDTO.setLineType("101");
//            }
//
//        }
//
//        if("20".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("201");
//
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("202");
//
//            }else{
//                toBSalSoDSaveDTO.setLineType("201");
//            }
//        }
//
//        if("30".equals(itmItemRpcDTO.getItemType())){
//            if("10".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("301");
//
//            }
//            if("30".equals(itmItemRpcDTO.getItemType2())){
//                toBSalSoDSaveDTO.setLineType("302");
//
//            }else{
//                toBSalSoDSaveDTO.setLineType("301");
//            }
//        }
//
//        if(toBSalSoDSaveDTO.getLineType()==null){
//            toBSalSoDSaveDTO.setLineType("999");
//        }
//
//        toBSalSoDSaveDTO.setItemCode(bipOrderDDO.getSkuCode());
//        toBSalSoDSaveDTO.setItemName(bipOrderDDO.getItemName());
//
//        toBSalSoDSaveDTO.setQty(BigDecimal.valueOf(bipOrderDDO.getBuyQty()));
////        toBSalSoDSaveDTO.setUom(bipOrderDDO.getUom());
//
//
//        toBSalSoDSaveDTO.setBasePrice(bipOrderDDO.getBasePrice());
//        toBSalSoDSaveDTO.setDiscAmt(BigDecimal.ZERO);
//      //  toBSalSoDSaveDTO.setDiscAmt(bipOrderDDO.getDiscountAmt() == null?BigDecimal.ZERO : bipOrderDDO.getDiscountAmt());
//        toBSalSoDSaveDTO.setDiscNetAmt(BigDecimal.ZERO);
//
////        String skuCode = bipOrderDDO.getSkuCode();
//        List skuList = Arrays.asList(skuCode);
//
//        log.info("调用价格表参数信息:"+JSON.toJSONString(skuList));
//
//        List<BipInvItemDTO> bipInvItemDTOList = priSalePriceService.queryBasePriceByItemCode(skuCode);
//        log.info("调用价格表返回信息:"+JSON.toJSONString(bipInvItemDTOList));
//
//        if (bipInvItemDTOList != null&&!bipInvItemDTOList.isEmpty()) {
//            BipInvItemDTO bipInvItemDTO=bipInvItemDTOList.get(0);
//            BigDecimal taxRate = bipInvItemDTO.getTaxRate();
//            toBSalSoDSaveDTO.setTaxRate(taxRate);
//            String taxNo=bipInvItemDTO.getTaxRateNo();
//            toBSalSoDSaveDTO.setTaxRateNo(taxNo);
//
//            //未税金额
//            BigDecimal netPrice = BigDecimal.ZERO;
//            BigDecimal price = BigDecimal.ZERO;
//            BigDecimal basePrice = BigDecimal.ZERO;
//            if (bipOrderDDO.getBuyAmt() != null) {
//                BigDecimal buyAmt=bipOrderDDO.getBuyAmt()==null?BigDecimal.ZERO:bipOrderDDO.getBuyAmt();
//                //含税价格
//             //   price=buyAmt.divide((taxRate.add(BigDecimal.ONE)), 8, BigDecimal.ROUND_HALF_UP);
//           //     price=buyAmt.divide((taxRate.add(BigDecimal.ONE)), 8, BigDecimal.ROUND_HALF_UP);
//            //    price = buyAmt.multiply(new BigDecimal(bipOrderDDO.getBuyQty()));
//                price = buyAmt;
//            }
//            if (bipOrderDDO.getCustPrice() != null) {
//                basePrice = bipOrderDDO.getCustPrice()==null?BigDecimal.ZERO:bipOrderDDO.getCustPrice();
//            }
//
////            netPrice.setScale(2, BigDecimal.ROUND_DOWN);
//            //税额
//            BigDecimal taxAmt = BigDecimal.ZERO;
//            //税额
//            //taxAmt = netPrice.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty())).multiply(taxRate);
//            taxAmt = (price.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty())).multiply(taxRate)).divide(BigDecimal.ONE.add(taxRate),2,BigDecimal.ROUND_HALF_UP);
//    //        taxAmt = (price.multiply(taxRate)).divide(BigDecimal.ONE.add(taxRate),2, BigDecimal.ROUND_HALF_UP);
//    //        taxAmt=taxAmt.setScale(2, BigDecimal.ROUND_HALF_UP);
//            toBSalSoDSaveDTO.setTaxAmt(taxAmt);
//
//            //未税金额
//            netPrice.setScale(8, BigDecimal.ROUND_HALF_UP);
//            //不含税价格 = 含税价格/（税率+1）
//         //   netPrice = price.divide((taxRate.add(BigDecimal.ONE)), 8, BigDecimal.ROUND_HALF_UP);
//            netPrice = price.subtract(taxAmt);
//            toBSalSoDSaveDTO.setBasePrice(basePrice);
//            //含税价格
//            toBSalSoDSaveDTO.setPrice(price);
//            //不含税价格
//            toBSalSoDSaveDTO.setNetPrice(netPrice);
//
//
//
//
//            BigDecimal couponAmt=bipOrderDDO.getCouponAmt()==null?BigDecimal.ZERO:bipOrderDDO.getCouponAmt();
//            BigDecimal discountAmt=bipOrderDDO.getDiscountAmt()==null?BigDecimal.ZERO:bipOrderDDO.getDiscountAmt();
//            //折扣含税额
//           // toBSalSoDSaveDTO.setDiscAmt(couponAmt.add(discountAmt));
//            toBSalSoDSaveDTO.setCouponAmt(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setCardAmt(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//
//            //应支付金额
////            toBSalSoDSaveDTO.setApAmt(bipOrderDDO.getPayAmt()==null?BigDecimal.ZERO:bipOrderDDO.getPayAmt());
//
//            //应支付金额
//            toBSalSoDSaveDTO.setApAmt(bipOrderDDO.getBuyAmt().multiply(new BigDecimal(bipOrderDDO.getBuyQty())));
//
//            //已支付金额
////            toBSalSoDSaveDTO.setPayedAmt(bipOrderDDO.getPayDoneAmt()==null?BigDecimal.ZERO:bipOrderDDO.getPayDoneAmt());
//            toBSalSoDSaveDTO.setPayedAmt(bipOrderDDO.getBuyAmt().multiply(new BigDecimal(bipOrderDDO.getBuyQty())));
//            QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
//            BooleanExpression expression = qBipOrderDO.docNo.eq(bipOrderDDO.getOrderDocNo()).and(qBipOrderDO.deleteFlag.eq(0));
//            Optional<BipOrderDO> optional = bipOrderRepo.findOne(expression);
//            if(optional.isPresent()){
//                BipOrderDO bipOrderDO = optional.get();
//                if(bipOrderDO.getPayMethodName().equals("offline")){
//                    //线下支付已付款应该为0
//                    toBSalSoDSaveDTO.setPayedAmt(BigDecimal.ZERO);
//                    toBSalSoDSaveDTO.setHoldReasonCode("NOPAY");
//                }
//            }
//
//            //未结金额
//            toBSalSoDSaveDTO.setOpenAmt(BigDecimal.ZERO);
//            //含税金额
//            //toBSalSoDSaveDTO.setAmt(bipOrderDDO.getPayAmt()==null?BigDecimal.ZERO:bipOrderDDO.getPayAmt());
//            toBSalSoDSaveDTO.setAmt(bipOrderDDO.getBuyAmt().multiply(new BigDecimal(bipOrderDDO.getBuyQty())));
//
//            BigDecimal netAmt = BigDecimal.ZERO;
//            netAmt.setScale(2, BigDecimal.ROUND_HALF_UP);
//            //折扣未税额  netPrice
////            netAmt = bipOrderDDO.getPayAmt().divide((taxRate.add(BigDecimal.ONE)), 2, BigDecimal.ROUND_HALF_UP);
//            netAmt = netPrice.multiply(new BigDecimal(bipOrderDDO.getBuyQty()));
//            toBSalSoDSaveDTO.setNetAmt(netAmt);
//
//            toBSalSoDSaveDTO.setPayStatus(bipOrderDDO.getStatus());
//
//            BigDecimal orignNetAmt = BigDecimal.ZERO;
//            orignNetAmt.setScale(2, BigDecimal.ROUND_HALF_UP);
//            //未税原金额
//            orignNetAmt = netPrice.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty()));
//            toBSalSoDSaveDTO.setOrignNetAmt(orignNetAmt);
//
//
//            BigDecimal orignAmt = BigDecimal.ZERO;
//            orignAmt.setScale(2, BigDecimal.ROUND_HALF_UP);
//            //含税原金额 = 含税价格 * 数量
//            orignAmt = price.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty()));
//            //未税原金额OrignNetAmt
//            toBSalSoDSaveDTO.setOrignNetAmt(orignAmt);
//            //含税原金额
//            toBSalSoDSaveDTO.setOrignAmt(orignAmt);
//
//            toBSalSoDSaveDTO.setAllocQty(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setLogisStatus("0");
//            toBSalSoDSaveDTO.setConfirmStatus("0");
////            toBSalSoDSaveDTO.setAllocStatus("0");
//            toBSalSoDSaveDTO.setRelateDocId(bipOrderDDO.getOrderId());
//            toBSalSoDSaveDTO.setRelateDocDid(bipOrderDDO.getId());
//            toBSalSoDSaveDTO.setPayingAmt(BigDecimal.ZERO);


//            log.info("同步订单中心子单数据---"+ JSON.toJSONString(toBSalSoDSaveDTO));
//        }


//        if (itmItemRpcDTOList != null&&!itmItemRpcDTOList.isEmpty()) {
//            ItmItemRpcDTO bipInvItemDTO = itmItemRpcDTOList.get(0);
//            BigDecimal taxRate = bipInvItemDTO.getTaxRate();
//
//            ComTaxRateRpcDtoParam comTaxRateRpcDtoParam=new ComTaxRateRpcDtoParam();
//            List<Double> list=new ArrayList<>();
//            list.add(Double.valueOf(taxRate.doubleValue()));
//            comTaxRateRpcDtoParam.setTaxRates(list);
//
//            log.info("调用税率参数信息:"+JSON.toJSONString(comTaxRateRpcDtoParam));
//            List<ComTaxRateRpcDTO> comTaxRateRpcDTOList=rmiCommonService.findTaxRateRpcDtoByParam(comTaxRateRpcDtoParam);
//
//            log.info("调用税率返回信息:"+JSON.toJSONString(itmItemRpcDTOList));
//
//            if(comTaxRateRpcDTOList!=null&&!comTaxRateRpcDTOList.isEmpty()){
//                ComTaxRateRpcDTO comTaxRateRpcDTO=comTaxRateRpcDTOList.get(0);
//                String taxRateNo=comTaxRateRpcDTO.getTaxRateNo();
//                toBSalSoDSaveDTO.setTaxRateNo(taxRateNo);
//            }else{
//                throw new BusinessException("查询税率编号异常!");
//            }
//
//            toBSalSoDSaveDTO.setTaxRate(bipInvItemDTO.getTaxRate());
//
//
//
//            BigDecimal netPrice = BigDecimal.ZERO;
//            BigDecimal price = BigDecimal.ZERO;
//            BigDecimal basePrice = BigDecimal.ZERO;
//            if (bipOrderDDO.getBuyAmt() != null) {
//                price = bipOrderDDO.getBuyAmt();
//            }
//            if (bipOrderDDO.getCustPrice() != null) {
//                basePrice = bipOrderDDO.getCustPrice();
//            }
//            netPrice.setScale(8, BigDecimal.ROUND_DOWN);
//            netPrice = price.divide((taxRate.add(BigDecimal.ONE)), 8, BigDecimal.ROUND_HALF_DOWN);
//            toBSalSoDSaveDTO.setBasePrice(basePrice);
//            toBSalSoDSaveDTO.setPrice(price);
//            toBSalSoDSaveDTO.setNetPrice(netPrice);
//
//            netPrice.setScale(2, BigDecimal.ROUND_DOWN);
//            BigDecimal taxAmt = BigDecimal.ZERO;
//            taxAmt = netPrice.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty())).multiply(taxRate);
//            taxAmt=taxAmt.setScale(2, BigDecimal.ROUND_DOWN);
//            toBSalSoDSaveDTO.setTaxAmt(taxAmt);
//
//            toBSalSoDSaveDTO.setDiscAmt(bipOrderDDO.getCouponAmt().add(bipOrderDDO.getDiscountAmt()));
//            toBSalSoDSaveDTO.setCouponAmt(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setCardAmt(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setUsePointAmt(BigDecimal.ZERO);
//
//
//            toBSalSoDSaveDTO.setApAmt(bipOrderDDO.getPayAmt());
//            toBSalSoDSaveDTO.setPayedAmt(bipOrderDDO.getPayDoneAmt());
//            toBSalSoDSaveDTO.setOpenAmt(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setAmt(bipOrderDDO.getPayAmt());
//
//            BigDecimal netAmt = BigDecimal.ZERO;
//            netAmt.setScale(2, BigDecimal.ROUND_DOWN);
//            netPrice = bipOrderDDO.getPayAmt().divide((taxRate.add(BigDecimal.ONE)), 2, BigDecimal.ROUND_HALF_DOWN);
//            toBSalSoDSaveDTO.setNetAmt(netAmt);
//
//            toBSalSoDSaveDTO.setPayStatus(bipOrderDDO.getStatus());
//
//            BigDecimal orignNetAmt = BigDecimal.ZERO;
//            orignNetAmt.setScale(2, BigDecimal.ROUND_DOWN);
//            orignNetAmt = netPrice.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty()));
//            toBSalSoDSaveDTO.setOrignNetAmt(orignNetAmt);
//
//
//            BigDecimal orignAmt = BigDecimal.ZERO;
//            orignAmt.setScale(2, BigDecimal.ROUND_DOWN);
//            orignAmt = price.multiply(BigDecimal.valueOf(bipOrderDDO.getBuyQty()));
//            toBSalSoDSaveDTO.setOrignNetAmt(orignAmt);
//            toBSalSoDSaveDTO.setOrignAmt(orignAmt);
//
//            toBSalSoDSaveDTO.setAllocQty(BigDecimal.ZERO);
//            toBSalSoDSaveDTO.setLogisStatus("0");
//            toBSalSoDSaveDTO.setConfirmStatus("0");
//            toBSalSoDSaveDTO.setAllocStatus("0");
//
//            log.info("同步订单中心子单数据---"+ JSON.toJSONString(toBSalSoDSaveDTO));
//        }


//    }


}
