package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackConvert;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDO;
import com.elitesland.yst.production.sale.entity.QSalAcceptanceDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.BipOrderBackProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/11/12 16:30
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BipOrderBackProcessServiceImpl implements BipOrderBackProcessService {

    private final JPAQueryFactory jpaQueryFactory;

    private final BipOrderBackRepo bipOrderBackRepo;

    private final BipOrderBackService bipOrderBackService;

    private final BipOrderBackRepoProc bipOrderBackRepoProc;

    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        //1,查询单据是否存在
        Optional<BipOrderBackDO> bipOrderBackDO = bipOrderBackRepo.findById(id);
        if (bipOrderBackDO.isPresent() == false) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }

        QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qBipOrderBackDO)
                .set(qBipOrderBackDO.procInstStatus, procInstStatus)
                .where(qBipOrderBackDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_DR.getValueCode());// 应需求要求，所有的未通过都是拒绝
                break;
            case INTERRUPT: // 中断执行
                jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_REJECTED.getValueCode());// 应需求要求，所有的未通过都是拒绝
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_REJECTED.getValueCode());//已拒绝
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_CL.getValueCode());//已拒绝
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());//审批中
                break;
            case APPROVED: // 审批通过
                if (!ObjectUtils.isEmpty(bipOrderBackDO.get().getBackType())){
                    if (UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(bipOrderBackDO.get().getBackType())){
                        jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_WH.getValueCode())//已审批
                                .set(qBipOrderBackDO.approvedTime, LocalDateTime.now())//审批完成时间
                        ;
                    }else if (UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(bipOrderBackDO.get().getBackType())){
                        jpaUpdateClause.set(qBipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_WK.getValueCode())//已审批
                                .set(qBipOrderBackDO.approvedTime, LocalDateTime.now())//审批完成时间
                        ;
                    }
                }
                break;
        }

        jpaUpdateClause.execute();

        Optional<BipOrderBackDO> bipOrderBackDO1 = bipOrderBackRepo.findById(id);
        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //todo:流程结束，处理业务
            BipOrderBackConvert backConvert = BipOrderBackConvert.INSTANCE;
            BipOrderBackSaveVO orderBackSaveVO = backConvert.doToSave(bipOrderBackDO1.get());
            if (UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(bipOrderBackDO.get().getBackType())){
                 orderBackSaveVO.setStatus(UdcEnum.SAL_RSO_STATUS_WH.getValueCode());
            }else if (UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(bipOrderBackDO.get().getBackType())){
                orderBackSaveVO.setStatus(UdcEnum.SAL_RSO_STATUS_WK.getValueCode());
            }
            bipOrderBackService.updateCheckStatus(orderBackSaveVO);
        }
        // 考虑库存因素，如果是取消该流程,回退到待提交状态或者是已取消状态时，把对应的库存回退掉
        if (procInstStatus.equals(ProcInstStatus.REJECTED) || procInstStatus.equals(ProcInstStatus.INTERRUPT)) {
            //todo:审批拒绝,处理业务
            BipOrderBackConvert backConvert = BipOrderBackConvert.INSTANCE;
            BipOrderBackSaveVO orderBackSaveVO = backConvert.doToSave(bipOrderBackDO1.get());
            orderBackSaveVO.setStatus(UdcEnum.SAL_RSO_STATUS_REJECTED.getValueCode());
            bipOrderBackService.updateCheckStatus(orderBackSaveVO);
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {
        log.info("通过ouId,自定义参数获取用户列表，时间:{},入参:{}",LocalDateTime.now(),businessKey);
        log.info("(B端退货工作流)入参",JSONObject.toJSONString(customParams));
        Long ouId = bipOrderBackRepoProc.getOuIdById(Long.valueOf(businessKey));
        log.info("(B端退货工作流)入参2",JSONObject.toJSONString(ouId));
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            // 3.通过公司和角色信息,调支撑域接口查用户获取id
            log.info("公司角色查询信息(B端退货){}",JSONObject.toJSONString(sysUserIdFlowRoleRpcParam));
            List<Long> userIdsByFlowRoles = rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            log.info("公司角色查询信息返回结果(B端退货){}",JSONObject.toJSONString(userIdsByFlowRoles));
            List<String> userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)){
                return CollUtil.newArrayList(userIds);
            }
        }catch (Exception e){
            log.error("findUserIdsByFlowRoles error:",e);
            throw new BusinessException("调用支撑域查询审批角色对应审批人异常"+e,e);
        }
        return null;
    }
}
