package com.elitesland.yst.production.sale.controller.common;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.common.DeAccountRoleService;
import com.elitesland.yst.production.sale.api.vo.param.com.DeAccountRoleParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.DeAccountRoleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/22 19:47
 */
@RestController
@RequestMapping(value = "/account/role", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "账户角色")
@Slf4j
@AllArgsConstructor
public class DeAccountRoleController {

    private final DeAccountRoleService deAccountRoleService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "查询当前用户下的账号角色")
    public ApiResult<List<DeAccountRoleVO>> searchCustAccount(@RequestBody DeAccountRoleParam param){
        return ApiResult.ok(deAccountRoleService.getRole(param));
    }


}
