package com.elitesland.yst.production.sale.controller.search.store;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.search.service.StatisticsDealerSearchService;
import com.elitesland.yst.production.sale.search.store.service.StatisticsStoreSearchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author wz
 * @Date 2023/07/05
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/statistics/store/search")
@RequiredArgsConstructor
@Api(value = "销售业绩统计-门店-beanSearch", tags = {"销售业绩统计-门店-beanSearch"})
public class StatisticsStoreSearchController {
    private final StatisticsStoreSearchService statisticsStoreSearchService;

    @PostMapping("/page")
    @ApiOperation("门店销售业绩分页查询")
    public ApiResult<PagingVO<SaleStatisticsStoreRespVO>> page(@RequestBody SaleStatisticsStoreQueryVO pageParam) {
        PagingVO<SaleStatisticsStoreRespVO> page = statisticsStoreSearchService.page(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/pageSum")
    @ApiOperation("门店销售业绩统计汇总")
    ApiResult<StatisticsStoreSumRespVO> pageSum(@RequestBody SaleStatisticsStoreQueryVO pageParam) {
        return ApiResult.ok(statisticsStoreSearchService.pageSum(pageParam));
    }

}
