package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipItemCategoryService;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemCategoryRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeAllRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemCategorySaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 商品品类
 *
 * @auther JinXK
 * @date 2021/8/6 11:47
 */
@Api(tags = "商品分类")
@ApiSupport(author = "Kaiser（wang shao）")
@RestController
@RequestMapping(value = "/bip/itemCat", produces = MediaType.APPLICATION_JSON_VALUE)
public class BipItemCategoryController extends BaseController {

    private final BipItemCategoryService categoryService;

    public BipItemCategoryController(BipItemCategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @ApiOperation(value = "商品分类树形数据获取")
    @ApiOperationSupport(order = 0)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ouId", value = "所属公司")
    })
    @GetMapping(value = "/tree")
    public ApiResult<List<ItemCatTreeAllRespVO>> tree(Long ouId) {
        return ouId == null ? categoryService.treeAll() : categoryService.treeAll(ouId);
    }

    @ApiOperation(value = "商品分类保存")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "")
    public ApiResult<Long> save(@RequestBody @Valid BipItemCategorySaveVO saveVO) {
        return categoryService.save(saveVO);
    }

    @ApiOperation(value = "商品分类修改")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "分类ID")
    })
    @PutMapping(value = "/{id}")
    public ApiResult<Long> update(@PathVariable Long id, @RequestBody @Valid BipItemCategorySaveVO saveVO) {
        return categoryService.update(saveVO, id);
    }

    @ApiOperation(value = "商品分类获取")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "分类ID")
    })
    @GetMapping(value = "/{id}")
    public ApiResult<BipItemCategoryRespVO> get(@PathVariable Long id) {
        return categoryService.get(id);
    }

    @ApiOperation(value = "切换是否启用")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "分类ID")
    })
    @PatchMapping(value = "/{id}/enable")
    public ApiResult<Long> updateEnable(@PathVariable Long id) {
        return categoryService.updateEnable(id);
    }

    @ApiOperation(value = "商品分类删除")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "分类ID")
    })
    @DeleteMapping(value = "/{id}")
    public ApiResult<Long> delete(@PathVariable Long id) {
        return categoryService.delete(id);
    }
}
