package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackToOmsServicei;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepoProc;
import com.elitesland.yst.production.sale.service.shop.BipOrderToOmsServiceimpl;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

@RestController
@RequiredArgsConstructor
@RequestMapping("/sale/cpcn")
@Slf4j
public class CPCNController {

    @Autowired
    private BipOrderService bipOrderService;

    @Autowired
    private BipOrderBackService bipOrderBackService;

    @Autowired
    private BipOrderBackRepoProc bipOrderBackRepoProc;

    @Autowired
    private BipOrderRepo bipOrderRepo;

    @Autowired
    private BipOrderToOmsServiceimpl bipOrderToOmsServiceimpl;

    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;

    @Autowired
    private BipOrderBackToOmsServicei bipOrderBackToOmsServicei;

    @Autowired
    private BipItemAppService bipItemAppService;

    /**
     * 中金支付的5011接口的回调方法。当5011在支付时，返回的status的状态是20时，会回调5018通知支付结果
     * @param request
     * @param response
     * @throws Exception
     */
    @PostMapping(value = "/paymentNotice")
    public void paymentNotice(HttpServletRequest request,HttpServletResponse response) throws Exception{
//        log.info("付款通知回调接口--");
//        CPCN5018Resp cpcn5018Resp = null;
//        // 1 获得参数message和signature
//        String message = request.getParameter("message");
//        log.info("message:"+message);
//
//        String signature = request.getParameter("signature");
//        log.info("signature:"+signature);
//
//        String isDgEnv = request.getParameter("isDgEnv");
//        log.info("isDgEnv:"+isDgEnv);
//
//        String digitalEnvelope = request.getParameter("digitalEnvelope");
//        log.info("digitalEnvelope:"+digitalEnvelope);
//
//        String signAlgorithm = request.getParameter("signAlgorithm");
//        log.info("signAlgorithm:"+signAlgorithm);
//
//        String signSN = request.getParameter("signSN");
//        log.info("signSN:"+signSN);
//
//        String encryptSN = request.getParameter("encryptSN");
//        log.info("encryptSN:"+encryptSN);
//
//        // 2 验证签名
//        CPCN5018Param cpcn5018Param = new CPCN5018Param(message,signature,isDgEnv,digitalEnvelope,signAlgorithm,signSN,encryptSN);
//
//        log.info("5018请求参数信息--"+JSON.toJSONString(cpcn5018Param));
//
//        CPCN5018Req cpcn5018Req = CPCNUtils.cpcn5018Request(cpcn5018Param);
//        log.info("5018请求参数解析--"+JSON.toJSONString(cpcn5018Req));
//
//        if("SUCCESS".equals(cpcn5018Req.getResponseCode())){
//            //支付成功
//            log.info("回调响应成功");
//           if(CPCNConstant.STATUS_5011_30.equals(cpcn5018Req.getStatus())){
//               String docNo=cpcn5018Req.getOrderNo();
//               String payState = getPayStatusByDocNo(docNo);
//               if(!payState.equals("ps")){
//                   String payStatus="ps";
//                   String status="shipping";
//                   String txsn=cpcn5018Req.getTxSN();
//                   BigDecimal amont=BigDecimal.valueOf(Long.valueOf(cpcn5018Req.getAmount()));
//                   amont=amont.divide(BigDecimal.valueOf(100));
//                   log.info("回调更新订单状态参数：{},{},{},{}",payStatus,status,txsn,amont); // ps,shipping,202111101244021257001697910,0.01
//
//                   bipOrderService.updateOrderPayStatus(payStatus,docNo,status,txsn, LocalDateTime.now(),amont);
//                   bipOrderService.updateOrderDPayDoneAmt(docNo);
//                   log.info("订单状态更新成功");
//                   //更新销量
//                   log.info("更新销量");
//                   bipItemAppService.updateItemSalNumAll(docNo);
//                   log.info("更新销量完成");
//                   BipOrderDO bipOrderDO=bipOrderRepoProc.findOrderByDocNo(docNo);
//                   log.info("同步订单信息开始---------------"+bipOrderDO.getDocNo());
//                   bipOrderToOmsServiceimpl.sendToOms(bipOrderDO.getId());
//               }
//           }
//
//            //支付失败
//           if(CPCNConstant.STATUS_5011_40.equals(cpcn5018Req.getStatus())){
//               String docNo=cpcn5018Req.getOrderNo();
//               String payStatus="pf";
//               String status="unpaid";
//               String txsn=cpcn5018Req.getTxSN();
//               log.info("回调更新订单状态参数：{},{},{}",payStatus,status,txsn);
//
//               bipOrderService.updateOrderPayStatus(payStatus,docNo,status,txsn,LocalDateTime.now(),BigDecimal.ZERO);
//
//           }
//
//           //交易关闭
//            if(CPCNConstant.STATUS_5011_50.equals(cpcn5018Req.getStatus())){
//                String docNo=cpcn5018Req.getOrderNo();
//                String payStatus="pc";
//                String status="unpaid";
//                String txsn=cpcn5018Req.getTxSN();
//                log.info("回调更新订单状态参数：{},{},{}",payStatus,status,txsn);
//
//                bipOrderService.updateOrderPayStatus(payStatus,docNo,status,txsn,LocalDateTime.now(),BigDecimal.ZERO);
//
//            }
//            log.info("回应中金回调");
//            cpcn5018Resp = new CPCN5018Resp("2000","OK");
//
//        }else{
//            log.info("中金回调响应信息为失败");
//        }
//
//        log.error("****中金回调参数cpcn5018Resp["+cpcn5018Resp.toString()+"]******");
//        String respStr = CPCNUtils.cpcn5018Response(cpcn5018Resp);
//        response.getWriter().write(respStr);
    }


    public String getPayStatusByDocNo(String docNo){
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.docNo.eq(docNo);
        Optional<BipOrderDO> option = bipOrderRepo.findOne(expression);
        if(null != option && !option.isEmpty()){
            BipOrderDO bipOrderDO = option.get();
            if(StringUtils.isNotBlank(bipOrderDO.getPayStatus())){
                return bipOrderDO.getPayStatus();
            }
            return "";
        }
        return "";
    }


    @PostMapping(value = "/returnNotice")
    public void returnNotice(HttpServletRequest request,HttpServletResponse response) throws Exception{
//        log.info("退款款通知回调接口--"+JSON.toJSONString(request));
//        CPCN5018Resp cpcn5018Resp = null;
//        // 1 获得参数message和signature
//        String message = request.getParameter("message");
//        log.info("message:"+message);
//
//        String signature = request.getParameter("signature");
//        log.info("signature:"+signature);
//
//        String isDgEnv = request.getParameter("isDgEnv");
//        log.info("isDgEnv:"+isDgEnv);
//
//        String digitalEnvelope = request.getParameter("digitalEnvelope");
//        log.info("digitalEnvelope:"+digitalEnvelope);
//
//        String signAlgorithm = request.getParameter("signAlgorithm");
//        log.info("signAlgorithm:"+signAlgorithm);
//
//        String signSN = request.getParameter("signSN");
//        log.info("signSN:"+signSN);
//
//        String encryptSN = request.getParameter("encryptSN");
//        log.info("encryptSN:"+encryptSN);
//
//        // 2 验证签名
//        CPCN5028Param cpcn5028Param = new CPCN5028Param(message,signature,isDgEnv,digitalEnvelope,signAlgorithm,signSN,encryptSN);
//        log.info("验证签名信息:--"+JSON.toJSONString(cpcn5028Param));
//
//
//        CPCN5028Req cpcn5028Req = CPCNUtils.cpcn5028Request(cpcn5028Param);
//        log.info("解析签名信息:--"+JSON.toJSONString(cpcn5028Req));
//
//        if("SUCCESS".equals(cpcn5028Req.getResponseCode())||"退款成功".equals(cpcn5028Req.getResponseMessage())){
//            //退款成功
//            log.info("退款回调响应成功");
//            if(CPCNConstant.STATUS_5021_20.equals(cpcn5028Req.getStatus())){
//                String docNo=cpcn5028Req.getOrderNo();
//                String status="DONE";
//                String txsn=cpcn5028Req.getTxSN();
//                bipOrderBackRepoProc.updateOrderBackStatus(docNo,status,txsn,LocalDateTime.now());
//                //生成退款单
//              //  bipOrderBackToOmsServicei.createSalReceiptService(docNo);
//
//
//            }else if(CPCNConstant.STATUS_5021_30.equals(cpcn5028Req.getStatus())){
//                String docNo=cpcn5028Req.getOrderNo();
//                BipOrderBackDO bipOrderBackDO=new BipOrderBackDO();
//                String msg=JSON.toJSONString(cpcn5028Req);
//                bipOrderBackRepoProc.updateOrderBackReturnMsg(docNo,msg);
//            }else{
//                log.info("退款状态异常!"+ JSON.toJSONString(cpcn5028Req));
//            }
//
//            log.info("退款回回应中金回调");
//            cpcn5018Resp = new CPCN5018Resp("2000","OK");
//
//        }else{
//            log.info("退款状态异常!"+ JSON.toJSONString(cpcn5028Req));
//
//        }
//
//        String respStr = CPCNUtils.cpcn5018Response(cpcn5018Resp);
//        response.getWriter().write(respStr);
    }
}
