package com.elitesland.yst.production.sale.controller.taskInfo;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoExportRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping(value = "/taskInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "业务员任务管理", tags = {"业务员任务管理"})
@RequiredArgsConstructor
public class TaskInfoController extends BaseController {

    private final TaskInfoService taskInfoService;

    @PostMapping(value = "/create")
    @ApiOperation(value = "业务员任务新增时保存/发布")
    public ApiResult<TaskInfoRespVO> createTask(@RequestBody @Validated TaskInfoSaveVO saveVO) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.createTask(saveVO);
        return ApiResult.ok(taskInfoRespVO);
    }

    @PostMapping(value = "/update")
    @ApiOperation(value = "业务员任务修改时保存/发布")
    public ApiResult<TaskInfoRespVO> updateTask(@RequestBody @Validated TaskInfoSaveVO saveVO) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.updateTask(saveVO);
        return ApiResult.ok(taskInfoRespVO);
    }

    @PostMapping("/page")
    @ApiOperation("任务分页查询")
    public ApiResult<PagingVO<TaskInfoRespVO>> page(@RequestBody TaskInfoQueryVO pageParam) {
        PagingVO<TaskInfoRespVO> page = taskInfoService.page(pageParam);
        return ApiResult.ok(page);
    }

    @GetMapping("/findIdOne/{id}")
    @ApiOperation("根据任务ID查询任务详情数据")
    public ApiResult<TaskInfoRespVO> findIdOne(@PathVariable Long id) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.findIdOne(id);
        return ApiResult.ok(taskInfoRespVO);
    }
    @GetMapping("/findPage/{id}")
    @ApiOperation("根据任务ID查询任务详情分页数据")
    public ApiResult<PagingVO<TaskInfoDtlRespVO>> findPage(@PathVariable Long id) {
        PagingVO<TaskInfoDtlRespVO> page = taskInfoService.findPage(id);
        return ApiResult.ok(page);
    }

    @GetMapping("/findCodeOne/{code}")
    @ApiOperation("根据任务编码查询任务详情数据")
    public ApiResult<TaskInfoRespVO> findCodeOne(@PathVariable String code) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.findCodeOne(code);
        return ApiResult.ok(taskInfoRespVO);
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据任务ID批量删除")
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        taskInfoService.deleteBatch(ids);
        return ApiResult.ok(ids);
    }

    @PutMapping("/cancel/{id}")
    @ApiOperation("根据任务ID取消")
    public ApiResult<Long> cancelTask(@PathVariable Long id) {
        taskInfoService.cancelTask(id);
        return ApiResult.ok(id);
    }

    @PutMapping("/release/{id}")
    @ApiOperation("根据任务ID发布")
    public ApiResult<Long> releaseTask(@PathVariable Long id) {
        taskInfoService.releaseTask(id);
        return ApiResult.ok(id);
    }

    @GetMapping("/accomplish/check/{id}")
    @ApiOperation("根据任务ID完成前置校验")
    public ApiResult<Boolean> accomplishCheckTask(@PathVariable Long id) {
        Boolean flag = taskInfoService.accomplishCheckTask(id);
        return ApiResult.ok(flag);
    }

    @PutMapping("/accomplish/{id}")
    @ApiOperation("根据任务ID完成")
    public ApiResult<Long> accomplishTask(@PathVariable Long id) {
        taskInfoService.accomplishTask(id);
        return ApiResult.ok(id);
    }

    @GetMapping("/close/check/{id}")
    @ApiOperation("根据任务ID关闭前置校验")
    public ApiResult<Boolean> closeCheckTask(@PathVariable Long id) {
        Boolean flag = taskInfoService.closeCheckTask(id);
        return ApiResult.ok(flag);
    }

    @PutMapping("/close/{id}")
    @ApiOperation("根据任务ID关闭")
    public ApiResult<Long> closeTask(@PathVariable Long id) {
        taskInfoService.closeTask(id);
        return ApiResult.ok(id);
    }

    @PostMapping("/overdue")
    @ApiOperation("是否逾期")
    public ApiResult<List<Long>> overdueTask(@RequestBody TaskInfoQueryVO queryVO) {
        List<Long> ids = taskInfoService.overdueTask(queryVO);
        return ApiResult.ok(ids);
    }

    @PostMapping(value = "/repeat/set/save")
    @ApiOperation(value = "任务重复设置保存")
    public ApiResult<TaskInfoRespVO> repeatSetSave(@RequestBody TaskInfoSaveVO saveVO) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.repeatSetSave(saveVO);
        return ApiResult.ok(taskInfoRespVO);
    }

    @GetMapping("/findByDtlId/{dtlId}")
    @ApiOperation("根据任务明细ID查询任务详情信息")
    public ApiResult<TaskInfoRespVO> findTaskByDtlId(@PathVariable Long dtlId) {
        TaskInfoRespVO taskInfoRespVO = taskInfoService.findTaskByDtlId(dtlId);
        return ApiResult.ok(taskInfoRespVO);
    }

    @PostMapping("/exportPage")
    @ApiOperation("任务导出分页查询-主表和明细")
    public ApiResult<PagingVO<TaskInfoExportRespVO>> exportPage(@RequestBody TaskInfoQueryVO pageParam) {
        PagingVO<TaskInfoExportRespVO> page = taskInfoService.exportPage(pageParam);
        return ApiResult.ok(page);
    }

}
