package com.elitesland.yst.production.sale.controller.zone;


import com.elitesland.yst.production.sale.api.service.ZoneSettingService;
import com.elitesland.yst.production.sale.api.service.shop.HotSelingService;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSaveSettingVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/zone/conf", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "专区设置")
@RequiredArgsConstructor
public class ZoneSettingController {

    private final ZoneSettingService zoneSettingService;
    private final HotSelingService hotSelingService;



    @GetMapping(value = "/ztest")
    @ApiOperation(value = "测试热销商品")
    @ApiOperationSupport(order = 2)
    public void test(){
        hotSelingService.update90HotSelling();
    }


    @PostMapping(value = "/zonePaging")
    @ApiOperation(value = "专区列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ZoneSettingVO>> findMenuConfPagingResult(@RequestBody ZoneSettingPageParam param){
        PagingVO<ZoneSettingVO> list = zoneSettingService.findZonePagingResult(param);
        return ApiResult.ok(list);
    }


    @GetMapping(value = "/zone/{id}")
    @ApiOperation(value = "通过ID查询专区")
    @ApiOperationSupport(order = 2)
    public ApiResult<ZoneSettingVO> findZoneById(@PathVariable Long id){
        ZoneSettingVO vo = zoneSettingService.findZoneById(id);
        return ApiResult.ok(vo);
    }


    @PostMapping(value = "/addOrUpdateZone")
    @ApiOperation(value = "新增/修改专区")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> addOrUpdateZone(@RequestBody ZoneSaveSettingVO param){
        return zoneSettingService.addOrUpdateZone(param);
    }

    @PostMapping(value = "/delZone")
    @ApiOperation(value = "删除")
    @ApiOperationSupport(order = 4)
    public ApiResult<Object> delZone(@RequestBody List<Long> ids){
        return zoneSettingService.delZone(ids);
    }


    @PostMapping(value = "/activeZone")
    @ApiOperation(value = "激活")
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> activeZone(@RequestBody List<Long> ids){
        return zoneSettingService.activeZone(ids);
    }

    @PostMapping(value = "/closedZone")
    @ApiOperation(value = "禁用")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> closedZone(@RequestBody List<Long> ids){
        return zoneSettingService.closedZone(ids);
    }

}
