package com.elitesland.yst.production.sale.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlImportRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoDtlSaveVO;
import com.elitesland.yst.production.sale.entity.TaskInfoDtlDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
@Mapper(config = BaseMapperConfig.class)
public interface TaskInfoDtlConvert {
    TaskInfoDtlConvert INSTANCE = Mappers.getMapper(TaskInfoDtlConvert.class);

    /**
     * saveVO转换DO
     *
     * @param saveVO 保存入参
     * @return DO
     */
    TaskInfoDtlDO saveVoToDo(TaskInfoDtlSaveVO saveVO);

    /**
     * DO转换RespVO
     *
     * @param taskInfoDtlDO 入参
     * @return RespVO
     */
    TaskInfoDtlRespVO doToRespVo(TaskInfoDtlDO taskInfoDtlDO);

    /**
     * respVO转换saveVO
     *
     * @param respVO 入参
     * @return saveVO
     */
    TaskInfoDtlSaveVO respVoToSaveVO(TaskInfoDtlRespVO respVO);

    /**
     * importRespVO转换respVO
     *
     * @param importRespVO 入参
     * @return respVO
     */
    TaskInfoDtlRespVO importVoToRespVo(TaskInfoDtlImportRespVO importRespVO);

}
