package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/9:20
 * @Description:轮播图
 */
@Entity
@Table(name = "bip_retation_chart")
@org.hibernate.annotations.Table(appliesTo = "bip_retation_chart", comment = "轮播图表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipRetationChartDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1219497099192211204L;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "offset_id", columnDefinition = "varchar(32)   comment '满减折扣Id'")
    private Long offsetId;

    @Column(name = "offset_code", columnDefinition = "varchar(32)   comment '满减折扣编码'")
    private String offsetCode;

    @Column(name = "offset_name", columnDefinition = "varchar(32)   comment '满减折扣名称'")
    private String offsetName;

    @Column(name = "gift_id", columnDefinition = "varchar(32)   comment '满赠折扣Id'")
    private Long giftId;

    @Column(name = "gift_code", columnDefinition = "varchar(32)   comment '满赠折扣编码'")
    private String giftCode;

    @Column(name = "gift_name", columnDefinition = "varchar(32)   comment '满赠折扣名称'")
    private String giftName;

    @Column(name = "retation_desc", columnDefinition = "varchar(1024)   comment '描述'")
    private String retationDesc;

    @Column(name = "priority", columnDefinition = "varchar(32)   comment '优先级'")
    private String priority;

    @Column(name = "pic_id", columnDefinition = "bigInt(20)   comment '图片id'")
    private Long picId;

    @Column(name = "image_size", columnDefinition = "varchar(32)   comment '图片尺寸'")
    private String imageSize;

    @Column(name = "last_time", columnDefinition = "bigInt(20)    comment '轮播图停留时间，单位s'")
    private Long lastTime;

    @Column(name = "stime", columnDefinition = "datetime comment '开始时间'")
    private LocalDateTime stime;

    @Column(name = "etime", columnDefinition = "datetime comment '结束时间'")
    private LocalDateTime etime;

    @Column(name = "status", columnDefinition = "varchar(32)   comment '状态'")
    private String status;

}
