package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录明细模板表
 */
@Entity
@Table(name="exect_record_dtl_temp")
@org.hibernate.annotations.Table(appliesTo = "exect_record_dtl_temp", comment = "执行记录明细模板表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExectRecordDtlTempDO extends BaseModel {

    @Column(name = "record_id", columnDefinition = "bigint(20) comment '记录id'")
    private Long recordId;

    @Column(name = "name", columnDefinition = "varchar(255) comment '名称'")
    private String name;

    @Column(name = "val", columnDefinition = "varchar(255) comment '值'")
    private String val;

    @Column(name = "content", columnDefinition = "varchar(255) comment '内容'")
    private String content;

    @Column(name = "reason", columnDefinition = "varchar(255) comment '原因'")
    private String reason;

    @Column(name = "type", columnDefinition = "varchar(255) comment '类型(文本/单选/多选/下拉/图片)'")
    private String type;

    @Column(name = "sort", columnDefinition = "int(11) comment '排序'")
    private Integer sort;
    @Column(name = "required_flag", columnDefinition = "tinyint(1) comment '是否必填'")
    private Boolean requiredFlag;


}