package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-11
 * @desc : 执行记录模板
 */
@Entity
@Table(name="exect_record_temp")
@org.hibernate.annotations.Table(appliesTo = "exect_record_temp", comment = "执行记录模板")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExectRecordTempDO extends BaseModel {

    @Column(name = "temp_code", columnDefinition = "varchar(255) comment '模板编码'")
    private String tempCode;

    @Column(name = "temp_name", columnDefinition = "varchar(255) comment '模板名称'")
    private String tempName;

    @Column(name = "ou_id", columnDefinition = "varchar(255) comment '公司id'")
    private String ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(255) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;

    @Column(name = "state", columnDefinition = "varchar(255) comment '状态'")
    private String state;

    @Column(name = "task_type", columnDefinition = "varchar(255) comment '任务类型'")
    private String taskType;

    @Column(name = "temp_desc", columnDefinition = "varchar(255) comment '模板描述'")
    private String tempDesc;


}