package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Shadow（li qun）
 * @since 2021-11-22 16:50
 */
@Entity
@Table(name = "sal_commission_rule",indexes = {
        @Index(name = "idx_sal_commission_rule_ou_code", columnList = "ou_code"),
        @Index(name = "idx_sal_commission_rule_ou_name", columnList = "ou_name"),
        @Index(name = "idx_sal_commission_rule_commission_rule", columnList = "commission_rule")
})
@org.hibernate.annotations.Table(appliesTo = "sal_commission_rule", comment = "业绩提成规则")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalCommissionRuleDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 8817989068237494062L;

    @Column(name = "ou_id", columnDefinition = "bigint(20) default null  comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40) not null comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) not null comment '公司名称'")
    private String ouName;

    @Column(name = "item_cate_code", columnDefinition = "varchar(40) default null  comment '商品品类编号'")
    private String itemCateCode;

    @Column(name = "item_id", columnDefinition = "bigint(20) default null comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40) default null comment '商品编号'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255) default null comment '商品名称'")
    private String itemName;

    @Column(name = "commission_rule", columnDefinition = "varchar(40) not null comment '提成规则 UDC:SAL/COMMISSION_RULE'")
    private String commissionRule;

    @Column(name = "percentage", columnDefinition = "decimal(20,2) comment '提成百分比'")
    private BigDecimal percentage;

    @Column(name = "piece_wage", columnDefinition = "decimal(20,2) comment '计件提成每件提成（元）'")
    private BigDecimal pieceWage;

}
